/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class AnnotationUtils {
    private static final ToStringStyle TO_STRING_STYLE = new ToStringStyle(){
        private static final long serialVersionUID = 1L;
        {
            this.setDefaultFullDetail(true);
            this.setArrayContentDetail(true);
            this.setUseClassName(true);
            this.setUseShortClassName(true);
            this.setUseIdentityHashCode(false);
            this.setContentStart("(");
            this.setContentEnd(")");
            this.setFieldSeparator(", ");
            this.setArrayStart("[");
            this.setArrayEnd("]");
        }

        @Override
        protected final String getShortClassName(Class<?> cls) {
            Class<?> clazz = null;
            for (Class<?> clazz2 : ClassUtils.getAllInterfaces(cls)) {
                Class<?> clazz3;
                if (!Annotation.class.isAssignableFrom(clazz2)) continue;
                clazz = clazz3 = clazz2;
                break;
            }
            return new StringBuilder(clazz == null ? "" : clazz.getName()).insert(0, '@').toString();
        }

        @Override
        protected final void appendDetail(StringBuffer buffer, String fieldName, Object value) {
            if (value instanceof Annotation) {
                value = AnnotationUtils.toString((Annotation)value);
            }
            super.appendDetail(buffer, fieldName, value);
        }
    };

    public static boolean equals(Annotation a1, Annotation a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        Class<? extends Annotation> clazz = a1.annotationType();
        Class<? extends Annotation> clazz2 = a2.annotationType();
        Validate.notNull(clazz, "Annotation %s with null annotationType()", a1);
        Validate.notNull(clazz2, "Annotation %s with null annotationType()", a2);
        if (!clazz.equals(clazz2)) {
            return false;
        }
        try {
            for (Method method : clazz.getDeclaredMethods()) {
                if (method.getParameterTypes().length != 0 || !AnnotationUtils.isValidAnnotationMemberType(method.getReturnType())) continue;
                Object object = method.invoke((Object)a1, new Object[0]);
                Object object2 = method.invoke((Object)a2, new Object[0]);
                if (AnnotationUtils.memberEquals(method.getReturnType(), object, object2)) continue;
                return false;
            }
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            return false;
        }
        return true;
    }

    public static int hashCode(Annotation a2) {
        int n2 = 0;
        Class<? extends Annotation> clazz = a2.annotationType();
        for (Method method : clazz.getDeclaredMethods()) {
            Object object;
            try {
                object = method.invoke((Object)a2, new Object[0]);
                if (object == null) {
                    throw new IllegalStateException(String.format("Annotation method %s returned null", method));
                }
                n2 += AnnotationUtils.hashMember(method.getName(), object);
            }
            catch (RuntimeException runtimeException) {
                object = runtimeException;
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return n2;
    }

    public static String toString(Annotation a2) {
        ToStringBuilder toStringBuilder = new ToStringBuilder(a2, TO_STRING_STYLE);
        for (Method method : a2.annotationType().getDeclaredMethods()) {
            if (method.getParameterTypes().length > 0) continue;
            try {
                toStringBuilder.append(method.getName(), method.invoke((Object)a2, new Object[0]));
            }
            catch (RuntimeException runtimeException) {
                RuntimeException runtimeException2 = runtimeException;
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return toStringBuilder.build();
    }

    public static boolean isValidAnnotationMemberType(Class<?> type) {
        if (type == null) {
            return false;
        }
        if (type.isArray()) {
            type = type.getComponentType();
        }
        return type.isPrimitive() || type.isEnum() || type.isAnnotation() || String.class.equals(type) || Class.class.equals(type);
    }

    private static int hashMember(String name, Object value) {
        int n2 = name.hashCode() * 127;
        if (value.getClass().isArray()) {
            return n2 ^ AnnotationUtils.arrayMemberHash(value.getClass().getComponentType(), value);
        }
        if (value instanceof Annotation) {
            return n2 ^ AnnotationUtils.hashCode((Annotation)value);
        }
        return n2 ^ value.hashCode();
    }

    private static boolean memberEquals(Class<?> type, Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (type.isArray()) {
            return AnnotationUtils.arrayMemberEquals(type.getComponentType(), o1, o2);
        }
        if (type.isAnnotation()) {
            return AnnotationUtils.equals((Annotation)o1, (Annotation)o2);
        }
        return o1.equals(o2);
    }

    private static boolean arrayMemberEquals(Class<?> componentType, Object o1, Object o2) {
        if (componentType.isAnnotation()) {
            return AnnotationUtils.annotationArrayMemberEquals((Annotation[])o1, (Annotation[])o2);
        }
        if (componentType.equals(Byte.TYPE)) {
            return Arrays.equals((byte[])o1, (byte[])o2);
        }
        if (componentType.equals(Short.TYPE)) {
            return Arrays.equals((short[])o1, (short[])o2);
        }
        if (componentType.equals(Integer.TYPE)) {
            return Arrays.equals((int[])o1, (int[])o2);
        }
        if (componentType.equals(Character.TYPE)) {
            return Arrays.equals((char[])o1, (char[])o2);
        }
        if (componentType.equals(Long.TYPE)) {
            return Arrays.equals((long[])o1, (long[])o2);
        }
        if (componentType.equals(Float.TYPE)) {
            return Arrays.equals((float[])o1, (float[])o2);
        }
        if (componentType.equals(Double.TYPE)) {
            return Arrays.equals((double[])o1, (double[])o2);
        }
        if (componentType.equals(Boolean.TYPE)) {
            return Arrays.equals((boolean[])o1, (boolean[])o2);
        }
        return Arrays.equals((Object[])o1, (Object[])o2);
    }

    private static boolean annotationArrayMemberEquals(Annotation[] a1, Annotation[] a2) {
        if (a1.length != a2.length) {
            return false;
        }
        for (int i2 = 0; i2 < a1.length; ++i2) {
            if (AnnotationUtils.equals(a1[i2], a2[i2])) continue;
            return false;
        }
        return true;
    }

    private static int arrayMemberHash(Class<?> componentType, Object o2) {
        if (componentType.equals(Byte.TYPE)) {
            return Arrays.hashCode((byte[])o2);
        }
        if (componentType.equals(Short.TYPE)) {
            return Arrays.hashCode((short[])o2);
        }
        if (componentType.equals(Integer.TYPE)) {
            return Arrays.hashCode((int[])o2);
        }
        if (componentType.equals(Character.TYPE)) {
            return Arrays.hashCode((char[])o2);
        }
        if (componentType.equals(Long.TYPE)) {
            return Arrays.hashCode((long[])o2);
        }
        if (componentType.equals(Float.TYPE)) {
            return Arrays.hashCode((float[])o2);
        }
        if (componentType.equals(Double.TYPE)) {
            return Arrays.hashCode((double[])o2);
        }
        if (componentType.equals(Boolean.TYPE)) {
            return Arrays.hashCode((boolean[])o2);
        }
        return Arrays.hashCode((Object[])o2);
    }
}

