/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;

public class EnumUtils {
    private static final String NULL_ELEMENTS_NOT_PERMITTED = "null elements not permitted";
    private static final String CANNOT_STORE_S_S_VALUES_IN_S_BITS = "Cannot store %s %s values in %s bits";
    private static final String S_DOES_NOT_SEEM_TO_BE_AN_ENUM_TYPE = "%s does not seem to be an Enum type";
    private static final String ENUM_CLASS_MUST_BE_DEFINED = "EnumClass must be defined.";

    public static <E extends Enum<E>> Map<String, E> getEnumMap(Class<E> enumClass) {
        LinkedHashMap<String, Enum> linkedHashMap = new LinkedHashMap<String, Enum>();
        for (Enum enum_ : (Enum[])enumClass.getEnumConstants()) {
            linkedHashMap.put(enum_.name(), enum_);
        }
        return linkedHashMap;
    }

    public static <E extends Enum<E>> List<E> getEnumList(Class<E> enumClass) {
        return new ArrayList<E>(Arrays.asList(enumClass.getEnumConstants()));
    }

    public static <E extends Enum<E>> boolean isValidEnum(Class<E> enumClass, String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(enumClass, enumName);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static <E extends Enum<E>> E getEnum(Class<E> enumClass, String enumName) {
        if (enumName == null) {
            return null;
        }
        try {
            return Enum.valueOf(enumClass, enumName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static <E extends Enum<E>> long generateBitVector(Class<E> enumClass, Iterable<? extends E> values) {
        EnumUtils.checkBitVectorable(enumClass);
        Validate.notNull(values);
        long l2 = 0L;
        for (Enum enum_ : values) {
            Validate.isTrue(enum_ != null, NULL_ELEMENTS_NOT_PERMITTED, new Object[0]);
            l2 |= 1L << enum_.ordinal();
        }
        return l2;
    }

    public static <E extends Enum<E>> long[] generateBitVectors(Class<E> enumClass, Iterable<? extends E> values) {
        EnumUtils.asEnum(enumClass);
        Validate.notNull(values);
        EnumSet<Enum> enumSet = EnumSet.noneOf(enumClass);
        for (Object object : values) {
            Validate.isTrue(object != null, NULL_ELEMENTS_NOT_PERMITTED, new Object[0]);
            enumSet.add((Enum)object);
        }
        Object object = new long[(((Enum[])enumClass.getEnumConstants()).length - 1) / 64 + 1];
        for (Enum enum_ : enumSet) {
            Object object2 = object;
            int n2 = enum_.ordinal() / 64;
            object2[n2] = object2[n2] | 1L << enum_.ordinal() % 64;
        }
        ArrayUtils.reverse((long[])object);
        return object;
    }

    @SafeVarargs
    public static <E extends Enum<E>> long generateBitVector(Class<E> enumClass, E ... values) {
        Validate.noNullElements(values);
        return EnumUtils.generateBitVector(enumClass, Arrays.asList(values));
    }

    @SafeVarargs
    public static <E extends Enum<E>> long[] generateBitVectors(Class<E> enumClass, E ... values) {
        EnumUtils.asEnum(enumClass);
        Validate.noNullElements(values);
        EnumSet<Enum> enumSet = EnumSet.noneOf(enumClass);
        Collections.addAll(enumSet, values);
        long[] lArray = new long[(((Enum[])enumClass.getEnumConstants()).length - 1) / 64 + 1];
        for (Enum enum_ : enumSet) {
            int n2 = enum_.ordinal() / 64;
            lArray[n2] = lArray[n2] | 1L << enum_.ordinal() % 64;
        }
        ArrayUtils.reverse(lArray);
        return lArray;
    }

    public static <E extends Enum<E>> EnumSet<E> processBitVector(Class<E> enumClass, long value) {
        EnumUtils.checkBitVectorable(enumClass).getEnumConstants();
        return EnumUtils.processBitVectors(enumClass, value);
    }

    public static <E extends Enum<E>> EnumSet<E> processBitVectors(Class<E> enumClass, long ... values) {
        EnumSet<Enum> enumSet = EnumSet.noneOf(EnumUtils.asEnum(enumClass));
        long[] lArray = ArrayUtils.clone(Validate.notNull(values));
        ArrayUtils.reverse(lArray);
        for (Enum enum_ : (Enum[])enumClass.getEnumConstants()) {
            int n2 = enum_.ordinal() / 64;
            if (n2 >= lArray.length || (lArray[n2] & 1L << enum_.ordinal() % 64) == 0L) continue;
            enumSet.add(enum_);
        }
        return enumSet;
    }

    private static <E extends Enum<E>> Class<E> checkBitVectorable(Class<E> enumClass) {
        Enum[] enumArray = (Enum[])EnumUtils.asEnum(enumClass).getEnumConstants();
        Validate.isTrue(enumArray.length <= 64, CANNOT_STORE_S_S_VALUES_IN_S_BITS, enumArray.length, enumClass.getSimpleName(), 64);
        return enumClass;
    }

    private static <E extends Enum<E>> Class<E> asEnum(Class<E> enumClass) {
        Validate.notNull(enumClass, ENUM_CLASS_MUST_BE_DEFINED, new Object[0]);
        Validate.isTrue(enumClass.isEnum(), S_DOES_NOT_SEEM_TO_BE_AN_ENUM_TYPE, enumClass);
        return enumClass;
    }
}

