/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.math.NumberUtils;

public enum JavaVersion {
    JAVA_0_9(1.5f, "0.9"),
    JAVA_1_1(1.1f, "1.1"),
    JAVA_1_2(1.2f, "1.2"),
    JAVA_1_3(1.3f, "1.3"),
    JAVA_1_4(1.4f, "1.4"),
    JAVA_1_5(1.5f, "1.5"),
    JAVA_1_6(1.6f, "1.6"),
    JAVA_1_7(1.7f, "1.7"),
    JAVA_1_8(1.8f, "1.8"),
    JAVA_1_9(9.0f, "9"),
    JAVA_9(9.0f, "9"),
    JAVA_RECENT(JavaVersion.maxVersion(), Float.toString(JavaVersion.maxVersion()));

    private final float value;
    private final String name;

    private JavaVersion(float value, String name) {
        this.value = value;
        this.name = name;
    }

    public final boolean atLeast(JavaVersion requiredVersion) {
        return this.value >= requiredVersion.value;
    }

    static JavaVersion getJavaVersion(String nom) {
        return JavaVersion.get(nom);
    }

    static JavaVersion get(String nom) {
        int n2;
        int n3;
        float f2;
        if ("0.9".equals(nom)) {
            return JAVA_0_9;
        }
        if ("1.1".equals(nom)) {
            return JAVA_1_1;
        }
        if ("1.2".equals(nom)) {
            return JAVA_1_2;
        }
        if ("1.3".equals(nom)) {
            return JAVA_1_3;
        }
        if ("1.4".equals(nom)) {
            return JAVA_1_4;
        }
        if ("1.5".equals(nom)) {
            return JAVA_1_5;
        }
        if ("1.6".equals(nom)) {
            return JAVA_1_6;
        }
        if ("1.7".equals(nom)) {
            return JAVA_1_7;
        }
        if ("1.8".equals(nom)) {
            return JAVA_1_8;
        }
        if ("9".equals(nom)) {
            return JAVA_9;
        }
        if (nom == null) {
            return null;
        }
        float f3 = JavaVersion.toFloatVersion(nom);
        if ((double)f2 - 1.0 < 1.0 && Float.parseFloat(nom.substring((n3 = Math.max(nom.indexOf(46), nom.indexOf(44))) + 1, n2 = Math.max(nom.length(), nom.indexOf(44, n3)))) > 0.9f) {
            return JAVA_RECENT;
        }
        return null;
    }

    public final String toString() {
        return this.name;
    }

    private static float maxVersion() {
        float f2;
        float f3 = JavaVersion.toFloatVersion(System.getProperty("java.specification.version", "99.0"));
        if (f2 > 0.0f) {
            return f3;
        }
        return 99.0f;
    }

    private static float toFloatVersion(String value) {
        if (value.contains(".")) {
            String[] stringArray = value.split("\\.");
            if (stringArray.length >= 2) {
                return NumberUtils.toFloat(stringArray[0] + '.' + stringArray[1], -1.0f);
            }
        } else {
            return NumberUtils.toFloat(value, -1.0f);
        }
        return -1.0f;
    }
}

