/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Comparator;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.Builder;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class CompareToBuilder
implements Builder<Integer> {
    private int comparison = 0;

    public static int reflectionCompare(Object lhs, Object rhs) {
        return CompareToBuilder.reflectionCompare(lhs, rhs, false, null, new String[0]);
    }

    public static int reflectionCompare(Object lhs, Object rhs, boolean compareTransients) {
        return CompareToBuilder.reflectionCompare(lhs, rhs, compareTransients, null, new String[0]);
    }

    public static int reflectionCompare(Object lhs, Object rhs, Collection<String> excludeFields) {
        return CompareToBuilder.reflectionCompare(lhs, rhs, ReflectionToStringBuilder.toNoNullStringArray(excludeFields));
    }

    public static int reflectionCompare(Object lhs, Object rhs, String ... excludeFields) {
        return CompareToBuilder.reflectionCompare(lhs, rhs, false, null, excludeFields);
    }

    public static int reflectionCompare(Object lhs, Object rhs, boolean compareTransients, Class<?> reflectUpToClass, String ... excludeFields) {
        if (lhs == rhs) {
            return 0;
        }
        if (lhs == null || rhs == null) {
            throw new NullPointerException();
        }
        Class<?> clazz = lhs.getClass();
        if (!clazz.isInstance(rhs)) {
            throw new ClassCastException();
        }
        CompareToBuilder compareToBuilder = new CompareToBuilder();
        CompareToBuilder.reflectionAppend(lhs, rhs, clazz, compareToBuilder, compareTransients, excludeFields);
        while (clazz.getSuperclass() != null && clazz != reflectUpToClass) {
            clazz = clazz.getSuperclass();
            CompareToBuilder.reflectionAppend(lhs, rhs, clazz, compareToBuilder, compareTransients, excludeFields);
        }
        return compareToBuilder.toComparison();
    }

    private static void reflectionAppend(Object lhs, Object rhs, Class<?> clazz, CompareToBuilder builder, boolean useTransients, String[] excludeFields) {
        AccessibleObject[] accessibleObjectArray = clazz.getDeclaredFields();
        AccessibleObject.setAccessible(accessibleObjectArray, true);
        for (int i2 = 0; i2 < accessibleObjectArray.length && builder.comparison == 0; ++i2) {
            AccessibleObject accessibleObject = accessibleObjectArray[i2];
            if (ArrayUtils.contains(excludeFields, ((Field)accessibleObject).getName()) || ((Field)accessibleObject).getName().contains("$") || !useTransients && Modifier.isTransient(((Field)accessibleObject).getModifiers()) || Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
            try {
                builder.append(((Field)accessibleObject).get(lhs), ((Field)accessibleObject).get(rhs));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalError("Unexpected IllegalAccessException");
            }
        }
    }

    public CompareToBuilder appendSuper(int superCompareTo) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = superCompareTo;
        return this;
    }

    public CompareToBuilder append(Object lhs, Object rhs) {
        return this.append(lhs, rhs, null);
    }

    public CompareToBuilder append(Object lhs, Object rhs, Comparator<?> comparator) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = -1;
            return this;
        }
        if (rhs == null) {
            this.comparison = 1;
            return this;
        }
        if (lhs.getClass().isArray()) {
            this.appendArray(lhs, rhs, comparator);
        } else if (comparator == null) {
            Comparable comparable = (Comparable)lhs;
            this.comparison = comparable.compareTo(rhs);
        } else {
            Comparator<?> comparator2 = comparator;
            this.comparison = comparator2.compare(lhs, rhs);
        }
        return this;
    }

    private void appendArray(Object lhs, Object rhs, Comparator<?> comparator) {
        if (lhs instanceof long[]) {
            this.append((long[])lhs, (long[])rhs);
            return;
        }
        if (lhs instanceof int[]) {
            this.append((int[])lhs, (int[])rhs);
            return;
        }
        if (lhs instanceof short[]) {
            this.append((short[])lhs, (short[])rhs);
            return;
        }
        if (lhs instanceof char[]) {
            this.append((char[])lhs, (char[])rhs);
            return;
        }
        if (lhs instanceof byte[]) {
            this.append((byte[])lhs, (byte[])rhs);
            return;
        }
        if (lhs instanceof double[]) {
            this.append((double[])lhs, (double[])rhs);
            return;
        }
        if (lhs instanceof float[]) {
            this.append((float[])lhs, (float[])rhs);
            return;
        }
        if (lhs instanceof boolean[]) {
            this.append((boolean[])lhs, (boolean[])rhs);
            return;
        }
        this.append((Object[])lhs, (Object[])rhs, comparator);
    }

    public CompareToBuilder append(long lhs, long rhs) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = lhs < rhs ? -1 : (lhs > rhs ? 1 : 0);
        return this;
    }

    public CompareToBuilder append(int lhs, int rhs) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = lhs < rhs ? -1 : (lhs > rhs ? 1 : 0);
        return this;
    }

    public CompareToBuilder append(short lhs, short rhs) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = lhs < rhs ? -1 : (lhs > rhs ? 1 : 0);
        return this;
    }

    public CompareToBuilder append(char lhs, char rhs) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = lhs < rhs ? -1 : (lhs > rhs ? 1 : 0);
        return this;
    }

    public CompareToBuilder append(byte lhs, byte rhs) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = lhs < rhs ? -1 : (lhs > rhs ? 1 : 0);
        return this;
    }

    public CompareToBuilder append(double lhs, double rhs) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = Double.compare(lhs, rhs);
        return this;
    }

    public CompareToBuilder append(float lhs, float rhs) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = Float.compare(lhs, rhs);
        return this;
    }

    public CompareToBuilder append(boolean lhs, boolean rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        this.comparison = !lhs ? -1 : 1;
        return this;
    }

    public CompareToBuilder append(Object[] lhs, Object[] rhs) {
        return this.append(lhs, rhs, (Comparator<?>)null);
    }

    public CompareToBuilder append(Object[] lhs, Object[] rhs, Comparator<?> comparator) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = -1;
            return this;
        }
        if (rhs == null) {
            this.comparison = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        for (int i2 = 0; i2 < lhs.length && this.comparison == 0; ++i2) {
            this.append(lhs[i2], rhs[i2], comparator);
        }
        return this;
    }

    public CompareToBuilder append(long[] lhs, long[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = -1;
            return this;
        }
        if (rhs == null) {
            this.comparison = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        for (int i2 = 0; i2 < lhs.length && this.comparison == 0; ++i2) {
            this.append(lhs[i2], rhs[i2]);
        }
        return this;
    }

    public CompareToBuilder append(int[] lhs, int[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = -1;
            return this;
        }
        if (rhs == null) {
            this.comparison = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        for (int i2 = 0; i2 < lhs.length && this.comparison == 0; ++i2) {
            this.append(lhs[i2], rhs[i2]);
        }
        return this;
    }

    public CompareToBuilder append(short[] lhs, short[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = -1;
            return this;
        }
        if (rhs == null) {
            this.comparison = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        for (int i2 = 0; i2 < lhs.length && this.comparison == 0; ++i2) {
            this.append(lhs[i2], rhs[i2]);
        }
        return this;
    }

    public CompareToBuilder append(char[] lhs, char[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = -1;
            return this;
        }
        if (rhs == null) {
            this.comparison = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        for (int i2 = 0; i2 < lhs.length && this.comparison == 0; ++i2) {
            this.append(lhs[i2], rhs[i2]);
        }
        return this;
    }

    public CompareToBuilder append(byte[] lhs, byte[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = -1;
            return this;
        }
        if (rhs == null) {
            this.comparison = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        for (int i2 = 0; i2 < lhs.length && this.comparison == 0; ++i2) {
            this.append(lhs[i2], rhs[i2]);
        }
        return this;
    }

    public CompareToBuilder append(double[] lhs, double[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = -1;
            return this;
        }
        if (rhs == null) {
            this.comparison = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        for (int i2 = 0; i2 < lhs.length && this.comparison == 0; ++i2) {
            this.append(lhs[i2], rhs[i2]);
        }
        return this;
    }

    public CompareToBuilder append(float[] lhs, float[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = -1;
            return this;
        }
        if (rhs == null) {
            this.comparison = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        for (int i2 = 0; i2 < lhs.length && this.comparison == 0; ++i2) {
            this.append(lhs[i2], rhs[i2]);
        }
        return this;
    }

    public CompareToBuilder append(boolean[] lhs, boolean[] rhs) {
        if (this.comparison != 0) {
            return this;
        }
        if (lhs == rhs) {
            return this;
        }
        if (lhs == null) {
            this.comparison = -1;
            return this;
        }
        if (rhs == null) {
            this.comparison = 1;
            return this;
        }
        if (lhs.length != rhs.length) {
            this.comparison = lhs.length < rhs.length ? -1 : 1;
            return this;
        }
        for (int i2 = 0; i2 < lhs.length && this.comparison == 0; ++i2) {
            this.append(lhs[i2], rhs[i2]);
        }
        return this;
    }

    public int toComparison() {
        return this.comparison;
    }

    @Override
    public Integer build() {
        return this.toComparison();
    }
}

