/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.Builder;
import org.apache.commons.lang3.text.StrMatcher;
import org.apache.commons.lang3.text.StrTokenizer;

@Deprecated
public class StrBuilder
implements Serializable,
Appendable,
CharSequence,
Builder<String> {
    static final int CAPACITY = 32;
    private static final long serialVersionUID = 7628716375283629643L;
    protected char[] buffer;
    protected int size;
    private String newLine;
    private String nullText;

    public StrBuilder() {
        this(32);
    }

    public StrBuilder(int initialCapacity) {
        if (initialCapacity <= 0) {
            initialCapacity = 32;
        }
        this.buffer = new char[initialCapacity];
    }

    public StrBuilder(String str) {
        if (str == null) {
            this.buffer = new char[32];
            return;
        }
        this.buffer = new char[str.length() + 32];
        this.append(str);
    }

    public String getNewLineText() {
        return this.newLine;
    }

    public StrBuilder setNewLineText(String newLine) {
        this.newLine = newLine;
        return this;
    }

    public String getNullText() {
        return this.nullText;
    }

    public StrBuilder setNullText(String nullText) {
        if (nullText != null && nullText.isEmpty()) {
            nullText = null;
        }
        this.nullText = nullText;
        return this;
    }

    @Override
    public int length() {
        return this.size;
    }

    public StrBuilder setLength(int length) {
        if (length < 0) {
            throw new StringIndexOutOfBoundsException(length);
        }
        if (length < this.size) {
            this.size = length;
        } else if (length > this.size) {
            this.ensureCapacity(length);
            int n2 = this.size;
            this.size = length;
            for (int i2 = n2; i2 < length; ++i2) {
                this.buffer[i2] = '\u0000';
            }
        }
        return this;
    }

    public int capacity() {
        return this.buffer.length;
    }

    public StrBuilder ensureCapacity(int capacity) {
        if (capacity > this.buffer.length) {
            char[] cArray = this.buffer;
            this.buffer = new char[capacity << 1];
            System.arraycopy(cArray, 0, this.buffer, 0, this.size);
        }
        return this;
    }

    public StrBuilder minimizeCapacity() {
        if (this.buffer.length > this.length()) {
            char[] cArray = this.buffer;
            this.buffer = new char[this.length()];
            System.arraycopy(cArray, 0, this.buffer, 0, this.size);
        }
        return this;
    }

    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public StrBuilder clear() {
        this.size = 0;
        return this;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length()) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.buffer[index];
    }

    public StrBuilder setCharAt(int index, char ch) {
        if (index < 0 || index >= this.length()) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.buffer[index] = ch;
        return this;
    }

    public StrBuilder deleteCharAt(int index) {
        if (index < 0 || index >= this.size) {
            throw new StringIndexOutOfBoundsException(index);
        }
        int n2 = index;
        this.deleteImpl(n2, n2 + 1, 1);
        return this;
    }

    public char[] toCharArray() {
        if (this.size == 0) {
            return ArrayUtils.EMPTY_CHAR_ARRAY;
        }
        char[] cArray = new char[this.size];
        System.arraycopy(this.buffer, 0, cArray, 0, this.size);
        return cArray;
    }

    public char[] toCharArray(int startIndex, int endIndex) {
        int n2 = (endIndex = this.validateRange(startIndex, endIndex)) - startIndex;
        if (n2 == 0) {
            return ArrayUtils.EMPTY_CHAR_ARRAY;
        }
        char[] cArray = new char[n2];
        System.arraycopy(this.buffer, startIndex, cArray, 0, n2);
        return cArray;
    }

    public char[] getChars(char[] destination) {
        int n2 = this.length();
        if (destination == null || destination.length < n2) {
            destination = new char[n2];
        }
        System.arraycopy(this.buffer, 0, destination, 0, n2);
        return destination;
    }

    public void getChars(int startIndex, int endIndex, char[] destination, int destinationIndex) {
        if (startIndex < 0) {
            throw new StringIndexOutOfBoundsException(startIndex);
        }
        if (endIndex < 0 || endIndex > this.length()) {
            throw new StringIndexOutOfBoundsException(endIndex);
        }
        if (startIndex > endIndex) {
            throw new StringIndexOutOfBoundsException("end < start");
        }
        System.arraycopy(this.buffer, startIndex, destination, destinationIndex, endIndex - startIndex);
    }

    public int readFrom(Readable readable) throws IOException {
        int n2 = this.size;
        if (readable instanceof Reader) {
            int n3;
            Reader reader = (Reader)readable;
            StrBuilder strBuilder = this;
            strBuilder.ensureCapacity(strBuilder.size + 1);
            while ((n3 = reader.read(this.buffer, this.size, this.buffer.length - this.size)) != -1) {
                this.size += n3;
                StrBuilder strBuilder2 = this;
                strBuilder2.ensureCapacity(strBuilder2.size + 1);
            }
        } else if (readable instanceof CharBuffer) {
            CharBuffer charBuffer = (CharBuffer)readable;
            int n4 = charBuffer.remaining();
            StrBuilder strBuilder = this;
            strBuilder.ensureCapacity(strBuilder.size + n4);
            charBuffer.get(this.buffer, this.size, n4);
            this.size += n4;
        } else {
            while (true) {
                StrBuilder strBuilder = this;
                strBuilder.ensureCapacity(strBuilder.size + 1);
                CharBuffer charBuffer = CharBuffer.wrap(this.buffer, this.size, this.buffer.length - this.size);
                int n5 = readable.read(charBuffer);
                if (n5 == -1) break;
                this.size += n5;
            }
        }
        return this.size - n2;
    }

    public StrBuilder appendNewLine() {
        if (this.newLine == null) {
            this.append(System.lineSeparator());
            return this;
        }
        StrBuilder strBuilder = this;
        return strBuilder.append(strBuilder.newLine);
    }

    public StrBuilder appendNull() {
        if (this.nullText == null) {
            return this;
        }
        StrBuilder strBuilder = this;
        return strBuilder.append(strBuilder.nullText);
    }

    public StrBuilder append(Object obj) {
        if (obj == null) {
            return this.appendNull();
        }
        if (obj instanceof CharSequence) {
            return this.append((CharSequence)obj);
        }
        return this.append(obj.toString());
    }

    @Override
    public StrBuilder append(CharSequence seq) {
        if (seq == null) {
            return this.appendNull();
        }
        if (seq instanceof StrBuilder) {
            return this.append((StrBuilder)seq);
        }
        if (seq instanceof StringBuilder) {
            return this.append((StringBuilder)seq);
        }
        if (seq instanceof StringBuffer) {
            return this.append((StringBuffer)seq);
        }
        if (seq instanceof CharBuffer) {
            return this.append((CharBuffer)seq);
        }
        return this.append(seq.toString());
    }

    @Override
    public StrBuilder append(CharSequence seq, int startIndex, int length) {
        if (seq == null) {
            return this.appendNull();
        }
        return this.append(seq.toString(), startIndex, length);
    }

    public StrBuilder append(String str) {
        if (str == null) {
            return this.appendNull();
        }
        int n2 = str.length();
        if (n2 > 0) {
            int n3 = this.length();
            this.ensureCapacity(n3 + n2);
            str.getChars(0, n2, this.buffer, n3);
            this.size += n2;
        }
        return this;
    }

    public StrBuilder append(String str, int startIndex, int length) {
        if (str == null) {
            return this.appendNull();
        }
        if (startIndex < 0 || startIndex > str.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (length < 0 || startIndex + length > str.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (length > 0) {
            int n2 = this.length();
            this.ensureCapacity(n2 + length);
            int n3 = startIndex;
            str.getChars(n3, n3 + length, this.buffer, n2);
            this.size += length;
        }
        return this;
    }

    public StrBuilder append(String format, Object ... objs) {
        return this.append(String.format(format, objs));
    }

    public StrBuilder append(CharBuffer buf) {
        if (buf == null) {
            return this.appendNull();
        }
        if (buf.hasArray()) {
            int n2 = buf.remaining();
            int n3 = this.length();
            this.ensureCapacity(n3 + n2);
            System.arraycopy(buf.array(), buf.arrayOffset() + buf.position(), this.buffer, n3, n2);
            this.size += n2;
        } else {
            this.append(buf.toString());
        }
        return this;
    }

    public StrBuilder append(CharBuffer buf, int startIndex, int length) {
        if (buf == null) {
            return this.appendNull();
        }
        if (buf.hasArray()) {
            int n2 = buf.remaining();
            if (startIndex < 0 || startIndex > n2) {
                throw new StringIndexOutOfBoundsException("startIndex must be valid");
            }
            if (length < 0 || startIndex + length > n2) {
                throw new StringIndexOutOfBoundsException("length must be valid");
            }
            int n3 = this.length();
            this.ensureCapacity(n3 + length);
            System.arraycopy(buf.array(), buf.arrayOffset() + buf.position() + startIndex, this.buffer, n3, length);
            this.size += length;
        } else {
            this.append(buf.toString(), startIndex, length);
        }
        return this;
    }

    public StrBuilder append(StringBuffer str) {
        if (str == null) {
            return this.appendNull();
        }
        int n2 = str.length();
        if (n2 > 0) {
            int n3 = this.length();
            this.ensureCapacity(n3 + n2);
            str.getChars(0, n2, this.buffer, n3);
            this.size += n2;
        }
        return this;
    }

    public StrBuilder append(StringBuffer str, int startIndex, int length) {
        if (str == null) {
            return this.appendNull();
        }
        if (startIndex < 0 || startIndex > str.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (length < 0 || startIndex + length > str.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (length > 0) {
            int n2 = this.length();
            this.ensureCapacity(n2 + length);
            int n3 = startIndex;
            str.getChars(n3, n3 + length, this.buffer, n2);
            this.size += length;
        }
        return this;
    }

    public StrBuilder append(StringBuilder str) {
        if (str == null) {
            return this.appendNull();
        }
        int n2 = str.length();
        if (n2 > 0) {
            int n3 = this.length();
            this.ensureCapacity(n3 + n2);
            str.getChars(0, n2, this.buffer, n3);
            this.size += n2;
        }
        return this;
    }

    public StrBuilder append(StringBuilder str, int startIndex, int length) {
        if (str == null) {
            return this.appendNull();
        }
        if (startIndex < 0 || startIndex > str.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (length < 0 || startIndex + length > str.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (length > 0) {
            int n2 = this.length();
            this.ensureCapacity(n2 + length);
            int n3 = startIndex;
            str.getChars(n3, n3 + length, this.buffer, n2);
            this.size += length;
        }
        return this;
    }

    public StrBuilder append(StrBuilder str) {
        if (str == null) {
            return this.appendNull();
        }
        int n2 = str.length();
        if (n2 > 0) {
            int n3 = this.length();
            this.ensureCapacity(n3 + n2);
            System.arraycopy(str.buffer, 0, this.buffer, n3, n2);
            this.size += n2;
        }
        return this;
    }

    public StrBuilder append(StrBuilder str, int startIndex, int length) {
        if (str == null) {
            return this.appendNull();
        }
        if (startIndex < 0 || startIndex > str.length()) {
            throw new StringIndexOutOfBoundsException("startIndex must be valid");
        }
        if (length < 0 || startIndex + length > str.length()) {
            throw new StringIndexOutOfBoundsException("length must be valid");
        }
        if (length > 0) {
            int n2 = this.length();
            this.ensureCapacity(n2 + length);
            int n3 = startIndex;
            str.getChars(n3, n3 + length, this.buffer, n2);
            this.size += length;
        }
        return this;
    }

    public StrBuilder append(char[] chars) {
        if (chars == null) {
            return this.appendNull();
        }
        int n2 = chars.length;
        if (n2 > 0) {
            int n3 = this.length();
            this.ensureCapacity(n3 + n2);
            System.arraycopy(chars, 0, this.buffer, n3, n2);
            this.size += n2;
        }
        return this;
    }

    public StrBuilder append(char[] chars, int startIndex, int length) {
        if (chars == null) {
            return this.appendNull();
        }
        if (startIndex < 0 || startIndex > chars.length) {
            throw new StringIndexOutOfBoundsException("Invalid startIndex: " + length);
        }
        if (length < 0 || startIndex + length > chars.length) {
            throw new StringIndexOutOfBoundsException("Invalid length: " + length);
        }
        if (length > 0) {
            int n2 = this.length();
            this.ensureCapacity(n2 + length);
            System.arraycopy(chars, startIndex, this.buffer, n2, length);
            this.size += length;
        }
        return this;
    }

    public StrBuilder append(boolean value) {
        if (value) {
            StrBuilder strBuilder = this;
            strBuilder.ensureCapacity(strBuilder.size + 4);
            this.buffer[this.size++] = 116;
            this.buffer[this.size++] = 114;
            this.buffer[this.size++] = 117;
            this.buffer[this.size++] = 101;
        } else {
            StrBuilder strBuilder = this;
            strBuilder.ensureCapacity(strBuilder.size + 5);
            this.buffer[this.size++] = 102;
            this.buffer[this.size++] = 97;
            this.buffer[this.size++] = 108;
            this.buffer[this.size++] = 115;
            this.buffer[this.size++] = 101;
        }
        return this;
    }

    @Override
    public StrBuilder append(char ch) {
        int n2 = this.length();
        this.ensureCapacity(n2 + 1);
        this.buffer[this.size++] = ch;
        return this;
    }

    public StrBuilder append(int value) {
        return this.append(String.valueOf(value));
    }

    public StrBuilder append(long value) {
        return this.append(String.valueOf(value));
    }

    public StrBuilder append(float value) {
        return this.append(String.valueOf(value));
    }

    public StrBuilder append(double value) {
        return this.append(String.valueOf(value));
    }

    public StrBuilder appendln(Object obj) {
        return this.append(obj).appendNewLine();
    }

    public StrBuilder appendln(String str) {
        return this.append(str).appendNewLine();
    }

    public StrBuilder appendln(String str, int startIndex, int length) {
        return this.append(str, startIndex, length).appendNewLine();
    }

    public StrBuilder appendln(String format, Object ... objs) {
        return this.append(format, objs).appendNewLine();
    }

    public StrBuilder appendln(StringBuffer str) {
        return this.append(str).appendNewLine();
    }

    public StrBuilder appendln(StringBuilder str) {
        return this.append(str).appendNewLine();
    }

    public StrBuilder appendln(StringBuilder str, int startIndex, int length) {
        return this.append(str, startIndex, length).appendNewLine();
    }

    public StrBuilder appendln(StringBuffer str, int startIndex, int length) {
        return this.append(str, startIndex, length).appendNewLine();
    }

    public StrBuilder appendln(StrBuilder str) {
        return this.append(str).appendNewLine();
    }

    public StrBuilder appendln(StrBuilder str, int startIndex, int length) {
        return this.append(str, startIndex, length).appendNewLine();
    }

    public StrBuilder appendln(char[] chars) {
        return this.append(chars).appendNewLine();
    }

    public StrBuilder appendln(char[] chars, int startIndex, int length) {
        return this.append(chars, startIndex, length).appendNewLine();
    }

    public StrBuilder appendln(boolean value) {
        return this.append(value).appendNewLine();
    }

    public StrBuilder appendln(char ch) {
        return this.append(ch).appendNewLine();
    }

    public StrBuilder appendln(int value) {
        return this.append(value).appendNewLine();
    }

    public StrBuilder appendln(long value) {
        return this.append(value).appendNewLine();
    }

    public StrBuilder appendln(float value) {
        return this.append(value).appendNewLine();
    }

    public StrBuilder appendln(double value) {
        return this.append(value).appendNewLine();
    }

    public <T> StrBuilder appendAll(T ... array) {
        if (array != null && array.length > 0) {
            T[] TArray = array;
            int n2 = array.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                T t2 = TArray[i2];
                this.append(t2);
            }
        }
        return this;
    }

    public StrBuilder appendAll(Iterable<?> iterable) {
        if (iterable != null) {
            for (Object obj : iterable) {
                this.append(obj);
            }
        }
        return this;
    }

    public StrBuilder appendAll(Iterator<?> it) {
        if (it != null) {
            while (it.hasNext()) {
                this.append(it.next());
            }
        }
        return this;
    }

    public StrBuilder appendWithSeparators(Object[] array, String separator) {
        if (array != null && array.length > 0) {
            String string = Objects.toString(separator, "");
            this.append(array[0]);
            for (int i2 = 1; i2 < array.length; ++i2) {
                this.append(string);
                this.append(array[i2]);
            }
        }
        return this;
    }

    public StrBuilder appendWithSeparators(Iterable<?> iterable, String separator) {
        if (iterable != null) {
            String string = Objects.toString(separator, "");
            Iterator<?> iterator = iterable.iterator();
            while (iterator.hasNext()) {
                this.append(iterator.next());
                if (!iterator.hasNext()) continue;
                this.append(string);
            }
        }
        return this;
    }

    public StrBuilder appendWithSeparators(Iterator<?> it, String separator) {
        if (it != null) {
            String string = Objects.toString(separator, "");
            while (it.hasNext()) {
                this.append(it.next());
                if (!it.hasNext()) continue;
                this.append(string);
            }
        }
        return this;
    }

    public StrBuilder appendSeparator(String separator) {
        return this.appendSeparator(separator, null);
    }

    public StrBuilder appendSeparator(String standard, String defaultIfEmpty) {
        String string = this.isEmpty() ? defaultIfEmpty : standard;
        if (string != null) {
            this.append(string);
        }
        return this;
    }

    public StrBuilder appendSeparator(char separator) {
        if (this.size() > 0) {
            this.append(separator);
        }
        return this;
    }

    public StrBuilder appendSeparator(char standard, char defaultIfEmpty) {
        if (this.size() > 0) {
            this.append(standard);
        } else {
            this.append(defaultIfEmpty);
        }
        return this;
    }

    public StrBuilder appendSeparator(String separator, int loopIndex) {
        if (separator != null && loopIndex > 0) {
            this.append(separator);
        }
        return this;
    }

    public StrBuilder appendSeparator(char separator, int loopIndex) {
        if (loopIndex > 0) {
            this.append(separator);
        }
        return this;
    }

    public StrBuilder appendPadding(int length, char padChar) {
        if (length >= 0) {
            StrBuilder strBuilder = this;
            strBuilder.ensureCapacity(strBuilder.size + length);
            for (int i2 = 0; i2 < length; ++i2) {
                this.buffer[this.size++] = padChar;
            }
        }
        return this;
    }

    public StrBuilder appendFixedWidthPadLeft(Object obj, int width, char padChar) {
        if (width > 0) {
            int n2;
            StrBuilder strBuilder = this;
            strBuilder.ensureCapacity(strBuilder.size + width);
            String string = obj == null ? this.getNullText() : obj.toString();
            if (string == null) {
                string = "";
            }
            if ((n2 = string.length()) >= width) {
                string.getChars(n2 - width, n2, this.buffer, this.size);
            } else {
                int n3 = width - n2;
                for (int i2 = 0; i2 < n3; ++i2) {
                    this.buffer[this.size + i2] = padChar;
                }
                string.getChars(0, n2, this.buffer, this.size + n3);
            }
            this.size += width;
        }
        return this;
    }

    public StrBuilder appendFixedWidthPadLeft(int value, int width, char padChar) {
        return this.appendFixedWidthPadLeft(String.valueOf(value), width, padChar);
    }

    public StrBuilder appendFixedWidthPadRight(Object obj, int width, char padChar) {
        if (width > 0) {
            int n2;
            StrBuilder strBuilder = this;
            strBuilder.ensureCapacity(strBuilder.size + width);
            String string = obj == null ? this.getNullText() : obj.toString();
            if (string == null) {
                string = "";
            }
            if ((n2 = string.length()) >= width) {
                string.getChars(0, width, this.buffer, this.size);
            } else {
                int n3 = width - n2;
                string.getChars(0, n2, this.buffer, this.size);
                for (int i2 = 0; i2 < n3; ++i2) {
                    this.buffer[this.size + n2 + i2] = padChar;
                }
            }
            this.size += width;
        }
        return this;
    }

    public StrBuilder appendFixedWidthPadRight(int value, int width, char padChar) {
        return this.appendFixedWidthPadRight(String.valueOf(value), width, padChar);
    }

    public StrBuilder insert(int index, Object obj) {
        if (obj == null) {
            return this.insert(index, this.nullText);
        }
        return this.insert(index, obj.toString());
    }

    public StrBuilder insert(int index, String str) {
        int n2;
        this.validateIndex(index);
        if (str == null) {
            str = this.nullText;
        }
        if (str != null && (n2 = str.length()) > 0) {
            int n3 = this.size + n2;
            this.ensureCapacity(n3);
            System.arraycopy(this.buffer, index, this.buffer, index + n2, this.size - index);
            this.size = n3;
            str.getChars(0, n2, this.buffer, index);
        }
        return this;
    }

    public StrBuilder insert(int index, char[] chars) {
        this.validateIndex(index);
        if (chars == null) {
            return this.insert(index, this.nullText);
        }
        int n2 = chars.length;
        if (n2 > 0) {
            StrBuilder strBuilder = this;
            strBuilder.ensureCapacity(strBuilder.size + n2);
            System.arraycopy(this.buffer, index, this.buffer, index + n2, this.size - index);
            System.arraycopy(chars, 0, this.buffer, index, n2);
            this.size += n2;
        }
        return this;
    }

    public StrBuilder insert(int index, char[] chars, int offset, int length) {
        this.validateIndex(index);
        if (chars == null) {
            return this.insert(index, this.nullText);
        }
        if (offset < 0 || offset > chars.length) {
            throw new StringIndexOutOfBoundsException("Invalid offset: " + offset);
        }
        if (length < 0 || offset + length > chars.length) {
            throw new StringIndexOutOfBoundsException("Invalid length: " + length);
        }
        if (length > 0) {
            StrBuilder strBuilder = this;
            strBuilder.ensureCapacity(strBuilder.size + length);
            System.arraycopy(this.buffer, index, this.buffer, index + length, this.size - index);
            System.arraycopy(chars, offset, this.buffer, index, length);
            this.size += length;
        }
        return this;
    }

    public StrBuilder insert(int index, boolean value) {
        this.validateIndex(index);
        if (value) {
            StrBuilder strBuilder = this;
            strBuilder.ensureCapacity(strBuilder.size + 4);
            System.arraycopy(this.buffer, index, this.buffer, index + 4, this.size - index);
            this.buffer[index++] = 116;
            this.buffer[index++] = 114;
            this.buffer[index++] = 117;
            this.buffer[index] = 101;
            this.size += 4;
        } else {
            StrBuilder strBuilder = this;
            strBuilder.ensureCapacity(strBuilder.size + 5);
            System.arraycopy(this.buffer, index, this.buffer, index + 5, this.size - index);
            this.buffer[index++] = 102;
            this.buffer[index++] = 97;
            this.buffer[index++] = 108;
            this.buffer[index++] = 115;
            this.buffer[index] = 101;
            this.size += 5;
        }
        return this;
    }

    public StrBuilder insert(int index, char value) {
        this.validateIndex(index);
        StrBuilder strBuilder = this;
        strBuilder.ensureCapacity(strBuilder.size + 1);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.size - index);
        this.buffer[index] = value;
        ++this.size;
        return this;
    }

    public StrBuilder insert(int index, int value) {
        return this.insert(index, String.valueOf(value));
    }

    public StrBuilder insert(int index, long value) {
        return this.insert(index, String.valueOf(value));
    }

    public StrBuilder insert(int index, float value) {
        return this.insert(index, String.valueOf(value));
    }

    public StrBuilder insert(int index, double value) {
        return this.insert(index, String.valueOf(value));
    }

    private void deleteImpl(int startIndex, int endIndex, int len) {
        System.arraycopy(this.buffer, endIndex, this.buffer, startIndex, this.size - endIndex);
        this.size -= len;
    }

    public StrBuilder delete(int startIndex, int endIndex) {
        int n2 = (endIndex = this.validateRange(startIndex, endIndex)) - startIndex;
        if (n2 > 0) {
            this.deleteImpl(startIndex, endIndex, n2);
        }
        return this;
    }

    public StrBuilder deleteAll(char ch) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (this.buffer[i2] != ch) continue;
            int n2 = i2;
            while (++i2 < this.size && this.buffer[i2] == ch) {
            }
            int n3 = i2 - n2;
            this.deleteImpl(n2, i2, n3);
            i2 -= n3;
        }
        return this;
    }

    public StrBuilder deleteFirst(char ch) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (this.buffer[i2] != ch) continue;
            int n2 = i2;
            this.deleteImpl(n2, n2 + 1, 1);
            break;
        }
        return this;
    }

    public StrBuilder deleteAll(String str) {
        int n2 = str == null ? 0 : str.length();
        if (n2 > 0) {
            int n3 = this.indexOf(str, 0);
            while (n3 >= 0) {
                int n4 = n3;
                this.deleteImpl(n4, n4 + n2, n2);
                n3 = this.indexOf(str, n3);
            }
        }
        return this;
    }

    public StrBuilder deleteFirst(String str) {
        int n2;
        int n3 = str == null ? 0 : str.length();
        if (n3 > 0 && (n2 = this.indexOf(str, 0)) >= 0) {
            int n4 = n2;
            this.deleteImpl(n4, n4 + n3, n3);
        }
        return this;
    }

    public StrBuilder deleteAll(StrMatcher matcher) {
        return this.replace(matcher, null, 0, this.size, -1);
    }

    public StrBuilder deleteFirst(StrMatcher matcher) {
        return this.replace(matcher, null, 0, this.size, 1);
    }

    private void replaceImpl(int startIndex, int endIndex, int removeLen, String insertStr, int insertLen) {
        int n2 = this.size - removeLen + insertLen;
        if (insertLen != removeLen) {
            this.ensureCapacity(n2);
            System.arraycopy(this.buffer, endIndex, this.buffer, startIndex + insertLen, this.size - endIndex);
            this.size = n2;
        }
        if (insertLen > 0) {
            insertStr.getChars(0, insertLen, this.buffer, startIndex);
        }
    }

    public StrBuilder replace(int startIndex, int endIndex, String replaceStr) {
        endIndex = this.validateRange(startIndex, endIndex);
        int n2 = replaceStr == null ? 0 : replaceStr.length();
        int n3 = endIndex;
        this.replaceImpl(startIndex, n3, n3 - startIndex, replaceStr, n2);
        return this;
    }

    public StrBuilder replaceAll(char search, char replace) {
        if (search != replace) {
            for (int i2 = 0; i2 < this.size; ++i2) {
                if (this.buffer[i2] != search) continue;
                this.buffer[i2] = replace;
            }
        }
        return this;
    }

    public StrBuilder replaceFirst(char search, char replace) {
        if (search != replace) {
            for (int i2 = 0; i2 < this.size; ++i2) {
                if (this.buffer[i2] != search) continue;
                this.buffer[i2] = replace;
                break;
            }
        }
        return this;
    }

    public StrBuilder replaceAll(String searchStr, String replaceStr) {
        int n2 = searchStr == null ? 0 : searchStr.length();
        if (n2 > 0) {
            int n3 = replaceStr == null ? 0 : replaceStr.length();
            int n4 = this.indexOf(searchStr, 0);
            while (n4 >= 0) {
                int n5 = n4;
                this.replaceImpl(n5, n5 + n2, n2, replaceStr, n3);
                n4 = this.indexOf(searchStr, n4 + n3);
            }
        }
        return this;
    }

    public StrBuilder replaceFirst(String searchStr, String replaceStr) {
        int n2;
        int n3 = searchStr == null ? 0 : searchStr.length();
        if (n3 > 0 && (n2 = this.indexOf(searchStr, 0)) >= 0) {
            int n4 = replaceStr == null ? 0 : replaceStr.length();
            int n5 = n2;
            this.replaceImpl(n5, n5 + n3, n3, replaceStr, n4);
        }
        return this;
    }

    public StrBuilder replaceAll(StrMatcher matcher, String replaceStr) {
        return this.replace(matcher, replaceStr, 0, this.size, -1);
    }

    public StrBuilder replaceFirst(StrMatcher matcher, String replaceStr) {
        return this.replace(matcher, replaceStr, 0, this.size, 1);
    }

    public StrBuilder replace(StrMatcher matcher, String replaceStr, int startIndex, int endIndex, int replaceCount) {
        endIndex = this.validateRange(startIndex, endIndex);
        return this.replaceImpl(matcher, replaceStr, startIndex, endIndex, replaceCount);
    }

    private StrBuilder replaceImpl(StrMatcher matcher, String replaceStr, int from, int to, int replaceCount) {
        if (matcher == null || this.size == 0) {
            return this;
        }
        int n2 = replaceStr == null ? 0 : replaceStr.length();
        for (int i2 = from; i2 < to && replaceCount != 0; ++i2) {
            char[] cArray = this.buffer;
            int n3 = matcher.isMatch(cArray, i2, from, to);
            if (n3 <= 0) continue;
            int n4 = i2;
            this.replaceImpl(n4, n4 + n3, n3, replaceStr, n2);
            to = to - n3 + n2;
            i2 = i2 + n2 - 1;
            if (replaceCount <= 0) continue;
            --replaceCount;
        }
        return this;
    }

    public StrBuilder reverse() {
        if (this.size == 0) {
            return this;
        }
        int n2 = this.size / 2;
        char[] cArray = this.buffer;
        int n3 = 0;
        int n4 = this.size - 1;
        while (n3 < n2) {
            char c2 = cArray[n3];
            cArray[n3] = cArray[n4];
            cArray[n4] = c2;
            ++n3;
            --n4;
        }
        return this;
    }

    public StrBuilder trim() {
        int n2;
        if (this.size == 0) {
            return this;
        }
        int n3 = this.size;
        char[] cArray = this.buffer;
        for (n2 = 0; n2 < n3 && cArray[n2] <= ' '; ++n2) {
        }
        while (n2 < n3 && cArray[n3 - 1] <= ' ') {
            --n3;
        }
        if (n3 < this.size) {
            this.delete(n3, this.size);
        }
        if (n2 > 0) {
            this.delete(0, n2);
        }
        return this;
    }

    public boolean startsWith(String str) {
        if (str == null) {
            return false;
        }
        int n2 = str.length();
        if (n2 == 0) {
            return true;
        }
        if (n2 > this.size) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.buffer[i2] == str.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(String str) {
        if (str == null) {
            return false;
        }
        int n2 = str.length();
        if (n2 == 0) {
            return true;
        }
        if (n2 > this.size) {
            return false;
        }
        int n3 = this.size - n2;
        int n4 = 0;
        while (n4 < n2) {
            if (this.buffer[n3] != str.charAt(n4)) {
                return false;
            }
            ++n4;
            ++n3;
        }
        return true;
    }

    @Override
    public CharSequence subSequence(int startIndex, int endIndex) {
        if (startIndex < 0) {
            throw new StringIndexOutOfBoundsException(startIndex);
        }
        if (endIndex > this.size) {
            throw new StringIndexOutOfBoundsException(endIndex);
        }
        if (startIndex > endIndex) {
            throw new StringIndexOutOfBoundsException(endIndex - startIndex);
        }
        return this.substring(startIndex, endIndex);
    }

    public String substring(int start) {
        return this.substring(start, this.size);
    }

    public String substring(int startIndex, int endIndex) {
        endIndex = this.validateRange(startIndex, endIndex);
        return new String(this.buffer, startIndex, endIndex - startIndex);
    }

    public String leftString(int length) {
        if (length <= 0) {
            return "";
        }
        if (length >= this.size) {
            return new String(this.buffer, 0, this.size);
        }
        return new String(this.buffer, 0, length);
    }

    public String rightString(int length) {
        if (length <= 0) {
            return "";
        }
        if (length >= this.size) {
            return new String(this.buffer, 0, this.size);
        }
        return new String(this.buffer, this.size - length, length);
    }

    public String midString(int index, int length) {
        if (index < 0) {
            index = 0;
        }
        if (length <= 0 || index >= this.size) {
            return "";
        }
        if (this.size <= index + length) {
            return new String(this.buffer, index, this.size - index);
        }
        return new String(this.buffer, index, length);
    }

    public boolean contains(char ch) {
        char[] cArray = this.buffer;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (cArray[i2] != ch) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String str) {
        return this.indexOf(str, 0) >= 0;
    }

    public boolean contains(StrMatcher matcher) {
        return this.indexOf(matcher, 0) >= 0;
    }

    public int indexOf(char ch) {
        return this.indexOf(ch, 0);
    }

    public int indexOf(char ch, int startIndex) {
        if ((startIndex = startIndex < 0 ? 0 : startIndex) >= this.size) {
            return -1;
        }
        char[] cArray = this.buffer;
        for (int i2 = startIndex; i2 < this.size; ++i2) {
            if (cArray[i2] != ch) continue;
            return i2;
        }
        return -1;
    }

    public int indexOf(String str) {
        return this.indexOf(str, 0);
    }

    public int indexOf(String str, int startIndex) {
        int n2 = startIndex = startIndex < 0 ? 0 : startIndex;
        if (str == null || startIndex >= this.size) {
            return -1;
        }
        int n3 = str.length();
        if (n3 == 1) {
            return this.indexOf(str.charAt(0), startIndex);
        }
        if (n3 == 0) {
            return startIndex;
        }
        if (n3 > this.size) {
            return -1;
        }
        char[] cArray = this.buffer;
        int n4 = this.size - n3 + 1;
        block0: for (int i2 = startIndex; i2 < n4; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                if (str.charAt(i3) != cArray[i2 + i3]) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public int indexOf(StrMatcher matcher) {
        return this.indexOf(matcher, 0);
    }

    public int indexOf(StrMatcher matcher, int startIndex) {
        int n2 = startIndex = startIndex < 0 ? 0 : startIndex;
        if (matcher == null || startIndex >= this.size) {
            return -1;
        }
        int n3 = this.size;
        char[] cArray = this.buffer;
        for (int i2 = startIndex; i2 < n3; ++i2) {
            if (matcher.isMatch(cArray, i2, startIndex, n3) <= 0) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexOf(char ch) {
        return this.lastIndexOf(ch, this.size - 1);
    }

    public int lastIndexOf(char ch, int startIndex) {
        if ((startIndex = startIndex >= this.size ? this.size - 1 : startIndex) < 0) {
            return -1;
        }
        for (int i2 = startIndex; i2 >= 0; --i2) {
            if (this.buffer[i2] != ch) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexOf(String str) {
        return this.lastIndexOf(str, this.size - 1);
    }

    public int lastIndexOf(String str, int startIndex) {
        int n2 = startIndex = startIndex >= this.size ? this.size - 1 : startIndex;
        if (str == null || startIndex < 0) {
            return -1;
        }
        int n3 = str.length();
        if (n3 > 0 && n3 <= this.size) {
            if (n3 == 1) {
                return this.lastIndexOf(str.charAt(0), startIndex);
            }
            block0: for (int i2 = startIndex - n3 + 1; i2 >= 0; --i2) {
                for (int i3 = 0; i3 < n3; ++i3) {
                    if (str.charAt(i3) != this.buffer[i2 + i3]) continue block0;
                }
                return i2;
            }
        } else if (n3 == 0) {
            return startIndex;
        }
        return -1;
    }

    public int lastIndexOf(StrMatcher matcher) {
        return this.lastIndexOf(matcher, this.size);
    }

    public int lastIndexOf(StrMatcher matcher, int startIndex) {
        int n2 = startIndex = startIndex >= this.size ? this.size - 1 : startIndex;
        if (matcher == null || startIndex < 0) {
            return -1;
        }
        char[] cArray = this.buffer;
        int n3 = startIndex + 1;
        for (int i2 = startIndex; i2 >= 0; --i2) {
            if (matcher.isMatch(cArray, i2, 0, n3) <= 0) continue;
            return i2;
        }
        return -1;
    }

    public StrTokenizer asTokenizer() {
        return new StrBuilderTokenizer();
    }

    public Reader asReader() {
        return new StrBuilderReader();
    }

    public Writer asWriter() {
        return new StrBuilderWriter();
    }

    public void appendTo(Appendable appendable) throws IOException {
        if (appendable instanceof Writer) {
            ((Writer)appendable).write(this.buffer, 0, this.size);
            return;
        }
        if (appendable instanceof StringBuilder) {
            ((StringBuilder)appendable).append(this.buffer, 0, this.size);
            return;
        }
        if (appendable instanceof StringBuffer) {
            ((StringBuffer)appendable).append(this.buffer, 0, this.size);
            return;
        }
        if (appendable instanceof CharBuffer) {
            ((CharBuffer)appendable).put(this.buffer, 0, this.size);
            return;
        }
        appendable.append(this);
    }

    public boolean equalsIgnoreCase(StrBuilder other) {
        if (this == other) {
            return true;
        }
        if (this.size != other.size) {
            return false;
        }
        char[] cArray = this.buffer;
        char[] cArray2 = other.buffer;
        for (int i2 = this.size - 1; i2 >= 0; --i2) {
            char c2 = cArray[i2];
            char c3 = cArray2[i2];
            if (c2 == c3 || Character.toUpperCase(c2) == Character.toUpperCase(c3)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(StrBuilder other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        char[] cArray = this.buffer;
        char[] cArray2 = other.buffer;
        for (int i2 = this.size - 1; i2 >= 0; --i2) {
            if (cArray[i2] == cArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        return obj instanceof StrBuilder && this.equals((StrBuilder)obj);
    }

    public int hashCode() {
        char[] cArray = this.buffer;
        int n2 = 0;
        for (int i2 = this.size - 1; i2 >= 0; --i2) {
            n2 = n2 * 31 + cArray[i2];
        }
        return n2;
    }

    @Override
    public String toString() {
        return new String(this.buffer, 0, this.size);
    }

    public StringBuffer toStringBuffer() {
        return new StringBuffer(this.size).append(this.buffer, 0, this.size);
    }

    public StringBuilder toStringBuilder() {
        return new StringBuilder(this.size).append(this.buffer, 0, this.size);
    }

    @Override
    public String build() {
        return this.toString();
    }

    protected int validateRange(int startIndex, int endIndex) {
        if (startIndex < 0) {
            throw new StringIndexOutOfBoundsException(startIndex);
        }
        if (endIndex > this.size) {
            endIndex = this.size;
        }
        if (startIndex > endIndex) {
            throw new StringIndexOutOfBoundsException("end < start");
        }
        return endIndex;
    }

    protected void validateIndex(int index) {
        if (index < 0 || index > this.size) {
            throw new StringIndexOutOfBoundsException(index);
        }
    }

    class StrBuilderWriter
    extends Writer {
        StrBuilderWriter() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(int c2) {
            StrBuilder.this.append((char)c2);
        }

        @Override
        public void write(char[] cbuf) {
            StrBuilder.this.append(cbuf);
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
            StrBuilder.this.append(cbuf, off, len);
        }

        @Override
        public void write(String str) {
            StrBuilder.this.append(str);
        }

        @Override
        public void write(String str, int off, int len) {
            StrBuilder.this.append(str, off, len);
        }
    }

    class StrBuilderReader
    extends Reader {
        private int pos;
        private int mark;

        StrBuilderReader() {
        }

        @Override
        public void close() {
        }

        @Override
        public int read() {
            if (!this.ready()) {
                return -1;
            }
            return StrBuilder.this.charAt(this.pos++);
        }

        @Override
        public int read(char[] b2, int off, int len) {
            if (off < 0 || len < 0 || off > b2.length || off + len > b2.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (this.pos >= StrBuilder.this.size()) {
                return -1;
            }
            if (this.pos + len > StrBuilder.this.size()) {
                len = StrBuilder.this.size() - this.pos;
            }
            StrBuilder.this.getChars(this.pos, this.pos + len, b2, off);
            this.pos += len;
            return len;
        }

        @Override
        public long skip(long n2) {
            if ((long)this.pos + n2 > (long)StrBuilder.this.size()) {
                n2 = StrBuilder.this.size() - this.pos;
            }
            if (n2 < 0L) {
                return 0L;
            }
            this.pos = (int)((long)this.pos + n2);
            return n2;
        }

        @Override
        public boolean ready() {
            return this.pos < StrBuilder.this.size();
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int readAheadLimit) {
            this.mark = this.pos;
        }

        @Override
        public void reset() {
            this.pos = this.mark;
        }
    }

    class StrBuilderTokenizer
    extends StrTokenizer {
        StrBuilderTokenizer() {
        }

        @Override
        protected List<String> tokenize(char[] chars, int offset, int count) {
            if (chars == null) {
                StrBuilderTokenizer strBuilderTokenizer = this;
                return super.tokenize(strBuilderTokenizer.StrBuilder.this.buffer, 0, StrBuilder.this.size());
            }
            return super.tokenize(chars, offset, count);
        }

        @Override
        public String getContent() {
            String string = super.getContent();
            if (string == null) {
                return StrBuilder.this.toString();
            }
            return string;
        }
    }
}

