/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.DatePrinter;

public class FastDatePrinter
implements Serializable,
DatePrinter {
    private static final long serialVersionUID = 1L;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    private final String mPattern;
    private final TimeZone mTimeZone;
    private final Locale mLocale;
    private transient Rule[] mRules;
    private transient int mMaxLengthEstimate;
    private static final int MAX_DIGITS = 10;
    private static final ConcurrentMap<TimeZoneDisplayKey, String> cTimeZoneDisplayCache = new ConcurrentHashMap<TimeZoneDisplayKey, String>(7);

    protected FastDatePrinter(String pattern, TimeZone timeZone, Locale locale) {
        this.mPattern = pattern;
        this.mTimeZone = timeZone;
        this.mLocale = locale;
        this.init();
    }

    private void init() {
        List<Rule> list;
        List<Rule> list2 = list = this.parsePattern();
        this.mRules = list2.toArray(new Rule[list2.size()]);
        int n2 = 0;
        int n3 = this.mRules.length;
        while (--n3 >= 0) {
            n2 += this.mRules[n3].estimateLength();
        }
        this.mMaxLengthEstimate = n2;
    }

    protected List<Rule> parsePattern() {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.mLocale);
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        String[] stringArray = dateFormatSymbols.getEras();
        String[] stringArray2 = dateFormatSymbols.getMonths();
        String[] stringArray3 = dateFormatSymbols.getShortMonths();
        String[] stringArray4 = dateFormatSymbols.getWeekdays();
        String[] stringArray5 = dateFormatSymbols.getShortWeekdays();
        String[] stringArray6 = dateFormatSymbols.getAmPmStrings();
        int n2 = this.mPattern.length();
        int[] nArray = new int[1];
        for (int i2 = 0; i2 < n2; ++i2) {
            Rule rule;
            nArray[0] = i2;
            FastDatePrinter fastDatePrinter = this;
            String string = fastDatePrinter.parseToken(fastDatePrinter.mPattern, nArray);
            i2 = nArray[0];
            int n3 = string.length();
            if (n3 == 0) break;
            char c2 = string.charAt(0);
            switch (c2) {
                case 'G': {
                    rule = new TextField(0, stringArray);
                    break;
                }
                case 'Y': 
                case 'y': {
                    rule = n3 == 2 ? TwoDigitYearField.INSTANCE : this.selectNumberRule(1, n3 < 4 ? 4 : n3);
                    if (c2 != 'Y') break;
                    rule = new WeekYear((NumberRule)rule);
                    break;
                }
                case 'M': {
                    if (n3 >= 4) {
                        rule = new TextField(2, stringArray2);
                        break;
                    }
                    if (n3 == 3) {
                        rule = new TextField(2, stringArray3);
                        break;
                    }
                    if (n3 == 2) {
                        rule = TwoDigitMonthField.INSTANCE;
                        break;
                    }
                    rule = UnpaddedMonthField.INSTANCE;
                    break;
                }
                case 'd': {
                    rule = this.selectNumberRule(5, n3);
                    break;
                }
                case 'h': {
                    rule = new TwelveHourField(this.selectNumberRule(10, n3));
                    break;
                }
                case 'H': {
                    rule = this.selectNumberRule(11, n3);
                    break;
                }
                case 'm': {
                    rule = this.selectNumberRule(12, n3);
                    break;
                }
                case 's': {
                    rule = this.selectNumberRule(13, n3);
                    break;
                }
                case 'S': {
                    rule = this.selectNumberRule(14, n3);
                    break;
                }
                case 'E': {
                    rule = new TextField(7, n3 < 4 ? stringArray5 : stringArray4);
                    break;
                }
                case 'u': {
                    rule = new DayInWeekField(this.selectNumberRule(7, n3));
                    break;
                }
                case 'D': {
                    rule = this.selectNumberRule(6, n3);
                    break;
                }
                case 'F': {
                    rule = this.selectNumberRule(8, n3);
                    break;
                }
                case 'w': {
                    rule = this.selectNumberRule(3, n3);
                    break;
                }
                case 'W': {
                    rule = this.selectNumberRule(4, n3);
                    break;
                }
                case 'a': {
                    rule = new TextField(9, stringArray6);
                    break;
                }
                case 'k': {
                    rule = new TwentyFourHourField(this.selectNumberRule(11, n3));
                    break;
                }
                case 'K': {
                    rule = this.selectNumberRule(10, n3);
                    break;
                }
                case 'X': {
                    rule = Iso8601_Rule.getRule(n3);
                    break;
                }
                case 'z': {
                    if (n3 >= 4) {
                        rule = new TimeZoneNameRule(this.mTimeZone, this.mLocale, 1);
                        break;
                    }
                    rule = new TimeZoneNameRule(this.mTimeZone, this.mLocale, 0);
                    break;
                }
                case 'Z': {
                    if (n3 == 1) {
                        rule = TimeZoneNumberRule.INSTANCE_NO_COLON;
                        break;
                    }
                    if (n3 == 2) {
                        rule = Iso8601_Rule.ISO8601_HOURS_COLON_MINUTES;
                        break;
                    }
                    rule = TimeZoneNumberRule.INSTANCE_COLON;
                    break;
                }
                case '\'': {
                    String string2 = string.substring(1);
                    if (string2.length() == 1) {
                        rule = new CharacterLiteral(string2.charAt(0));
                        break;
                    }
                    rule = new StringLiteral(string2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal pattern component: " + string);
                }
            }
            arrayList.add(rule);
        }
        return arrayList;
    }

    protected String parseToken(String pattern, int[] indexRef) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = pattern.length();
        char c2 = pattern.charAt(n2);
        if (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z') {
            char c3;
            stringBuilder.append(c2);
            while (n2 + 1 < n3 && (c3 = pattern.charAt(n2 + 1)) == c2) {
                stringBuilder.append(c2);
                ++n2;
            }
        } else {
            stringBuilder.append('\'');
            boolean bl = false;
            for (n2 = indexRef[0]; n2 < n3; ++n2) {
                c2 = pattern.charAt(n2);
                if (c2 == '\'') {
                    if (n2 + 1 < n3 && pattern.charAt(n2 + 1) == '\'') {
                        ++n2;
                        stringBuilder.append(c2);
                        continue;
                    }
                    bl = !bl;
                    continue;
                }
                if (bl || (c2 < 'A' || c2 > 'Z') && (c2 < 'a' || c2 > 'z')) {
                    stringBuilder.append(c2);
                    continue;
                }
                break;
            }
        }
        indexRef[0] = --n2;
        return stringBuilder.toString();
    }

    protected NumberRule selectNumberRule(int field, int padding) {
        switch (padding) {
            case 1: {
                return new UnpaddedNumberField(field);
            }
            case 2: {
                return new TwoDigitNumberField(field);
            }
        }
        return new PaddedNumberField(field, padding);
    }

    @Override
    @Deprecated
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj instanceof Date) {
            return this.format((Date)obj, toAppendTo);
        }
        if (obj instanceof Calendar) {
            return this.format((Calendar)obj, toAppendTo);
        }
        if (obj instanceof Long) {
            return this.format((long)((Long)obj), toAppendTo);
        }
        throw new IllegalArgumentException("Unknown class: " + (obj == null ? "<null>" : obj.getClass().getName()));
    }

    String format(Object obj) {
        if (obj instanceof Date) {
            return this.format((Date)obj);
        }
        if (obj instanceof Calendar) {
            return this.format((Calendar)obj);
        }
        if (obj instanceof Long) {
            return this.format((Long)obj);
        }
        throw new IllegalArgumentException("Unknown class: " + (obj == null ? "<null>" : obj.getClass().getName()));
    }

    @Override
    public String format(long millis) {
        Calendar calendar = this.newCalendar();
        calendar.setTimeInMillis(millis);
        return this.applyRulesToString(calendar);
    }

    private String applyRulesToString(Calendar c2) {
        return this.applyRules(c2, new StringBuilder(this.mMaxLengthEstimate)).toString();
    }

    private Calendar newCalendar() {
        return Calendar.getInstance(this.mTimeZone, this.mLocale);
    }

    @Override
    public String format(Date date) {
        Calendar calendar = this.newCalendar();
        calendar.setTime(date);
        return this.applyRulesToString(calendar);
    }

    @Override
    public String format(Calendar calendar) {
        return this.format(calendar, new StringBuilder(this.mMaxLengthEstimate)).toString();
    }

    @Override
    public StringBuffer format(long millis, StringBuffer buf) {
        Calendar calendar = this.newCalendar();
        calendar.setTimeInMillis(millis);
        return this.applyRules(calendar, (Appendable)buf);
    }

    @Override
    public StringBuffer format(Date date, StringBuffer buf) {
        Calendar calendar = this.newCalendar();
        calendar.setTime(date);
        return this.applyRules(calendar, (Appendable)buf);
    }

    @Override
    public StringBuffer format(Calendar calendar, StringBuffer buf) {
        return this.format(calendar.getTime(), buf);
    }

    @Override
    public <B extends Appendable> B format(long millis, B buf) {
        Calendar calendar = this.newCalendar();
        calendar.setTimeInMillis(millis);
        return this.applyRules(calendar, buf);
    }

    @Override
    public <B extends Appendable> B format(Date date, B buf) {
        Calendar calendar = this.newCalendar();
        calendar.setTime(date);
        return this.applyRules(calendar, buf);
    }

    @Override
    public <B extends Appendable> B format(Calendar calendar, B buf) {
        if (!calendar.getTimeZone().equals(this.mTimeZone)) {
            calendar = (Calendar)calendar.clone();
            calendar.setTimeZone(this.mTimeZone);
        }
        return this.applyRules(calendar, buf);
    }

    @Deprecated
    protected StringBuffer applyRules(Calendar calendar, StringBuffer buf) {
        return this.applyRules(calendar, (Appendable)buf);
    }

    private <B extends Appendable> B applyRules(Calendar calendar, B buf) {
        try {
            Rule[] ruleArray = this.mRules;
            int n2 = this.mRules.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Rule rule = ruleArray[i2];
                rule.appendTo(buf, calendar);
            }
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            ExceptionUtils.rethrow(iOException);
        }
        return buf;
    }

    @Override
    public String getPattern() {
        return this.mPattern;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.mTimeZone;
    }

    @Override
    public Locale getLocale() {
        return this.mLocale;
    }

    public int getMaxLengthEstimate() {
        return this.mMaxLengthEstimate;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FastDatePrinter)) {
            return false;
        }
        FastDatePrinter fastDatePrinter = (FastDatePrinter)obj;
        return this.mPattern.equals(fastDatePrinter.mPattern) && this.mTimeZone.equals(fastDatePrinter.mTimeZone) && this.mLocale.equals(fastDatePrinter.mLocale);
    }

    public int hashCode() {
        return this.mPattern.hashCode() + 13 * (this.mTimeZone.hashCode() + 13 * this.mLocale.hashCode());
    }

    public String toString() {
        return "FastDatePrinter[" + this.mPattern + "," + this.mLocale + "," + this.mTimeZone.getID() + "]";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    private static void appendDigits(Appendable buffer, int value) throws IOException {
        buffer.append((char)(value / 10 + 48));
        buffer.append((char)(value % 10 + 48));
    }

    private static void appendFullDigits(Appendable buffer, int value, int minFieldWidth) throws IOException {
        if (value < 10000) {
            int n2 = 4;
            if (value < 1000) {
                --n2;
                if (value < 100) {
                    --n2;
                    if (value < 10) {
                        --n2;
                    }
                }
            }
            for (int i2 = minFieldWidth - n2; i2 > 0; --i2) {
                buffer.append('0');
            }
            switch (n2) {
                case 4: {
                    buffer.append((char)(value / 1000 + 48));
                    value %= 1000;
                }
                case 3: {
                    if (value >= 100) {
                        buffer.append((char)(value / 100 + 48));
                        value %= 100;
                    } else {
                        buffer.append('0');
                    }
                }
                case 2: {
                    if (value >= 10) {
                        buffer.append((char)(value / 10 + 48));
                        value %= 10;
                    } else {
                        buffer.append('0');
                    }
                }
                case 1: {
                    buffer.append((char)(value + 48));
                }
            }
            return;
        }
        char[] cArray = new char[10];
        int n3 = 0;
        while (value != 0) {
            cArray[n3++] = (char)(value % 10 + 48);
            value /= 10;
        }
        while (n3 < minFieldWidth) {
            buffer.append('0');
            --minFieldWidth;
        }
        while (--n3 >= 0) {
            buffer.append(cArray[n3]);
        }
    }

    static String getTimeZoneDisplay(TimeZone tz, boolean daylight, int style, Locale locale) {
        String string;
        TimeZoneDisplayKey timeZoneDisplayKey = new TimeZoneDisplayKey(tz, daylight, style, locale);
        String string2 = (String)cTimeZoneDisplayCache.get(timeZoneDisplayKey);
        if (string2 == null && (string = cTimeZoneDisplayCache.putIfAbsent(timeZoneDisplayKey, string2 = tz.getDisplayName(daylight, style, locale))) != null) {
            string2 = string;
        }
        return string2;
    }

    private static class TimeZoneDisplayKey {
        private final TimeZone mTimeZone;
        private final int mStyle;
        private final Locale mLocale;

        TimeZoneDisplayKey(TimeZone timeZone, boolean daylight, int style, Locale locale) {
            this.mTimeZone = timeZone;
            this.mStyle = daylight ? style | Integer.MIN_VALUE : style;
            this.mLocale = locale;
        }

        public int hashCode() {
            return (this.mStyle * 31 + this.mLocale.hashCode()) * 31 + this.mTimeZone.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof TimeZoneDisplayKey) {
                TimeZoneDisplayKey timeZoneDisplayKey = (TimeZoneDisplayKey)obj;
                return this.mTimeZone.equals(timeZoneDisplayKey.mTimeZone) && this.mStyle == timeZoneDisplayKey.mStyle && this.mLocale.equals(timeZoneDisplayKey.mLocale);
            }
            return false;
        }
    }

    private static class Iso8601_Rule
    implements Rule {
        static final Iso8601_Rule ISO8601_HOURS = new Iso8601_Rule(3);
        static final Iso8601_Rule ISO8601_HOURS_MINUTES = new Iso8601_Rule(5);
        static final Iso8601_Rule ISO8601_HOURS_COLON_MINUTES = new Iso8601_Rule(6);
        final int length;

        static Iso8601_Rule getRule(int tokenLen) {
            switch (tokenLen) {
                case 1: {
                    return ISO8601_HOURS;
                }
                case 2: {
                    return ISO8601_HOURS_MINUTES;
                }
                case 3: {
                    return ISO8601_HOURS_COLON_MINUTES;
                }
            }
            throw new IllegalArgumentException("invalid number of X");
        }

        Iso8601_Rule(int length) {
            this.length = length;
        }

        @Override
        public int estimateLength() {
            return this.length;
        }

        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            int n2 = calendar.get(15) + calendar.get(16);
            if (n2 == 0) {
                buffer.append("Z");
                return;
            }
            if (n2 < 0) {
                buffer.append('-');
                n2 = -n2;
            } else {
                buffer.append('+');
            }
            int n3 = n2 / 3600000;
            FastDatePrinter.appendDigits(buffer, n3);
            if (this.length < 5) {
                return;
            }
            if (this.length == 6) {
                buffer.append(':');
            }
            int n4 = n2 / 60000 - n3 * 60;
            FastDatePrinter.appendDigits(buffer, n4);
        }
    }

    private static class TimeZoneNumberRule
    implements Rule {
        static final TimeZoneNumberRule INSTANCE_COLON = new TimeZoneNumberRule(true);
        static final TimeZoneNumberRule INSTANCE_NO_COLON = new TimeZoneNumberRule(false);
        final boolean mColon;

        TimeZoneNumberRule(boolean colon) {
            this.mColon = colon;
        }

        @Override
        public int estimateLength() {
            return 5;
        }

        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            int n2 = calendar.get(15) + calendar.get(16);
            if (n2 < 0) {
                buffer.append('-');
                n2 = -n2;
            } else {
                buffer.append('+');
            }
            int n3 = n2 / 3600000;
            FastDatePrinter.appendDigits(buffer, n3);
            if (this.mColon) {
                buffer.append(':');
            }
            int n4 = n2 / 60000 - n3 * 60;
            FastDatePrinter.appendDigits(buffer, n4);
        }
    }

    private static class TimeZoneNameRule
    implements Rule {
        private final Locale mLocale;
        private final int mStyle;
        private final String mStandard;
        private final String mDaylight;

        TimeZoneNameRule(TimeZone timeZone, Locale locale, int style) {
            this.mLocale = locale;
            this.mStyle = style;
            this.mStandard = FastDatePrinter.getTimeZoneDisplay(timeZone, false, style, locale);
            this.mDaylight = FastDatePrinter.getTimeZoneDisplay(timeZone, true, style, locale);
        }

        @Override
        public int estimateLength() {
            return Math.max(this.mStandard.length(), this.mDaylight.length());
        }

        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            TimeZone timeZone = calendar.getTimeZone();
            if (calendar.get(16) != 0) {
                buffer.append(FastDatePrinter.getTimeZoneDisplay(timeZone, true, this.mStyle, this.mLocale));
                return;
            }
            buffer.append(FastDatePrinter.getTimeZoneDisplay(timeZone, false, this.mStyle, this.mLocale));
        }
    }

    private static class WeekYear
    implements NumberRule {
        private final NumberRule mRule;

        WeekYear(NumberRule rule) {
            this.mRule = rule;
        }

        @Override
        public int estimateLength() {
            return this.mRule.estimateLength();
        }

        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            this.mRule.appendTo(buffer, calendar.getWeekYear());
        }

        @Override
        public void appendTo(Appendable buffer, int value) throws IOException {
            this.mRule.appendTo(buffer, value);
        }
    }

    private static class DayInWeekField
    implements NumberRule {
        private final NumberRule mRule;

        DayInWeekField(NumberRule rule) {
            this.mRule = rule;
        }

        @Override
        public int estimateLength() {
            return this.mRule.estimateLength();
        }

        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            int n2 = calendar.get(7);
            this.mRule.appendTo(buffer, n2 != 1 ? n2 - 1 : 7);
        }

        @Override
        public void appendTo(Appendable buffer, int value) throws IOException {
            this.mRule.appendTo(buffer, value);
        }
    }

    private static class TwentyFourHourField
    implements NumberRule {
        private final NumberRule mRule;

        TwentyFourHourField(NumberRule rule) {
            this.mRule = rule;
        }

        @Override
        public int estimateLength() {
            return this.mRule.estimateLength();
        }

        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            int n2 = calendar.get(11);
            if (n2 == 0) {
                n2 = calendar.getMaximum(11) + 1;
            }
            this.mRule.appendTo(buffer, n2);
        }

        @Override
        public void appendTo(Appendable buffer, int value) throws IOException {
            this.mRule.appendTo(buffer, value);
        }
    }

    private static class TwelveHourField
    implements NumberRule {
        private final NumberRule mRule;

        TwelveHourField(NumberRule rule) {
            this.mRule = rule;
        }

        @Override
        public int estimateLength() {
            return this.mRule.estimateLength();
        }

        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            int n2 = calendar.get(10);
            if (n2 == 0) {
                n2 = calendar.getLeastMaximum(10) + 1;
            }
            this.mRule.appendTo(buffer, n2);
        }

        @Override
        public void appendTo(Appendable buffer, int value) throws IOException {
            this.mRule.appendTo(buffer, value);
        }
    }

    private static class TwoDigitMonthField
    implements NumberRule {
        static final TwoDigitMonthField INSTANCE = new TwoDigitMonthField();

        TwoDigitMonthField() {
        }

        @Override
        public int estimateLength() {
            return 2;
        }

        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            this.appendTo(buffer, calendar.get(2) + 1);
        }

        @Override
        public final void appendTo(Appendable buffer, int value) throws IOException {
            FastDatePrinter.appendDigits(buffer, value);
        }
    }

    private static class TwoDigitYearField
    implements NumberRule {
        static final TwoDigitYearField INSTANCE = new TwoDigitYearField();

        TwoDigitYearField() {
        }

        @Override
        public int estimateLength() {
            return 2;
        }

        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            this.appendTo(buffer, calendar.get(1) % 100);
        }

        @Override
        public final void appendTo(Appendable buffer, int value) throws IOException {
            FastDatePrinter.appendDigits(buffer, value);
        }
    }

    private static class TwoDigitNumberField
    implements NumberRule {
        private final int mField;

        TwoDigitNumberField(int field) {
            this.mField = field;
        }

        @Override
        public int estimateLength() {
            return 2;
        }

        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            this.appendTo(buffer, calendar.get(this.mField));
        }

        @Override
        public final void appendTo(Appendable buffer, int value) throws IOException {
            if (value < 100) {
                FastDatePrinter.appendDigits(buffer, value);
                return;
            }
            FastDatePrinter.appendFullDigits(buffer, value, 2);
        }
    }

    private static class PaddedNumberField
    implements NumberRule {
        private final int mField;
        private final int mSize;

        PaddedNumberField(int field, int size) {
            if (size < 3) {
                throw new IllegalArgumentException();
            }
            this.mField = field;
            this.mSize = size;
        }

        @Override
        public int estimateLength() {
            return this.mSize;
        }

        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            this.appendTo(buffer, calendar.get(this.mField));
        }

        @Override
        public final void appendTo(Appendable buffer, int value) throws IOException {
            FastDatePrinter.appendFullDigits(buffer, value, this.mSize);
        }
    }

    private static class UnpaddedMonthField
    implements NumberRule {
        static final UnpaddedMonthField INSTANCE = new UnpaddedMonthField();

        UnpaddedMonthField() {
        }

        @Override
        public int estimateLength() {
            return 2;
        }

        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            this.appendTo(buffer, calendar.get(2) + 1);
        }

        @Override
        public final void appendTo(Appendable buffer, int value) throws IOException {
            if (value < 10) {
                buffer.append((char)(value + 48));
                return;
            }
            FastDatePrinter.appendDigits(buffer, value);
        }
    }

    private static class UnpaddedNumberField
    implements NumberRule {
        private final int mField;

        UnpaddedNumberField(int field) {
            this.mField = field;
        }

        @Override
        public int estimateLength() {
            return 4;
        }

        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            this.appendTo(buffer, calendar.get(this.mField));
        }

        @Override
        public final void appendTo(Appendable buffer, int value) throws IOException {
            if (value < 10) {
                buffer.append((char)(value + 48));
                return;
            }
            if (value < 100) {
                FastDatePrinter.appendDigits(buffer, value);
                return;
            }
            FastDatePrinter.appendFullDigits(buffer, value, 1);
        }
    }

    private static class TextField
    implements Rule {
        private final int mField;
        private final String[] mValues;

        TextField(int field, String[] values) {
            this.mField = field;
            this.mValues = values;
        }

        @Override
        public int estimateLength() {
            int n2 = 0;
            int n3 = this.mValues.length;
            while (--n3 >= 0) {
                int n4 = this.mValues[n3].length();
                if (n4 <= n2) continue;
                n2 = n4;
            }
            return n2;
        }

        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            buffer.append(this.mValues[calendar.get(this.mField)]);
        }
    }

    private static class StringLiteral
    implements Rule {
        private final String mValue;

        StringLiteral(String value) {
            this.mValue = value;
        }

        @Override
        public int estimateLength() {
            return this.mValue.length();
        }

        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            buffer.append(this.mValue);
        }
    }

    private static class CharacterLiteral
    implements Rule {
        private final char mValue;

        CharacterLiteral(char value) {
            this.mValue = value;
        }

        @Override
        public int estimateLength() {
            return 1;
        }

        @Override
        public void appendTo(Appendable buffer, Calendar calendar) throws IOException {
            buffer.append(this.mValue);
        }
    }

    private static interface NumberRule
    extends Rule {
        public void appendTo(Appendable var1, int var2) throws IOException;
    }

    private static interface Rule {
        public int estimateLength();

        public void appendTo(Appendable var1, Calendar var2) throws IOException;
    }
}

