/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;

public class LogFactoryImpl
extends LogFactory {
    private static final String LOGGING_IMPL_LOG4J_LOGGER = "org.apache.commons.logging.impl.Log4JLogger";
    private static final String LOGGING_IMPL_JDK14_LOGGER = "org.apache.commons.logging.impl.Jdk14Logger";
    private static final String LOGGING_IMPL_LUMBERJACK_LOGGER = "org.apache.commons.logging.impl.Jdk13LumberjackLogger";
    private static final String LOGGING_IMPL_SIMPLE_LOGGER = "org.apache.commons.logging.impl.SimpleLog";
    private static final String PKG_IMPL = "org.apache.commons.logging.impl.";
    private static final int PKG_LEN = 32;
    public static final String LOG_PROPERTY = "org.apache.commons.logging.Log";
    protected static final String LOG_PROPERTY_OLD = "org.apache.commons.logging.log";
    public static final String ALLOW_FLAWED_CONTEXT_PROPERTY = "org.apache.commons.logging.Log.allowFlawedContext";
    public static final String ALLOW_FLAWED_DISCOVERY_PROPERTY = "org.apache.commons.logging.Log.allowFlawedDiscovery";
    public static final String ALLOW_FLAWED_HIERARCHY_PROPERTY = "org.apache.commons.logging.Log.allowFlawedHierarchy";
    private static final String[] classesToDiscover = new String[]{"org.apache.commons.logging.impl.Log4JLogger", "org.apache.commons.logging.impl.Jdk14Logger", "org.apache.commons.logging.impl.Jdk13LumberjackLogger", "org.apache.commons.logging.impl.SimpleLog"};
    private boolean useTCCL = true;
    private String diagnosticPrefix;
    protected Hashtable attributes = new Hashtable();
    protected Hashtable instances = new Hashtable();
    private String logClassName;
    protected Constructor logConstructor = null;
    protected Class[] logConstructorSignature = new Class[]{class$java$lang$String == null ? (class$java$lang$String = LogFactoryImpl.class$("java.lang.String")) : class$java$lang$String};
    protected Method logMethod = null;
    protected Class[] logMethodSignature = new Class[]{class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = LogFactoryImpl.class$("org.apache.commons.logging.LogFactory")) : class$org$apache$commons$logging$LogFactory};
    private boolean allowFlawedContext;
    private boolean allowFlawedDiscovery;
    private boolean allowFlawedHierarchy;
    static Class class$java$lang$String;
    static Class class$org$apache$commons$logging$LogFactory;
    static Class class$org$apache$commons$logging$impl$LogFactoryImpl;
    static Class class$org$apache$commons$logging$Log;

    public LogFactoryImpl() {
        this.initDiagnostics();
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic("Instance created.");
        }
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    public Log getInstance(Class clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    public Log getInstance(String name) throws LogConfigurationException {
        Log log = (Log)this.instances.get(name);
        if (log == null) {
            log = this.newInstance(name);
            this.instances.put(name, log);
        }
        return log;
    }

    public void release() {
        this.logDiagnostic("Releasing all known loggers");
        this.instances.clear();
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        if (this.logConstructor != null) {
            this.logDiagnostic("setAttribute: call too late; configuration already performed.");
        }
        if (value == null) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, value);
        }
        if (name.equals("use_tccl")) {
            this.useTCCL = value != null && Boolean.valueOf(value.toString()) != false;
        }
    }

    protected static ClassLoader getContextClassLoader() throws LogConfigurationException {
        return LogFactory.getContextClassLoader();
    }

    protected static boolean isDiagnosticsEnabled() {
        return LogFactory.isDiagnosticsEnabled();
    }

    protected static ClassLoader getClassLoader(Class clazz) {
        return LogFactory.getClassLoader(clazz);
    }

    private void initDiagnostics() {
        String string;
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = LogFactoryImpl.getClassLoader(clazz);
        try {
            string = classLoader == null ? "BOOTLOADER" : LogFactoryImpl.objectId(classLoader);
        }
        catch (SecurityException securityException) {
            string = "UNKNOWN";
        }
        this.diagnosticPrefix = "[LogFactoryImpl@" + System.identityHashCode(this) + " from " + string + "] ";
    }

    protected void logDiagnostic(String msg) {
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            LogFactoryImpl.logRawDiagnostic(this.diagnosticPrefix + msg);
        }
    }

    protected String getLogClassName() {
        if (this.logClassName == null) {
            LogFactoryImpl logFactoryImpl = this;
            logFactoryImpl.discoverLogImplementation(logFactoryImpl.getClass().getName());
        }
        return this.logClassName;
    }

    protected Constructor getLogConstructor() throws LogConfigurationException {
        if (this.logConstructor == null) {
            LogFactoryImpl logFactoryImpl = this;
            logFactoryImpl.discoverLogImplementation(logFactoryImpl.getClass().getName());
        }
        return this.logConstructor;
    }

    protected boolean isJdk13LumberjackAvailable() {
        return this.isLogLibraryAvailable("Jdk13Lumberjack", LOGGING_IMPL_LUMBERJACK_LOGGER);
    }

    protected boolean isJdk14Available() {
        return this.isLogLibraryAvailable("Jdk14", LOGGING_IMPL_JDK14_LOGGER);
    }

    protected boolean isLog4JAvailable() {
        return this.isLogLibraryAvailable("Log4J", LOGGING_IMPL_LOG4J_LOGGER);
    }

    protected Log newInstance(String name) throws LogConfigurationException {
        try {
            Object[] objectArray;
            Log log;
            if (this.logConstructor == null) {
                log = this.discoverLogImplementation(name);
            } else {
                objectArray = new Object[]{name};
                log = (Log)this.logConstructor.newInstance(objectArray);
            }
            if (this.logMethod != null) {
                objectArray = new Object[]{this};
                this.logMethod.invoke((Object)log, objectArray);
            }
            return log;
        }
        catch (LogConfigurationException logConfigurationException) {
            LogConfigurationException logConfigurationException2 = logConfigurationException;
            throw logConfigurationException;
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            Throwable throwable = invocationTargetException.getTargetException();
            throw new LogConfigurationException(throwable == null ? invocationTargetException2 : throwable);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            LogFactoryImpl.handleThrowable(throwable);
            throw new LogConfigurationException(throwable2);
        }
    }

    private static ClassLoader getContextClassLoaderInternal() throws LogConfigurationException {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public final Object run() {
                return LogFactoryImpl.access$000();
            }
        });
    }

    private static String getSystemProperty(String key, String def) throws SecurityException {
        return (String)AccessController.doPrivileged(new PrivilegedAction(key, def){
            private final String val$key;
            private final String val$def;
            {
                this.val$key = string;
                this.val$def = string2;
            }

            public final Object run() {
                return System.getProperty(this.val$key, this.val$def);
            }
        });
    }

    private ClassLoader getParentClassLoader(ClassLoader cl) {
        try {
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(this, cl){
                private final ClassLoader val$cl;
                private final LogFactoryImpl this$0;
                {
                    this.this$0 = logFactoryImpl;
                    this.val$cl = classLoader;
                }

                public Object run() {
                    return this.val$cl.getParent();
                }
            });
        }
        catch (SecurityException securityException) {
            this.logDiagnostic("[SECURITY] Unable to obtain parent classloader");
            return null;
        }
    }

    private boolean isLogLibraryAvailable(String name, String classname) {
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic("Checking for '" + name + "'.");
        }
        try {
            Log log = this.createLogFromClass(classname, this.getClass().getName(), false);
            if (log == null) {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("Did not find '" + name + "'.");
                }
                return false;
            }
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic("Found '" + name + "'.");
            }
            return true;
        }
        catch (LogConfigurationException logConfigurationException) {
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic("Logging system '" + name + "' is available but not useable.");
            }
            return false;
        }
    }

    private String getConfigurationValue(String property) {
        block10: {
            Object object;
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic("[ENV] Trying to get configuration for item " + property);
            }
            if ((object = this.getAttribute(property)) != null) {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("[ENV] Found LogFactory attribute [" + object + "] for " + property);
                }
                return object.toString();
            }
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic("[ENV] No LogFactory attribute found for " + property);
            }
            try {
                String string = LogFactoryImpl.getSystemProperty(property, null);
                if (string != null) {
                    if (LogFactoryImpl.isDiagnosticsEnabled()) {
                        this.logDiagnostic("[ENV] Found system property [" + string + "] for " + property);
                    }
                    return string;
                }
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("[ENV] No system property found for property " + property);
                }
            }
            catch (SecurityException securityException) {
                if (!LogFactoryImpl.isDiagnosticsEnabled()) break block10;
                this.logDiagnostic("[ENV] Security prevented reading system property " + property);
            }
        }
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic("[ENV] No configuration defined for item " + property);
        }
        return null;
    }

    private boolean getBooleanConfiguration(String key, boolean dflt) {
        String string = this.getConfigurationValue(key);
        if (string == null) {
            return dflt;
        }
        return Boolean.valueOf(string);
    }

    private void initConfiguration() {
        this.allowFlawedContext = this.getBooleanConfiguration(ALLOW_FLAWED_CONTEXT_PROPERTY, true);
        this.allowFlawedDiscovery = this.getBooleanConfiguration(ALLOW_FLAWED_DISCOVERY_PROPERTY, true);
        this.allowFlawedHierarchy = this.getBooleanConfiguration(ALLOW_FLAWED_HIERARCHY_PROPERTY, true);
    }

    private Log discoverLogImplementation(String logCategory) throws LogConfigurationException {
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic("Discovering a Log implementation...");
        }
        this.initConfiguration();
        Log log = null;
        String string = this.findUserSpecifiedLogClassName();
        if (string != null) {
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                this.logDiagnostic("Attempting to load user-specified log class '" + string + "'...");
            }
            if ((log = this.createLogFromClass(string, logCategory, true)) == null) {
                StringBuffer stringBuffer = new StringBuffer("User-specified log class '");
                stringBuffer.append(string);
                stringBuffer.append("' cannot be found or is not useable.");
                this.informUponSimilarName(stringBuffer, string, LOGGING_IMPL_LOG4J_LOGGER);
                this.informUponSimilarName(stringBuffer, string, LOGGING_IMPL_JDK14_LOGGER);
                this.informUponSimilarName(stringBuffer, string, LOGGING_IMPL_LUMBERJACK_LOGGER);
                this.informUponSimilarName(stringBuffer, string, LOGGING_IMPL_SIMPLE_LOGGER);
                throw new LogConfigurationException(stringBuffer.toString());
            }
            return log;
        }
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic("No user-specified Log implementation; performing discovery using the standard supported logging implementations...");
        }
        for (int i2 = 0; i2 < classesToDiscover.length && log == null; ++i2) {
            log = this.createLogFromClass(classesToDiscover[i2], logCategory, true);
        }
        if (log == null) {
            throw new LogConfigurationException("No suitable Log implementation");
        }
        return log;
    }

    private void informUponSimilarName(StringBuffer messageBuffer, String name, String candidate) {
        if (name.equals(candidate)) {
            return;
        }
        if (name.regionMatches(true, 0, candidate, 0, PKG_LEN + 5)) {
            messageBuffer.append(" Did you mean '");
            messageBuffer.append(candidate);
            messageBuffer.append("'?");
        }
    }

    private String findUserSpecifiedLogClassName() {
        String string;
        block13: {
            block12: {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("Trying to get log class from attribute 'org.apache.commons.logging.Log'");
                }
                if ((string = (String)this.getAttribute(LOG_PROPERTY)) == null) {
                    if (LogFactoryImpl.isDiagnosticsEnabled()) {
                        this.logDiagnostic("Trying to get log class from attribute 'org.apache.commons.logging.log'");
                    }
                    string = (String)this.getAttribute(LOG_PROPERTY_OLD);
                }
                if (string == null) {
                    if (LogFactoryImpl.isDiagnosticsEnabled()) {
                        this.logDiagnostic("Trying to get log class from system property 'org.apache.commons.logging.Log'");
                    }
                    try {
                        string = LogFactoryImpl.getSystemProperty(LOG_PROPERTY, null);
                    }
                    catch (SecurityException securityException) {
                        if (!LogFactoryImpl.isDiagnosticsEnabled()) break block12;
                        this.logDiagnostic("No access allowed to system property 'org.apache.commons.logging.Log' - " + securityException.getMessage());
                    }
                }
            }
            if (string == null) {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("Trying to get log class from system property 'org.apache.commons.logging.log'");
                }
                try {
                    string = LogFactoryImpl.getSystemProperty(LOG_PROPERTY_OLD, null);
                }
                catch (SecurityException securityException) {
                    if (!LogFactoryImpl.isDiagnosticsEnabled()) break block13;
                    this.logDiagnostic("No access allowed to system property 'org.apache.commons.logging.log' - " + securityException.getMessage());
                }
            }
        }
        if (string != null) {
            string = string.trim();
        }
        return string;
    }

    private Log createLogFromClass(String logAdapterClassName, String logCategory, boolean affectState) throws LogConfigurationException {
        Serializable serializable;
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            this.logDiagnostic("Attempting to instantiate '" + logAdapterClassName + "'");
        }
        Object[] objectArray = new Object[]{logCategory};
        Log log = null;
        Constructor constructor = null;
        Serializable serializable2 = null;
        ClassLoader classLoader = this.getBaseClassLoader();
        while (true) {
            Object object;
            this.logDiagnostic("Trying to load '" + logAdapterClassName + "' from classloader " + LogFactoryImpl.objectId(classLoader));
            try {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    object = logAdapterClassName.replace('.', '/') + ".class";
                    serializable = classLoader != null ? classLoader.getResource((String)object) : ClassLoader.getSystemResource((String)object + ".class");
                    if (serializable == null) {
                        this.logDiagnostic("Class '" + logAdapterClassName + "' [" + (String)object + "] cannot be found.");
                    } else {
                        this.logDiagnostic("Class '" + logAdapterClassName + "' was found at '" + serializable + "'");
                    }
                }
                try {
                    serializable = Class.forName(logAdapterClassName, true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    object = classNotFoundException;
                    String string = classNotFoundException.getMessage();
                    this.logDiagnostic("The log adapter '" + logAdapterClassName + "' is not available via classloader " + LogFactoryImpl.objectId(classLoader) + ": " + string.trim());
                    try {
                        serializable = Class.forName(logAdapterClassName);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        ClassNotFoundException classNotFoundException3 = classNotFoundException2;
                        string = classNotFoundException2.getMessage();
                        this.logDiagnostic("The log adapter '" + logAdapterClassName + "' is not available via the LogFactoryImpl class classloader: " + string.trim());
                        break;
                    }
                }
                constructor = ((Class)serializable).getConstructor(this.logConstructorSignature);
                object = constructor.newInstance(objectArray);
                if (object instanceof Log) {
                    serializable2 = serializable;
                    log = (Log)object;
                    break;
                }
                this.handleFlawedHierarchy(classLoader, (Class)serializable);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                serializable = noClassDefFoundError;
                object = noClassDefFoundError.getMessage();
                this.logDiagnostic("The log adapter '" + logAdapterClassName + "' is missing dependencies when loaded via classloader " + LogFactoryImpl.objectId(classLoader) + ": " + ((String)object).trim());
                break;
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                serializable = exceptionInInitializerError;
                object = exceptionInInitializerError.getMessage();
                this.logDiagnostic("The log adapter '" + logAdapterClassName + "' is unable to initialize itself when loaded via classloader " + LogFactoryImpl.objectId(classLoader) + ": " + ((String)object).trim());
                break;
            }
            catch (LogConfigurationException logConfigurationException) {
                serializable = logConfigurationException;
                throw logConfigurationException;
            }
            catch (Throwable throwable) {
                serializable = throwable;
                LogFactoryImpl.handleThrowable(throwable);
                this.handleFlawedDiscovery(logAdapterClassName, classLoader, (Throwable)serializable);
            }
            if (classLoader == null) break;
            classLoader = this.getParentClassLoader(classLoader);
        }
        if (serializable2 != null && affectState) {
            this.logClassName = logAdapterClassName;
            this.logConstructor = constructor;
            try {
                this.logMethod = ((Class)serializable2).getMethod("setLogFactory", this.logMethodSignature);
                this.logDiagnostic("Found method setLogFactory(LogFactory) in '" + logAdapterClassName + "'");
            }
            catch (Throwable throwable) {
                serializable = throwable;
                LogFactoryImpl.handleThrowable(throwable);
                this.logMethod = null;
                this.logDiagnostic("[INFO] '" + logAdapterClassName + "' from classloader " + LogFactoryImpl.objectId(classLoader) + " does not declare optional method setLogFactory(LogFactory)");
            }
            this.logDiagnostic("Log adapter '" + logAdapterClassName + "' from classloader " + LogFactoryImpl.objectId(((Class)serializable2).getClassLoader()) + " has been selected for use.");
        }
        return log;
    }

    private ClassLoader getBaseClassLoader() throws LogConfigurationException {
        ClassLoader classLoader = LogFactoryImpl.getClassLoader(class$org$apache$commons$logging$impl$LogFactoryImpl == null ? (class$org$apache$commons$logging$impl$LogFactoryImpl = LogFactoryImpl.class$("org.apache.commons.logging.impl.LogFactoryImpl")) : class$org$apache$commons$logging$impl$LogFactoryImpl);
        if (!this.useTCCL) {
            return classLoader;
        }
        ClassLoader classLoader2 = LogFactoryImpl.getContextClassLoaderInternal();
        ClassLoader classLoader3 = this.getLowestClassLoader(classLoader2, classLoader);
        if (classLoader3 == null) {
            if (this.allowFlawedContext) {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("[WARNING] the context classloader is not part of a parent-child relationship with the classloader that loaded LogFactoryImpl.");
                }
                return classLoader2;
            }
            throw new LogConfigurationException("Bad classloader hierarchy; LogFactoryImpl was loaded via a classloader that is not related to the current context classloader.");
        }
        if (classLoader3 != classLoader2) {
            if (this.allowFlawedContext) {
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic("Warning: the context classloader is an ancestor of the classloader that loaded LogFactoryImpl; it should be the same or a descendant. The application using commons-logging should ensure the context classloader is used correctly.");
                }
            } else {
                throw new LogConfigurationException("Bad classloader hierarchy; LogFactoryImpl was loaded via a classloader that is not related to the current context classloader.");
            }
        }
        return classLoader3;
    }

    private ClassLoader getLowestClassLoader(ClassLoader c1, ClassLoader c2) {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        ClassLoader classLoader = c1;
        while (classLoader != null) {
            if (classLoader == c2) {
                return c1;
            }
            classLoader = this.getParentClassLoader(classLoader);
        }
        classLoader = c2;
        while (classLoader != null) {
            if (classLoader == c1) {
                return c2;
            }
            classLoader = this.getParentClassLoader(classLoader);
        }
        return null;
    }

    private void handleFlawedDiscovery(String logAdapterClassName, ClassLoader classLoader, Throwable discoveryFlaw) {
        if (LogFactoryImpl.isDiagnosticsEnabled()) {
            InvocationTargetException invocationTargetException;
            Throwable throwable;
            this.logDiagnostic("Could not instantiate Log '" + logAdapterClassName + "' -- " + discoveryFlaw.getClass().getName() + ": " + discoveryFlaw.getLocalizedMessage());
            if (discoveryFlaw instanceof InvocationTargetException && (throwable = (invocationTargetException = (InvocationTargetException)discoveryFlaw).getTargetException()) != null) {
                ExceptionInInitializerError exceptionInInitializerError;
                Throwable throwable2;
                this.logDiagnostic("... InvocationTargetException: " + throwable.getClass().getName() + ": " + throwable.getLocalizedMessage());
                if (throwable instanceof ExceptionInInitializerError && (throwable2 = (exceptionInInitializerError = (ExceptionInInitializerError)throwable).getException()) != null) {
                    StringWriter stringWriter = new StringWriter();
                    throwable2.printStackTrace(new PrintWriter((Writer)stringWriter, true));
                    this.logDiagnostic("... ExceptionInInitializerError: " + stringWriter.toString());
                }
            }
        }
        if (!this.allowFlawedDiscovery) {
            throw new LogConfigurationException(discoveryFlaw);
        }
    }

    private void handleFlawedHierarchy(ClassLoader badClassLoader, Class badClass) throws LogConfigurationException {
        boolean bl = false;
        String string = (class$org$apache$commons$logging$Log == null ? (class$org$apache$commons$logging$Log = LogFactoryImpl.class$(LOG_PROPERTY)) : class$org$apache$commons$logging$Log).getName();
        Class<?>[] classArray = badClass.getInterfaces();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (!string.equals(classArray[i2].getName())) continue;
            bl = true;
            break;
        }
        if (bl) {
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                try {
                    ClassLoader classLoader = LogFactoryImpl.getClassLoader(class$org$apache$commons$logging$Log == null ? (class$org$apache$commons$logging$Log = LogFactoryImpl.class$(LOG_PROPERTY)) : class$org$apache$commons$logging$Log);
                    this.logDiagnostic("Class '" + badClass.getName() + "' was found in classloader " + LogFactoryImpl.objectId(badClassLoader) + ". It is bound to a Log interface which is not the one loaded from classloader " + LogFactoryImpl.objectId(classLoader));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    LogFactoryImpl.handleThrowable(throwable);
                    this.logDiagnostic("Error while trying to output diagnostics about bad class '" + badClass + "'");
                }
            }
            if (!this.allowFlawedHierarchy) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Terminating logging for this context ");
                stringBuffer.append("due to bad log hierarchy. ");
                stringBuffer.append("You have more than one version of '");
                stringBuffer.append((class$org$apache$commons$logging$Log == null ? (class$org$apache$commons$logging$Log = LogFactoryImpl.class$(LOG_PROPERTY)) : class$org$apache$commons$logging$Log).getName());
                stringBuffer.append("' visible.");
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic(stringBuffer.toString());
                }
                throw new LogConfigurationException(stringBuffer.toString());
            }
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Warning: bad log hierarchy. ");
                stringBuffer.append("You have more than one version of '");
                stringBuffer.append((class$org$apache$commons$logging$Log == null ? (class$org$apache$commons$logging$Log = LogFactoryImpl.class$(LOG_PROPERTY)) : class$org$apache$commons$logging$Log).getName());
                stringBuffer.append("' visible.");
                this.logDiagnostic(stringBuffer.toString());
                return;
            }
        } else {
            if (!this.allowFlawedDiscovery) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Terminating logging for this context. ");
                stringBuffer.append("Log class '");
                stringBuffer.append(badClass.getName());
                stringBuffer.append("' does not implement the Log interface.");
                if (LogFactoryImpl.isDiagnosticsEnabled()) {
                    this.logDiagnostic(stringBuffer.toString());
                }
                throw new LogConfigurationException(stringBuffer.toString());
            }
            if (LogFactoryImpl.isDiagnosticsEnabled()) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("[WARNING] Log class '");
                stringBuffer.append(badClass.getName());
                stringBuffer.append("' does not implement the Log interface.");
                this.logDiagnostic(stringBuffer.toString());
            }
        }
    }

    static Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static ClassLoader access$000() throws LogConfigurationException {
        return LogFactoryImpl.directGetContextClassLoader();
    }
}

