/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;

public final class AlphabetConverter {
    private final Map<Integer, String> originalToEncoded;
    private final Map<String, String> encodedToOriginal;
    private final int encodedLetterLength;
    private static final String ARROW = " -> ";

    private AlphabetConverter(Map<Integer, String> originalToEncoded, Map<String, String> encodedToOriginal, int encodedLetterLength) {
        this.originalToEncoded = originalToEncoded;
        this.encodedToOriginal = encodedToOriginal;
        this.encodedLetterLength = encodedLetterLength;
    }

    public final String encode(String original) throws UnsupportedEncodingException {
        int n2;
        if (original == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < original.length(); i2 += Character.charCount(n2)) {
            n2 = original.codePointAt(i2);
            String string = this.originalToEncoded.get(n2);
            if (string == null) {
                throw new UnsupportedEncodingException("Couldn't find encoding for '" + AlphabetConverter.codePointToString(n2) + "' in " + original);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public final String decode(String encoded) throws UnsupportedEncodingException {
        if (encoded == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < encoded.length()) {
            Integer n3 = encoded.codePointAt(n2);
            String string = AlphabetConverter.codePointToString(n3);
            if (string.equals(this.originalToEncoded.get(n3))) {
                stringBuilder.append(string);
                ++n2;
                continue;
            }
            if (n2 + this.encodedLetterLength > encoded.length()) {
                throw new UnsupportedEncodingException("Unexpected end of string while decoding " + encoded);
            }
            int n4 = n2;
            String string2 = encoded.substring(n4, n4 + this.encodedLetterLength);
            String string3 = this.encodedToOriginal.get(string2);
            if (string3 == null) {
                throw new UnsupportedEncodingException("Unexpected string without decoding (" + string2 + ") in " + encoded);
            }
            stringBuilder.append(string3);
            n2 += this.encodedLetterLength;
        }
        return stringBuilder.toString();
    }

    public final int getEncodedCharLength() {
        return this.encodedLetterLength;
    }

    public final Map<Integer, String> getOriginalToEncoded() {
        return Collections.unmodifiableMap(this.originalToEncoded);
    }

    private void addSingleEncoding(int level, String currentEncoding, Collection<Integer> encoding, Iterator<Integer> originals, Map<Integer, String> doNotEncodeMap) {
        String string;
        if (level > 0) {
            for (int n2 : encoding) {
                if (originals.hasNext()) {
                    if (level == this.encodedLetterLength && doNotEncodeMap.containsKey(n2)) continue;
                    this.addSingleEncoding(level - 1, currentEncoding + AlphabetConverter.codePointToString(n2), encoding, originals, doNotEncodeMap);
                    continue;
                }
                return;
            }
            return;
        }
        Integer n3 = originals.next();
        while (doNotEncodeMap.containsKey(n3)) {
            string = AlphabetConverter.codePointToString(n3);
            this.originalToEncoded.put(n3, string);
            String string2 = string;
            this.encodedToOriginal.put(string2, string2);
            if (!originals.hasNext()) {
                return;
            }
            n3 = originals.next();
        }
        string = AlphabetConverter.codePointToString(n3);
        this.originalToEncoded.put(n3, currentEncoding);
        this.encodedToOriginal.put(currentEncoding, string);
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<Integer, String> entry : this.originalToEncoded.entrySet()) {
            stringBuilder.append(AlphabetConverter.codePointToString(entry.getKey())).append(ARROW).append(entry.getValue()).append(System.lineSeparator());
        }
        return stringBuilder.toString();
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AlphabetConverter)) {
            return false;
        }
        AlphabetConverter alphabetConverter = (AlphabetConverter)obj;
        return this.originalToEncoded.equals(alphabetConverter.originalToEncoded) && this.encodedToOriginal.equals(alphabetConverter.encodedToOriginal) && this.encodedLetterLength == alphabetConverter.encodedLetterLength;
    }

    public final int hashCode() {
        return Objects.hash(this.originalToEncoded, this.encodedToOriginal, this.encodedLetterLength);
    }

    public static AlphabetConverter createConverterFromMap(Map<Integer, String> originalToEncoded) {
        Map<Integer, String> map = Collections.unmodifiableMap(originalToEncoded);
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        int n2 = 1;
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            String string = AlphabetConverter.codePointToString(entry.getKey());
            linkedHashMap.put(entry.getValue(), string);
            if (entry.getValue().length() <= n2) continue;
            n2 = entry.getValue().length();
        }
        return new AlphabetConverter(map, linkedHashMap, n2);
    }

    public static AlphabetConverter createConverterFromChars(Character[] original, Character[] encoding, Character[] doNotEncode) {
        return AlphabetConverter.createConverter(AlphabetConverter.convertCharsToIntegers(original), AlphabetConverter.convertCharsToIntegers(encoding), AlphabetConverter.convertCharsToIntegers(doNotEncode));
    }

    private static Integer[] convertCharsToIntegers(Character[] chars) {
        if (chars == null || chars.length == 0) {
            return new Integer[0];
        }
        Integer[] integerArray = new Integer[chars.length];
        for (int i2 = 0; i2 < chars.length; ++i2) {
            integerArray[i2] = chars[i2].charValue();
        }
        return integerArray;
    }

    public static AlphabetConverter createConverter(Integer[] original, Integer[] encoding, Integer[] doNotEncode) {
        int n2;
        LinkedHashSet<Integer> linkedHashSet = new LinkedHashSet<Integer>(Arrays.asList(original));
        LinkedHashSet<Integer> linkedHashSet2 = new LinkedHashSet<Integer>(Arrays.asList(encoding));
        LinkedHashSet<Integer> linkedHashSet3 = new LinkedHashSet<Integer>(Arrays.asList(doNotEncode));
        LinkedHashMap<Integer, String> linkedHashMap = new LinkedHashMap<Integer, String>();
        LinkedHashMap<String, String> linkedHashMap2 = new LinkedHashMap<String, String>();
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        Iterator iterator = linkedHashSet3.iterator();
        while (iterator.hasNext()) {
            n2 = (Integer)iterator.next();
            if (!linkedHashSet.contains(n2)) {
                throw new IllegalArgumentException("Can not use 'do not encode' list because original alphabet does not contain '" + AlphabetConverter.codePointToString(n2) + "'");
            }
            if (!linkedHashSet2.contains(n2)) {
                throw new IllegalArgumentException("Can not use 'do not encode' list because encoding alphabet does not contain '" + AlphabetConverter.codePointToString(n2) + "'");
            }
            hashMap.put(n2, AlphabetConverter.codePointToString(n2));
        }
        if (linkedHashSet2.size() >= linkedHashSet.size()) {
            iterator = linkedHashSet2.iterator();
            Iterator iterator2 = linkedHashSet.iterator();
            while (iterator2.hasNext()) {
                Integer n3;
                int n4 = (Integer)iterator2.next();
                String string = AlphabetConverter.codePointToString(n4);
                if (hashMap.containsKey(n4)) {
                    linkedHashMap.put(n4, string);
                    String string2 = string;
                    linkedHashMap2.put(string2, string2);
                    continue;
                }
                while (linkedHashSet3.contains(n3 = (Integer)iterator.next())) {
                }
                String string3 = AlphabetConverter.codePointToString(n3);
                linkedHashMap.put(n4, string3);
                linkedHashMap2.put(string3, string);
            }
            return new AlphabetConverter(linkedHashMap, linkedHashMap2, 1);
        }
        if (linkedHashSet2.size() - linkedHashSet3.size() < 2) {
            throw new IllegalArgumentException("Must have at least two encoding characters (excluding those in the 'do not encode' list), but has " + (linkedHashSet2.size() - linkedHashSet3.size()));
        }
        int n5 = 1;
        n2 = (linkedHashSet.size() - linkedHashSet3.size()) / (linkedHashSet2.size() - linkedHashSet3.size());
        while (n2 / linkedHashSet2.size() > 0) {
            n2 /= linkedHashSet2.size();
            ++n5;
        }
        int n6 = n5 + 1;
        AlphabetConverter alphabetConverter = new AlphabetConverter(linkedHashMap, linkedHashMap2, n6);
        alphabetConverter.addSingleEncoding(n6, "", linkedHashSet2, linkedHashSet.iterator(), hashMap);
        return alphabetConverter;
    }

    private static String codePointToString(int i2) {
        if (Character.charCount(i2) == 1) {
            return String.valueOf((char)i2);
        }
        return new String(Character.toChars(i2));
    }
}

