/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class WordUtils {
    public static String wrap(String str, int wrapLength) {
        return WordUtils.wrap(str, wrapLength, null, false);
    }

    public static String wrap(String str, int wrapLength, String newLineStr, boolean wrapLongWords) {
        return WordUtils.wrap(str, wrapLength, newLineStr, wrapLongWords, " ");
    }

    public static String wrap(String str, int wrapLength, String newLineStr, boolean wrapLongWords, String wrapOn) {
        if (str == null) {
            return null;
        }
        if (newLineStr == null) {
            newLineStr = System.lineSeparator();
        }
        if (wrapLength <= 0) {
            wrapLength = 1;
        }
        if (StringUtils.isBlank(wrapOn)) {
            wrapOn = " ";
        }
        Pattern pattern = Pattern.compile(wrapOn);
        int n2 = str.length();
        int n3 = 0;
        StringBuilder stringBuilder = new StringBuilder(n2 + 32);
        while (n3 < n2) {
            int n4 = -1;
            int n5 = n3;
            Matcher matcher = pattern.matcher(str.substring(n5, Math.min(n5 + wrapLength + 1, n2)));
            if (matcher.find()) {
                if (matcher.start() == 0) {
                    n3 += matcher.end();
                    continue;
                }
                n4 = matcher.start() + n3;
            }
            if (n2 - n3 <= wrapLength) break;
            while (matcher.find()) {
                n4 = matcher.start() + n3;
            }
            if (n4 >= n3) {
                stringBuilder.append(str.substring(n3, n4));
                stringBuilder.append(newLineStr);
                n3 = n4 + 1;
                continue;
            }
            if (wrapLongWords) {
                stringBuilder.append(str.substring(n3, wrapLength + n3));
                stringBuilder.append(newLineStr);
                n3 += wrapLength;
                continue;
            }
            matcher = pattern.matcher(str.substring(n3 + wrapLength));
            if (matcher.find()) {
                n4 = matcher.start() + n3 + wrapLength;
            }
            if (n4 >= 0) {
                stringBuilder.append(str.substring(n3, n4));
                stringBuilder.append(newLineStr);
                n3 = n4 + 1;
                continue;
            }
            stringBuilder.append(str.substring(n3));
            n3 = n2;
        }
        stringBuilder.append(str.substring(n3));
        return stringBuilder.toString();
    }

    public static String capitalize(String str) {
        return WordUtils.capitalize(str, null);
    }

    public static String capitalize(String str, char ... delimiters) {
        int n2;
        int n3 = n2 = delimiters == null ? -1 : delimiters.length;
        if (StringUtils.isEmpty(str) || n2 == 0) {
            return str;
        }
        int n4 = str.length();
        int[] nArray = new int[n4];
        int n5 = 0;
        boolean bl = true;
        int n6 = 0;
        while (n6 < n4) {
            int n7 = str.codePointAt(n6);
            if (WordUtils.isDelimiter(n7, delimiters)) {
                bl = true;
            } else if (bl) {
                int n8 = Character.toTitleCase(n7);
                nArray[n5++] = n8;
                n6 += Character.charCount(n8);
                bl = false;
                continue;
            }
            nArray[n5++] = n7;
            n6 += Character.charCount(n7);
        }
        return new String(nArray, 0, n5);
    }

    public static String capitalizeFully(String str) {
        return WordUtils.capitalizeFully(str, null);
    }

    public static String capitalizeFully(String str, char ... delimiters) {
        int n2;
        int n3 = n2 = delimiters == null ? -1 : delimiters.length;
        if (StringUtils.isEmpty(str) || n2 == 0) {
            return str;
        }
        str = str.toLowerCase();
        return WordUtils.capitalize(str, delimiters);
    }

    public static String uncapitalize(String str) {
        return WordUtils.uncapitalize(str, null);
    }

    public static String uncapitalize(String str, char ... delimiters) {
        int n2;
        int n3 = n2 = delimiters == null ? -1 : delimiters.length;
        if (StringUtils.isEmpty(str) || n2 == 0) {
            return str;
        }
        int n4 = str.length();
        int[] nArray = new int[n4];
        int n5 = 0;
        boolean bl = true;
        int n6 = 0;
        while (n6 < n4) {
            int n7 = str.codePointAt(n6);
            if (WordUtils.isDelimiter(n7, delimiters)) {
                bl = true;
            } else if (bl) {
                int n8 = Character.toLowerCase(n7);
                nArray[n5++] = n8;
                n6 += Character.charCount(n8);
                bl = false;
                continue;
            }
            nArray[n5++] = n7;
            n6 += Character.charCount(n7);
        }
        return new String(nArray, 0, n5);
    }

    public static String swapCase(String str) {
        int n2;
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int n3 = str.length();
        int[] nArray = new int[n3];
        int n4 = 0;
        boolean bl = true;
        for (int i2 = 0; i2 < n3; i2 += Character.charCount(n2)) {
            int n5 = str.codePointAt(i2);
            if (Character.isUpperCase(n5)) {
                n2 = Character.toLowerCase(n5);
                bl = false;
            } else if (Character.isTitleCase(n5)) {
                n2 = Character.toLowerCase(n5);
                bl = false;
            } else if (Character.isLowerCase(n5)) {
                if (bl) {
                    n2 = Character.toTitleCase(n5);
                    bl = false;
                } else {
                    n2 = Character.toUpperCase(n5);
                }
            } else {
                bl = Character.isWhitespace(n5);
                n2 = n5;
            }
            nArray[n4++] = n2;
        }
        return new String(nArray, 0, n4);
    }

    public static String initials(String str) {
        return WordUtils.initials(str, null);
    }

    public static String initials(String str, char ... delimiters) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (delimiters != null && delimiters.length == 0) {
            return "";
        }
        int n2 = str.length();
        char[] cArray = new char[n2 / 2 + 1];
        int n3 = 0;
        boolean bl = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = str.charAt(i2);
            if (WordUtils.isDelimiter(c2, delimiters)) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            cArray[n3++] = c2;
            bl = false;
        }
        return new String(cArray, 0, n3);
    }

    public static boolean containsAllWords(CharSequence word, CharSequence ... words) {
        if (StringUtils.isEmpty(word) || ArrayUtils.isEmpty(words)) {
            return false;
        }
        CharSequence[] charSequenceArray = words;
        int n2 = words.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            CharSequence charSequence = charSequenceArray[i2];
            if (StringUtils.isBlank(charSequence)) {
                return false;
            }
            Pattern pattern = Pattern.compile(".*\\b" + charSequence + "\\b.*");
            if (pattern.matcher(word).matches()) continue;
            return false;
        }
        return true;
    }

    public static boolean isDelimiter(char ch, char[] delimiters) {
        if (delimiters == null) {
            return Character.isWhitespace(ch);
        }
        char[] cArray = delimiters;
        int n2 = delimiters.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cArray[i2];
            if (ch != c2) continue;
            return true;
        }
        return false;
    }

    public static boolean isDelimiter(int codePoint, char[] delimiters) {
        if (delimiters == null) {
            return Character.isWhitespace(codePoint);
        }
        for (int i2 = 0; i2 < delimiters.length; ++i2) {
            int n2 = Character.codePointAt(delimiters, i2);
            if (n2 != codePoint) continue;
            return true;
        }
        return false;
    }

    public static String abbreviate(String str, int lower, int upper, String appendToEnd) {
        Validate.isTrue(upper >= -1, "upper value cannot be less than -1", new Object[0]);
        Validate.isTrue(upper >= lower || upper == -1, "upper value is less than lower value", new Object[0]);
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (lower > str.length()) {
            lower = str.length();
        }
        if (upper == -1 || upper > str.length()) {
            upper = str.length();
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = StringUtils.indexOf((CharSequence)str, " ", lower);
        if (n2 == -1) {
            stringBuilder.append(str.substring(0, upper));
            if (upper != str.length()) {
                stringBuilder.append(StringUtils.defaultString(appendToEnd));
            }
        } else if (n2 > upper) {
            stringBuilder.append(str.substring(0, upper));
            stringBuilder.append(StringUtils.defaultString(appendToEnd));
        } else {
            stringBuilder.append(str.substring(0, n2));
            stringBuilder.append(StringUtils.defaultString(appendToEnd));
        }
        return stringBuilder.toString();
    }
}

