/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CosineSimilarity {
    public Double cosineSimilarity(Map<CharSequence, Integer> leftVector, Map<CharSequence, Integer> rightVector) {
        if (leftVector == null || rightVector == null) {
            throw new IllegalArgumentException("Vectors must not be null");
        }
        Set<CharSequence> set = this.getIntersection(leftVector, rightVector);
        double d2 = this.dot(leftVector, rightVector, set);
        double d3 = 0.0;
        for (Integer n2 : leftVector.values()) {
            d3 += Math.pow(n2.intValue(), 2.0);
        }
        double d4 = 0.0;
        for (Integer n3 : rightVector.values()) {
            d4 += Math.pow(n3.intValue(), 2.0);
        }
        double d5 = d3 <= 0.0 || d4 <= 0.0 ? 0.0 : d2 / (Math.sqrt(d3) * Math.sqrt(d4));
        return d5;
    }

    private Set<CharSequence> getIntersection(Map<CharSequence, Integer> leftVector, Map<CharSequence, Integer> rightVector) {
        HashSet<CharSequence> hashSet = new HashSet<CharSequence>(leftVector.keySet());
        hashSet.retainAll(rightVector.keySet());
        return hashSet;
    }

    private double dot(Map<CharSequence, Integer> leftVector, Map<CharSequence, Integer> rightVector, Set<CharSequence> intersection) {
        long l2 = 0L;
        for (CharSequence charSequence : intersection) {
            l2 += (long)(leftVector.get(charSequence) * rightVector.get(charSequence));
        }
        return l2;
    }
}

