/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.Locale;

public class FuzzyScore {
    private final Locale locale;

    public FuzzyScore(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("Locale must not be null");
        }
        this.locale = locale;
    }

    public Integer fuzzyScore(CharSequence term, CharSequence query) {
        if (term == null || query == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        String string = term.toString().toLowerCase(this.locale);
        String string2 = query.toString().toLowerCase(this.locale);
        int n2 = 0;
        int n3 = 0;
        int n4 = Integer.MIN_VALUE;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            char c2 = string2.charAt(i2);
            boolean bl = false;
            while (n3 < string.length() && !bl) {
                char c3 = string.charAt(n3);
                if (c2 == c3) {
                    ++n2;
                    if (n4 + 1 == n3) {
                        n2 += 2;
                    }
                    n4 = n3;
                    bl = true;
                }
                ++n3;
            }
        }
        return n2;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

