/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.SimilarityScore;

public class LongestCommonSubsequence
implements SimilarityScore<Integer> {
    @Override
    public Integer apply(CharSequence left, CharSequence right) {
        if (left == null || right == null) {
            throw new IllegalArgumentException("Inputs must not be null");
        }
        return this.logestCommonSubsequence(left, right).length();
    }

    public CharSequence logestCommonSubsequence(CharSequence left, CharSequence right) {
        if (left == null || right == null) {
            throw new IllegalArgumentException("Inputs must not be null");
        }
        StringBuilder stringBuilder = new StringBuilder(Math.max(left.length(), right.length()));
        int[][] nArray = this.longestCommonSubstringLengthArray(left, right);
        int n2 = left.length() - 1;
        int n3 = right.length() - 1;
        int n4 = nArray[left.length()][right.length()] - 1;
        while (n4 >= 0) {
            if (left.charAt(n2) == right.charAt(n3)) {
                stringBuilder.append(left.charAt(n2));
                --n2;
                --n3;
                --n4;
                continue;
            }
            if (nArray[n2 + 1][n3] < nArray[n2][n3 + 1]) {
                --n2;
                continue;
            }
            --n3;
        }
        return stringBuilder.reverse().toString();
    }

    public int[][] longestCommonSubstringLengthArray(CharSequence left, CharSequence right) {
        int[][] nArray = new int[left.length() + 1][right.length() + 1];
        for (int i2 = 0; i2 < left.length(); ++i2) {
            for (int i3 = 0; i3 < right.length(); ++i3) {
                if (i2 == 0) {
                    nArray[i2][i3] = 0;
                }
                if (i3 == 0) {
                    nArray[i2][i3] = 0;
                }
                nArray[i2 + 1][i3 + 1] = left.charAt(i2) == right.charAt(i3) ? nArray[i2][i3] + 1 : Math.max(nArray[i2 + 1][i3], nArray[i2][i3 + 1]);
            }
        }
        return nArray;
    }
}

