/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.translate;

import java.io.IOException;
import java.io.Writer;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.text.translate.CharSequenceTranslator;

public class LookupTranslator
extends CharSequenceTranslator {
    private final Map<String, String> lookupMap;
    private final HashSet<Character> prefixSet;
    private final int shortest;
    private final int longest;

    public LookupTranslator(Map<CharSequence, CharSequence> lookupMap) {
        if (lookupMap == null) {
            throw new InvalidParameterException("lookupMap cannot be null");
        }
        this.lookupMap = new HashMap<String, String>();
        this.prefixSet = new HashSet();
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        for (Map.Entry<CharSequence, CharSequence> entry : lookupMap.entrySet()) {
            this.lookupMap.put(entry.getKey().toString(), entry.getValue().toString());
            this.prefixSet.add(Character.valueOf(entry.getKey().charAt(0)));
            int n4 = entry.getKey().length();
            if (n4 < n2) {
                n2 = n4;
            }
            if (n4 <= n3) continue;
            n3 = n4;
        }
        this.shortest = n2;
        this.longest = n3;
    }

    @Override
    public int translate(CharSequence input, int index, Writer out) throws IOException {
        if (this.prefixSet.contains(Character.valueOf(input.charAt(index)))) {
            int n2 = this.longest;
            if (index + this.longest > input.length()) {
                n2 = input.length() - index;
            }
            for (int i2 = n2; i2 >= this.shortest; --i2) {
                int n3 = index;
                CharSequence charSequence = input.subSequence(n3, n3 + i2);
                String string = this.lookupMap.get(charSequence.toString());
                if (string == null) continue;
                out.write(string);
                return i2;
            }
        }
        return 0;
    }
}

