/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.nio.ByteBuffer;
import org.capnproto.FromPointerReader;
import org.capnproto.FromPointerReaderBlobDefault;
import org.capnproto.FromPointerReaderRefDefault;
import org.capnproto.SegmentReader;

public class StructReader {
    protected final SegmentReader segment;
    protected final int data;
    protected final int pointers;
    protected final int dataSize;
    protected final short pointerCount;
    protected final int nestingLimit;

    public StructReader() {
        this.segment = SegmentReader.EMPTY;
        this.data = 0;
        this.pointers = 0;
        this.dataSize = 0;
        this.pointerCount = 0;
        this.nestingLimit = Integer.MAX_VALUE;
    }

    public StructReader(SegmentReader segmentReader, int n2, int n3, int n4, short s2, int n5) {
        this.segment = segmentReader;
        this.data = n2;
        this.pointers = n3;
        this.dataSize = n4;
        this.pointerCount = s2;
        this.nestingLimit = n5;
    }

    protected final boolean _getBooleanField(int n2) {
        if (n2 < this.dataSize) {
            byte by = this.segment.buffer.get(this.data + n2 / 8);
            return (by & 1 << n2 % 8) != 0;
        }
        return false;
    }

    protected final boolean _getBooleanField(int n2, boolean bl) {
        return this._getBooleanField(n2) ^ bl;
    }

    protected final byte _getByteField(int n2) {
        if (n2 + 1 << 3 <= this.dataSize) {
            return this.segment.buffer.get(this.data + n2);
        }
        return 0;
    }

    protected final byte _getByteField(int n2, byte by) {
        return (byte)(this._getByteField(n2) ^ by);
    }

    protected final short _getShortField(int n2) {
        if (n2 + 1 << 4 <= this.dataSize) {
            return this.segment.buffer.getShort(this.data + (n2 << 1));
        }
        return 0;
    }

    protected final short _getShortField(int n2, short s2) {
        return (short)(this._getShortField(n2) ^ s2);
    }

    protected final int _getIntField(int n2) {
        if (n2 + 1 << 5 <= this.dataSize) {
            return this.segment.buffer.getInt(this.data + (n2 << 2));
        }
        return 0;
    }

    protected final int _getIntField(int n2, int n3) {
        return this._getIntField(n2) ^ n3;
    }

    protected final long _getLongField(int n2) {
        if (n2 + 1 << 6 <= this.dataSize) {
            return this.segment.buffer.getLong(this.data + (n2 << 3));
        }
        return 0L;
    }

    protected final long _getLongField(int n2, long l2) {
        return this._getLongField(n2) ^ l2;
    }

    protected final float _getFloatField(int n2) {
        if (n2 + 1 << 5 <= this.dataSize) {
            return this.segment.buffer.getFloat(this.data + (n2 << 2));
        }
        return 0.0f;
    }

    protected final float _getFloatField(int n2, int n3) {
        if (n2 + 1 << 5 <= this.dataSize) {
            return Float.intBitsToFloat(this.segment.buffer.getInt(this.data + (n2 << 2)) ^ n3);
        }
        return Float.intBitsToFloat(n3);
    }

    protected final double _getDoubleField(int n2) {
        if (n2 + 1 << 6 <= this.dataSize) {
            return this.segment.buffer.getDouble(this.data + (n2 << 3));
        }
        return 0.0;
    }

    protected final double _getDoubleField(int n2, long l2) {
        if (n2 + 1 << 6 <= this.dataSize) {
            return Double.longBitsToDouble(this.segment.buffer.getLong(this.data + (n2 << 3)) ^ l2);
        }
        return Double.longBitsToDouble(l2);
    }

    protected final boolean _pointerFieldIsNull(int n2) {
        return n2 >= this.pointerCount || this.segment.buffer.getLong(this.pointers + n2 << 3) == 0L;
    }

    protected final <T> T _getPointerField(FromPointerReader<T> fromPointerReader, int n2) {
        if (n2 < this.pointerCount) {
            return fromPointerReader.fromPointerReader(this.segment, this.pointers + n2, this.nestingLimit);
        }
        return fromPointerReader.fromPointerReader(SegmentReader.EMPTY, 0, this.nestingLimit);
    }

    protected final <T> T _getPointerField(FromPointerReaderRefDefault<T> fromPointerReaderRefDefault, int n2, SegmentReader segmentReader, int n3) {
        if (n2 < this.pointerCount) {
            return fromPointerReaderRefDefault.fromPointerReaderRefDefault(this.segment, this.pointers + n2, segmentReader, n3, this.nestingLimit);
        }
        return fromPointerReaderRefDefault.fromPointerReaderRefDefault(SegmentReader.EMPTY, 0, segmentReader, n3, this.nestingLimit);
    }

    protected final <T> T _getPointerField(FromPointerReaderBlobDefault<T> fromPointerReaderBlobDefault, int n2, ByteBuffer byteBuffer, int n3, int n4) {
        if (n2 < this.pointerCount) {
            return fromPointerReaderBlobDefault.fromPointerReaderBlobDefault(this.segment, this.pointers + n2, byteBuffer, n3, n4);
        }
        return fromPointerReaderBlobDefault.fromPointerReaderBlobDefault(SegmentReader.EMPTY, 0, byteBuffer, n3, n4);
    }

    public static interface Factory<T> {
        public T constructReader(SegmentReader var1, int var2, int var3, int var4, short var5, int var6);
    }
}

