/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.field.DecoratedDurationField;
import org.joda.time.field.FieldUtils;

public class ScaledDurationField
extends DecoratedDurationField {
    private static final long serialVersionUID = -3205227092378684157L;
    private final int iScalar;

    public ScaledDurationField(DurationField durationField, DurationFieldType durationFieldType, int n2) {
        super(durationField, durationFieldType);
        if (n2 == 0 || n2 == 1) {
            throw new IllegalArgumentException("The scalar must not be 0 or 1");
        }
        this.iScalar = n2;
    }

    public int getValue(long l2) {
        return this.getWrappedField().getValue(l2) / this.iScalar;
    }

    public long getValueAsLong(long l2) {
        return this.getWrappedField().getValueAsLong(l2) / (long)this.iScalar;
    }

    public int getValue(long l2, long l3) {
        return this.getWrappedField().getValue(l2, l3) / this.iScalar;
    }

    public long getValueAsLong(long l2, long l3) {
        return this.getWrappedField().getValueAsLong(l2, l3) / (long)this.iScalar;
    }

    public long getMillis(int n2) {
        long l2 = (long)n2 * (long)this.iScalar;
        return this.getWrappedField().getMillis(l2);
    }

    public long getMillis(long l2) {
        long l3 = FieldUtils.safeMultiply(l2, this.iScalar);
        return this.getWrappedField().getMillis(l3);
    }

    public long getMillis(int n2, long l2) {
        long l3 = (long)n2 * (long)this.iScalar;
        return this.getWrappedField().getMillis(l3, l2);
    }

    public long getMillis(long l2, long l3) {
        long l4 = FieldUtils.safeMultiply(l2, this.iScalar);
        return this.getWrappedField().getMillis(l4, l3);
    }

    public long add(long l2, int n2) {
        long l3 = (long)n2 * (long)this.iScalar;
        return this.getWrappedField().add(l2, l3);
    }

    public long add(long l2, long l3) {
        long l4 = FieldUtils.safeMultiply(l3, this.iScalar);
        return this.getWrappedField().add(l2, l4);
    }

    public int getDifference(long l2, long l3) {
        return this.getWrappedField().getDifference(l2, l3) / this.iScalar;
    }

    public long getDifferenceAsLong(long l2, long l3) {
        return this.getWrappedField().getDifferenceAsLong(l2, l3) / (long)this.iScalar;
    }

    public long getUnitMillis() {
        return this.getWrappedField().getUnitMillis() * (long)this.iScalar;
    }

    public int getScalar() {
        return this.iScalar;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ScaledDurationField) {
            ScaledDurationField scaledDurationField = (ScaledDurationField)object;
            return this.getWrappedField().equals(scaledDurationField.getWrappedField()) && this.getType() == scaledDurationField.getType() && this.iScalar == scaledDurationField.iScalar;
        }
        return false;
    }

    public int hashCode() {
        long l2 = this.iScalar;
        int n2 = (int)(l2 ^ l2 >>> 32);
        n2 += this.getType().hashCode();
        return n2 += this.getWrappedField().hashCode();
    }
}

