/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.util.Iterator;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.TensorFlow;

public final class Graph
implements AutoCloseable {
    private final Object nativeHandleLock = new Object();
    private long nativeHandle;
    private int refcount = 0;

    public Graph() {
        this.nativeHandle = Graph.allocate();
    }

    Graph(long nativeHandle) {
        this.nativeHandle = nativeHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        Object object = this.nativeHandleLock;
        synchronized (object) {
            if (this.nativeHandle == 0L) {
                return;
            }
            while (this.refcount > 0) {
                try {
                    this.nativeHandleLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            Graph.delete(this.nativeHandle);
            this.nativeHandle = 0L;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Operation operation(String name) {
        Object object = this.nativeHandleLock;
        synchronized (object) {
            long l2 = Graph.operation(this.nativeHandle, name);
            if (l2 == 0L) {
                return null;
            }
            return new Operation(this, l2);
        }
    }

    public final Iterator<Operation> operations() {
        return new OperationIterator(this);
    }

    public final OperationBuilder opBuilder(String type, String name) {
        return new OperationBuilder(this, type, name);
    }

    public final void importGraphDef(byte[] graphDef) throws IllegalArgumentException {
        this.importGraphDef(graphDef, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void importGraphDef(byte[] graphDef, String prefix) throws IllegalArgumentException {
        if (graphDef == null || prefix == null) {
            throw new IllegalArgumentException("graphDef and prefix cannot be null");
        }
        Object object = this.nativeHandleLock;
        synchronized (object) {
            Graph.importGraphDef(this.nativeHandle, graphDef, prefix);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] toGraphDef() {
        Object object = this.nativeHandleLock;
        synchronized (object) {
            return Graph.toGraphDef(this.nativeHandle);
        }
    }

    public final Output<?>[] addGradients(String prefix, Output<?>[] y2, Output<?>[] x2, Output<?>[] dx) {
        Output[] outputArray = new Output[x2.length];
        long[] lArray = new long[y2.length];
        int[] nArray = new int[y2.length];
        long[] lArray2 = new long[x2.length];
        int[] nArray2 = new int[x2.length];
        long[] lArray3 = null;
        int[] nArray3 = null;
        Reference reference = this.ref();
        Throwable throwable = null;
        try {
            long[] lArray4;
            int n2;
            int n3;
            for (n3 = 0; n3 < y2.length; ++n3) {
                lArray[n3] = y2[n3].op().getUnsafeNativeHandle();
                nArray[n3] = y2[n3].index();
            }
            for (n3 = 0; n3 < x2.length; ++n3) {
                lArray2[n3] = x2[n3].op().getUnsafeNativeHandle();
                nArray2[n3] = x2[n3].index();
            }
            if (dx != null && dx.length > 0) {
                lArray3 = new long[dx.length];
                nArray3 = new int[dx.length];
                for (n3 = 0; n3 < dx.length; ++n3) {
                    lArray3[n3] = dx[n3].op().getUnsafeNativeHandle();
                    nArray3[n3] = dx[n3].index();
                }
            }
            if ((n2 = (lArray4 = Graph.addGradients(reference.nativeHandle(), prefix, lArray, nArray, lArray2, nArray2, lArray3, nArray3)).length >> 1) != outputArray.length) {
                throw new IllegalStateException(String.valueOf(n2) + " gradients were added to the graph when " + outputArray.length + " were expected");
            }
            int n4 = 0;
            int n5 = n2;
            while (n4 < n2) {
                Operation operation = new Operation(this, lArray4[n4]);
                outputArray[n4] = new Output(operation, (int)lArray4[n5]);
                ++n4;
                ++n5;
            }
            if (reference != null) {
                reference.close();
            }
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (reference != null) {
                    if (throwable != null) {
                        try {
                            reference.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        reference.close();
                    }
                }
                throw throwable4;
            }
        }
        return outputArray;
    }

    public final Output<?>[] addGradients(Output<?> y2, Output<?>[] x2) {
        return this.addGradients(null, new Output[]{y2}, x2, null);
    }

    final Reference ref() {
        return new Reference();
    }

    private static native long allocate();

    private static native void delete(long var0);

    private static native long operation(long var0, String var2);

    private static native long[] nextOperation(long var0, int var2);

    private static native void importGraphDef(long var0, byte[] var2, String var3) throws IllegalArgumentException;

    private static native byte[] toGraphDef(long var0);

    private static native long[] addGradients(long var0, String var2, long[] var3, int[] var4, long[] var5, int[] var6, long[] var7, int[] var8);

    static {
        TensorFlow.init();
    }

    private static final class OperationIterator
    implements Iterator<Operation> {
        private final Graph graph;
        private Operation operation;
        private int position;

        OperationIterator(Graph g2) {
            this.graph = g2;
            this.operation = null;
            this.position = 0;
            this.advance();
        }

        private final void advance() {
            this.operation = null;
            try (Reference reference = this.graph.ref();){
                long[] lArray = Graph.nextOperation(reference.nativeHandle(), this.position);
                if (lArray != null && lArray[0] != 0L) {
                    this.operation = new Operation(this.graph, lArray[0]);
                    this.position = (int)lArray[1];
                }
                return;
            }
        }

        @Override
        public final boolean hasNext() {
            return this.operation != null;
        }

        @Override
        public final Operation next() {
            Operation operation = this.operation;
            this.advance();
            return operation;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("remove() is unsupported.");
        }
    }

    class Reference
    implements AutoCloseable {
        private boolean active;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Reference() {
            Object object = Graph.this.nativeHandleLock;
            synchronized (object) {
                boolean bl = this.active = Graph.this.nativeHandle != 0L;
                if (!this.active) {
                    throw new IllegalStateException("close() has been called on the Graph");
                }
                this.active = true;
                Graph.this.refcount++;
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = Graph.this.nativeHandleLock;
            synchronized (object) {
                if (!this.active) {
                    return;
                }
                this.active = false;
                if (--Graph.this.refcount == 0) {
                    Graph.this.nativeHandleLock.notifyAll();
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long nativeHandle() {
            Object object = Graph.this.nativeHandleLock;
            synchronized (object) {
                return this.active ? Graph.this.nativeHandle : 0L;
            }
        }
    }
}

