/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.util.Objects;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.Shape;

public final class Output<T>
implements Operand<T> {
    private final Operation operation;
    private final int index;

    public Output(Operation op, int idx) {
        this.operation = op;
        this.index = idx;
    }

    public final Operation op() {
        return this.operation;
    }

    public final int index() {
        return this.index;
    }

    public final Shape shape() {
        return new Shape(this.operation.shape(this.index));
    }

    public final DataType dataType() {
        return this.operation.dtype(this.index);
    }

    @Override
    public final Output<T> asOutput() {
        return this;
    }

    public final int hashCode() {
        return Objects.hash(this.operation, this.index);
    }

    public final boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (o2 instanceof Output) {
            Output output = (Output)o2;
            return this.index == output.index && this.operation.equals(output.operation);
        }
        return false;
    }

    public final String toString() {
        return String.format("<%s '%s:%d' shape=%s dtype=%s>", new Object[]{this.operation.type(), this.operation.name(), this.index, this.shape().toString(), this.dataType()});
    }
}

