/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class AudioSummary
extends PrimitiveOp
implements Operand<String> {
    private Output<String> summary;

    public static AudioSummary create(Scope scope, Operand<String> tag, Operand<Float> tensor, Operand<Float> sampleRate, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("AudioSummaryV2", scope.makeOpName("AudioSummary"));
        operationBuilder.addInput(tag.asOutput());
        operationBuilder.addInput(tensor.asOutput());
        operationBuilder.addInput(sampleRate.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.maxOutputs == null) continue;
                operationBuilder.setAttr("max_outputs", options2.maxOutputs);
            }
        }
        return new AudioSummary(operationBuilder.build());
    }

    public static Options maxOutputs(Long maxOutputs) {
        return new Options().maxOutputs(maxOutputs);
    }

    public final Output<String> summary() {
        return this.summary;
    }

    @Override
    public final Output<String> asOutput() {
        return this.summary;
    }

    private AudioSummary(Operation operation) {
        super(operation);
        this.summary = operation.output(0);
    }

    public static class Options {
        private Long maxOutputs;

        public Options maxOutputs(Long maxOutputs) {
            this.maxOutputs = maxOutputs;
            return this;
        }

        private Options() {
        }
    }
}

