/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class BatchSvd<T>
extends PrimitiveOp {
    private Output<T> s;
    private Output<T> u;
    private Output<T> v;

    public static <T> BatchSvd<T> create(Scope scope, Operand<T> input, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("BatchSvd", scope.makeOpName("BatchSvd"));
        operationBuilder.addInput(input.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.computeUv != null) {
                    operationBuilder.setAttr("compute_uv", options2.computeUv);
                }
                if (options2.fullMatrices == null) continue;
                operationBuilder.setAttr("full_matrices", options2.fullMatrices);
            }
        }
        return new BatchSvd<T>(operationBuilder.build());
    }

    public static Options computeUv(Boolean computeUv) {
        return new Options().computeUv(computeUv);
    }

    public static Options fullMatrices(Boolean fullMatrices) {
        return new Options().fullMatrices(fullMatrices);
    }

    public final Output<T> s() {
        return this.s;
    }

    public final Output<T> u() {
        return this.u;
    }

    public final Output<T> v() {
        return this.v;
    }

    private BatchSvd(Operation operation) {
        super(operation);
        this.s = operation.output(0);
        this.u = operation.output(1);
        this.v = operation.output(2);
    }

    public static class Options {
        private Boolean computeUv;
        private Boolean fullMatrices;

        public Options computeUv(Boolean computeUv) {
            this.computeUv = computeUv;
            return this;
        }

        public Options fullMatrices(Boolean fullMatrices) {
            this.fullMatrices = fullMatrices;
            return this;
        }

        private Options() {
        }
    }
}

