/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class BigQueryReader
extends PrimitiveOp
implements Operand<String> {
    private Output<String> readerHandle;

    public static BigQueryReader create(Scope scope, String projectId, String datasetId, String tableId, List<String> columns, Long timestampMillis, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("BigQueryReader", scope.makeOpName("BigQueryReader"));
        operationBuilder.setAttr("project_id", projectId);
        operationBuilder.setAttr("dataset_id", datasetId);
        operationBuilder.setAttr("table_id", tableId);
        String[] stringArray = new String[columns.size()];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = columns.get(i2);
        }
        operationBuilder.setAttr("columns", stringArray);
        operationBuilder.setAttr("timestamp_millis", timestampMillis);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                Options options2 = optionsArray[i3];
                if (options2.container != null) {
                    operationBuilder.setAttr("container", options2.container);
                }
                if (options2.sharedName != null) {
                    operationBuilder.setAttr("shared_name", options2.sharedName);
                }
                if (options2.testEndPoint == null) continue;
                operationBuilder.setAttr("test_end_point", options2.testEndPoint);
            }
        }
        return new BigQueryReader(operationBuilder.build());
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public static Options testEndPoint(String testEndPoint) {
        return new Options().testEndPoint(testEndPoint);
    }

    public final Output<String> readerHandle() {
        return this.readerHandle;
    }

    @Override
    public final Output<String> asOutput() {
        return this.readerHandle;
    }

    private BigQueryReader(Operation operation) {
        super(operation);
        this.readerHandle = operation.output(0);
    }

    public static class Options {
        private String container;
        private String sharedName;
        private String testEndPoint;

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        public Options testEndPoint(String testEndPoint) {
            this.testEndPoint = testEndPoint;
            return this;
        }

        private Options() {
        }
    }
}

