/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class CTCBeamSearchDecoder
extends PrimitiveOp {
    private List<Output<Long>> decodedIndices;
    private List<Output<Long>> decodedValues;
    private List<Output<Long>> decodedShape;
    private Output<Float> logProbability;

    public static CTCBeamSearchDecoder create(Scope scope, Operand<Float> inputs, Operand<Integer> sequenceLength, Long beamWidth, Long topPaths, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("CTCBeamSearchDecoder", scope.makeOpName("CTCBeamSearchDecoder"));
        operationBuilder.addInput(inputs.asOutput());
        operationBuilder.addInput(sequenceLength.asOutput());
        operationBuilder.setAttr("beam_width", beamWidth);
        operationBuilder.setAttr("top_paths", topPaths);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.mergeRepeated == null) continue;
                operationBuilder.setAttr("merge_repeated", options2.mergeRepeated);
            }
        }
        return new CTCBeamSearchDecoder(operationBuilder.build());
    }

    public static Options mergeRepeated(Boolean mergeRepeated) {
        return new Options().mergeRepeated(mergeRepeated);
    }

    public final List<Output<Long>> decodedIndices() {
        return this.decodedIndices;
    }

    public final List<Output<Long>> decodedValues() {
        return this.decodedValues;
    }

    public final List<Output<Long>> decodedShape() {
        return this.decodedShape;
    }

    public final Output<Float> logProbability() {
        return this.logProbability;
    }

    private CTCBeamSearchDecoder(Operation operation) {
        super(operation);
        int n2 = operation.outputListLength("decoded_indices");
        this.decodedIndices = Arrays.asList(operation.outputList(0, n2));
        int n3 = n2 + 0;
        int n4 = operation.outputListLength("decoded_values");
        this.decodedValues = Arrays.asList(operation.outputList(n3, n4));
        int n5 = operation.outputListLength("decoded_shape");
        this.decodedShape = Arrays.asList(operation.outputList(n3 += n4, n5));
        this.logProbability = operation.output(n3 += n5);
    }

    public static class Options {
        private Boolean mergeRepeated;

        public Options mergeRepeated(Boolean mergeRepeated) {
            this.mergeRepeated = mergeRepeated;
            return this;
        }

        private Options() {
        }
    }
}

