/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class CollectiveReduce<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> data;

    public static <T extends Number> CollectiveReduce<T> create(Scope scope, Operand<T> input, Long groupSize, Long groupKey, Long instanceKey, String mergeOp, String finalOp, List<Long> subdivOffsets) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("CollectiveReduce", scope.makeOpName("CollectiveReduce"));
        operationBuilder.addInput(input.asOutput());
        operationBuilder.setAttr("group_size", groupSize);
        operationBuilder.setAttr("group_key", groupKey);
        operationBuilder.setAttr("instance_key", instanceKey);
        operationBuilder.setAttr("merge_op", mergeOp);
        operationBuilder.setAttr("final_op", finalOp);
        long[] lArray = new long[subdivOffsets.size()];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            lArray[i2] = subdivOffsets.get(i2);
        }
        operationBuilder.setAttr("subdiv_offsets", lArray);
        return new CollectiveReduce<T>(operationBuilder.build());
    }

    public final Output<T> data() {
        return this.data;
    }

    @Override
    public final Output<T> asOutput() {
        return this.data;
    }

    private CollectiveReduce(Operation operation) {
        super(operation);
        this.data = operation.output(0);
    }
}

