/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ComputeAccidentalHits
extends PrimitiveOp {
    private Output<Integer> indices;
    private Output<Long> ids;
    private Output<Float> weights;

    public static ComputeAccidentalHits create(Scope scope, Operand<Long> trueClasses, Operand<Long> sampledCandidates, Long numTrue, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("ComputeAccidentalHits", scope.makeOpName("ComputeAccidentalHits"));
        operationBuilder.addInput(trueClasses.asOutput());
        operationBuilder.addInput(sampledCandidates.asOutput());
        operationBuilder.setAttr("num_true", numTrue);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.seed != null) {
                    operationBuilder.setAttr("seed", options2.seed);
                }
                if (options2.seed2 == null) continue;
                operationBuilder.setAttr("seed2", options2.seed2);
            }
        }
        return new ComputeAccidentalHits(operationBuilder.build());
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public final Output<Integer> indices() {
        return this.indices;
    }

    public final Output<Long> ids() {
        return this.ids;
    }

    public final Output<Float> weights() {
        return this.weights;
    }

    private ComputeAccidentalHits(Operation operation) {
        super(operation);
        this.indices = operation.output(0);
        this.ids = operation.output(1);
        this.weights = operation.output(2);
    }

    public static class Options {
        private Long seed;
        private Long seed2;

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }

        private Options() {
        }
    }
}

