/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class CudnnRNNBackpropV2<T extends Number>
extends PrimitiveOp {
    private Output<T> inputBackprop;
    private Output<T> inputHBackprop;
    private Output<T> inputCBackprop;
    private Output<T> paramsBackprop;

    public static <T extends Number> CudnnRNNBackpropV2<T> create(Scope scope, Operand<T> input, Operand<T> inputH, Operand<T> inputC, Operand<T> params, Operand<T> output, Operand<T> outputH, Operand<T> outputC, Operand<T> outputBackprop, Operand<T> outputHBackprop, Operand<T> outputCBackprop, Operand<T> reserveSpace, Operand<?> hostReserved, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("CudnnRNNBackpropV2", scope.makeOpName("CudnnRNNBackpropV2"));
        operationBuilder.addInput(input.asOutput());
        operationBuilder.addInput(inputH.asOutput());
        operationBuilder.addInput(inputC.asOutput());
        operationBuilder.addInput(params.asOutput());
        operationBuilder.addInput(output.asOutput());
        operationBuilder.addInput(outputH.asOutput());
        operationBuilder.addInput(outputC.asOutput());
        operationBuilder.addInput(outputBackprop.asOutput());
        operationBuilder.addInput(outputHBackprop.asOutput());
        operationBuilder.addInput(outputCBackprop.asOutput());
        operationBuilder.addInput(reserveSpace.asOutput());
        operationBuilder.addInput(hostReserved.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.rnnMode != null) {
                    operationBuilder.setAttr("rnn_mode", options2.rnnMode);
                }
                if (options2.inputMode != null) {
                    operationBuilder.setAttr("input_mode", options2.inputMode);
                }
                if (options2.direction != null) {
                    operationBuilder.setAttr("direction", options2.direction);
                }
                if (options2.dropout != null) {
                    operationBuilder.setAttr("dropout", options2.dropout.floatValue());
                }
                if (options2.seed != null) {
                    operationBuilder.setAttr("seed", options2.seed);
                }
                if (options2.seed2 == null) continue;
                operationBuilder.setAttr("seed2", options2.seed2);
            }
        }
        return new CudnnRNNBackpropV2<T>(operationBuilder.build());
    }

    public static Options rnnMode(String rnnMode) {
        return new Options().rnnMode(rnnMode);
    }

    public static Options inputMode(String inputMode) {
        return new Options().inputMode(inputMode);
    }

    public static Options direction(String direction) {
        return new Options().direction(direction);
    }

    public static Options dropout(Float dropout) {
        return new Options().dropout(dropout);
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public final Output<T> inputBackprop() {
        return this.inputBackprop;
    }

    public final Output<T> inputHBackprop() {
        return this.inputHBackprop;
    }

    public final Output<T> inputCBackprop() {
        return this.inputCBackprop;
    }

    public final Output<T> paramsBackprop() {
        return this.paramsBackprop;
    }

    private CudnnRNNBackpropV2(Operation operation) {
        super(operation);
        this.inputBackprop = operation.output(0);
        this.inputHBackprop = operation.output(1);
        this.inputCBackprop = operation.output(2);
        this.paramsBackprop = operation.output(3);
    }

    public static class Options {
        private String rnnMode;
        private String inputMode;
        private String direction;
        private Float dropout;
        private Long seed;
        private Long seed2;

        public Options rnnMode(String rnnMode) {
            this.rnnMode = rnnMode;
            return this;
        }

        public Options inputMode(String inputMode) {
            this.inputMode = inputMode;
            return this;
        }

        public Options direction(String direction) {
            this.direction = direction;
            return this;
        }

        public Options dropout(Float dropout) {
            this.dropout = dropout;
            return this;
        }

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }

        private Options() {
        }
    }
}

