/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class DecodeWav
extends PrimitiveOp {
    private Output<Float> audio;
    private Output<Integer> sampleRate;

    public static DecodeWav create(Scope scope, Operand<String> contents, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("DecodeWav", scope.makeOpName("DecodeWav"));
        operationBuilder.addInput(contents.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.desiredChannels != null) {
                    operationBuilder.setAttr("desired_channels", options2.desiredChannels);
                }
                if (options2.desiredSamples == null) continue;
                operationBuilder.setAttr("desired_samples", options2.desiredSamples);
            }
        }
        return new DecodeWav(operationBuilder.build());
    }

    public static Options desiredChannels(Long desiredChannels) {
        return new Options().desiredChannels(desiredChannels);
    }

    public static Options desiredSamples(Long desiredSamples) {
        return new Options().desiredSamples(desiredSamples);
    }

    public final Output<Float> audio() {
        return this.audio;
    }

    public final Output<Integer> sampleRate() {
        return this.sampleRate;
    }

    private DecodeWav(Operation operation) {
        super(operation);
        this.audio = operation.output(0);
        this.sampleRate = operation.output(1);
    }

    public static class Options {
        private Long desiredChannels;
        private Long desiredSamples;

        public Options desiredChannels(Long desiredChannels) {
            this.desiredChannels = desiredChannels;
            return this;
        }

        public Options desiredSamples(Long desiredSamples) {
            this.desiredSamples = desiredSamples;
            return this;
        }

        private Options() {
        }
    }
}

