/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class DenseToSparseSetOperation<T>
extends PrimitiveOp {
    private Output<Long> resultIndices;
    private Output<T> resultValues;
    private Output<Long> resultShape;

    public static <T> DenseToSparseSetOperation<T> create(Scope scope, Operand<T> set1, Operand<Long> set2Indices, Operand<T> set2Values, Operand<Long> set2Shape, String setOperation, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("DenseToSparseSetOperation", scope.makeOpName("DenseToSparseSetOperation"));
        operationBuilder.addInput(set1.asOutput());
        operationBuilder.addInput(set2Indices.asOutput());
        operationBuilder.addInput(set2Values.asOutput());
        operationBuilder.addInput(set2Shape.asOutput());
        operationBuilder.setAttr("set_operation", setOperation);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.validateIndices == null) continue;
                operationBuilder.setAttr("validate_indices", options2.validateIndices);
            }
        }
        return new DenseToSparseSetOperation<T>(operationBuilder.build());
    }

    public static Options validateIndices(Boolean validateIndices) {
        return new Options().validateIndices(validateIndices);
    }

    public final Output<Long> resultIndices() {
        return this.resultIndices;
    }

    public final Output<T> resultValues() {
        return this.resultValues;
    }

    public final Output<Long> resultShape() {
        return this.resultShape;
    }

    private DenseToSparseSetOperation(Operation operation) {
        super(operation);
        this.resultIndices = operation.output(0);
        this.resultValues = operation.output(1);
        this.resultShape = operation.output(2);
    }

    public static class Options {
        private Boolean validateIndices;

        public Options validateIndices(Boolean validateIndices) {
            this.validateIndices = validateIndices;
            return this;
        }

        private Options() {
        }
    }
}

