/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class DeserializeSparse<U>
extends PrimitiveOp {
    private Output<Long> sparseIndices;
    private Output<U> sparseValues;
    private Output<Long> sparseShape;

    public static <U, T> DeserializeSparse<U> create(Scope scope, Operand<T> serializedSparse, Class<U> dtype) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("DeserializeSparse", scope.makeOpName("DeserializeSparse"));
        operationBuilder.addInput(serializedSparse.asOutput());
        operationBuilder.setAttr("dtype", DataType.fromClass(dtype));
        return new DeserializeSparse<U>(operationBuilder.build());
    }

    public final Output<Long> sparseIndices() {
        return this.sparseIndices;
    }

    public final Output<U> sparseValues() {
        return this.sparseValues;
    }

    public final Output<Long> sparseShape() {
        return this.sparseShape;
    }

    private DeserializeSparse(Operation operation) {
        super(operation);
        this.sparseIndices = operation.output(0);
        this.sparseValues = operation.output(1);
        this.sparseShape = operation.output(2);
    }
}

