/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class DynamicPartition<T>
extends PrimitiveOp
implements Iterable<Operand<T>> {
    private List<Output<T>> outputs;

    public static <T> DynamicPartition<T> create(Scope scope, Operand<T> data, Operand<Integer> partitions, Long numPartitions) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("DynamicPartition", scope.makeOpName("DynamicPartition"));
        operationBuilder.addInput(data.asOutput());
        operationBuilder.addInput(partitions.asOutput());
        operationBuilder.setAttr("num_partitions", numPartitions);
        return new DynamicPartition<T>(operationBuilder.build());
    }

    public final List<Output<T>> outputs() {
        return this.outputs;
    }

    @Override
    public final Iterator<Operand<T>> iterator() {
        return this.outputs.iterator();
    }

    private DynamicPartition(Operation operation) {
        super(operation);
        int n2 = operation.outputListLength("outputs");
        this.outputs = Arrays.asList(operation.outputList(0, n2));
    }
}

