/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class EditDistance
extends PrimitiveOp
implements Operand<Float> {
    private Output<Float> output;

    public static <T> EditDistance create(Scope scope, Operand<Long> hypothesisIndices, Operand<T> hypothesisValues, Operand<Long> hypothesisShape, Operand<Long> truthIndices, Operand<T> truthValues, Operand<Long> truthShape, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("EditDistance", scope.makeOpName("EditDistance"));
        operationBuilder.addInput(hypothesisIndices.asOutput());
        operationBuilder.addInput(hypothesisValues.asOutput());
        operationBuilder.addInput(hypothesisShape.asOutput());
        operationBuilder.addInput(truthIndices.asOutput());
        operationBuilder.addInput(truthValues.asOutput());
        operationBuilder.addInput(truthShape.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.normalize == null) continue;
                operationBuilder.setAttr("normalize", options2.normalize);
            }
        }
        return new EditDistance(operationBuilder.build());
    }

    public static Options normalize(Boolean normalize) {
        return new Options().normalize(normalize);
    }

    public final Output<Float> output() {
        return this.output;
    }

    @Override
    public final Output<Float> asOutput() {
        return this.output;
    }

    private EditDistance(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private Boolean normalize;

        public Options normalize(Boolean normalize) {
            this.normalize = normalize;
            return this;
        }

        private Options() {
        }
    }
}

