/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class LeakyRelu<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> activations;

    public static <T extends Number> LeakyRelu<T> create(Scope scope, Operand<T> features, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("LeakyRelu", scope.makeOpName("LeakyRelu"));
        operationBuilder.addInput(features.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.alpha == null) continue;
                operationBuilder.setAttr("alpha", options2.alpha.floatValue());
            }
        }
        return new LeakyRelu<T>(operationBuilder.build());
    }

    public static Options alpha(Float alpha) {
        return new Options().alpha(alpha);
    }

    public final Output<T> activations() {
        return this.activations;
    }

    @Override
    public final Output<T> asOutput() {
        return this.activations;
    }

    private LeakyRelu(Operation operation) {
        super(operation);
        this.activations = operation.output(0);
    }

    public static class Options {
        private Float alpha;

        public Options alpha(Float alpha) {
            this.alpha = alpha;
            return this;
        }

        private Options() {
        }
    }
}

