/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class LearnedUnigramCandidateSampler
extends PrimitiveOp {
    private Output<Long> sampledCandidates;
    private Output<Float> trueExpectedCount;
    private Output<Float> sampledExpectedCount;

    public static LearnedUnigramCandidateSampler create(Scope scope, Operand<Long> trueClasses, Long numTrue, Long numSampled, Boolean unique, Long rangeMax, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("LearnedUnigramCandidateSampler", scope.makeOpName("LearnedUnigramCandidateSampler"));
        operationBuilder.addInput(trueClasses.asOutput());
        operationBuilder.setAttr("num_true", numTrue);
        operationBuilder.setAttr("num_sampled", numSampled);
        operationBuilder.setAttr("unique", unique);
        operationBuilder.setAttr("range_max", rangeMax);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.seed != null) {
                    operationBuilder.setAttr("seed", options2.seed);
                }
                if (options2.seed2 == null) continue;
                operationBuilder.setAttr("seed2", options2.seed2);
            }
        }
        return new LearnedUnigramCandidateSampler(operationBuilder.build());
    }

    public static Options seed(Long seed) {
        return new Options().seed(seed);
    }

    public static Options seed2(Long seed2) {
        return new Options().seed2(seed2);
    }

    public final Output<Long> sampledCandidates() {
        return this.sampledCandidates;
    }

    public final Output<Float> trueExpectedCount() {
        return this.trueExpectedCount;
    }

    public final Output<Float> sampledExpectedCount() {
        return this.sampledExpectedCount;
    }

    private LearnedUnigramCandidateSampler(Operation operation) {
        super(operation);
        this.sampledCandidates = operation.output(0);
        this.trueExpectedCount = operation.output(1);
        this.sampledExpectedCount = operation.output(2);
    }

    public static class Options {
        private Long seed;
        private Long seed2;

        public Options seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public Options seed2(Long seed2) {
            this.seed2 = seed2;
            return this;
        }

        private Options() {
        }
    }
}

