/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class MaxPoolV2<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T> MaxPoolV2<T> create(Scope scope, Operand<T> input, Operand<Integer> ksize, Operand<Integer> strides, String padding, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("MaxPoolV2", scope.makeOpName("MaxPoolV2"));
        operationBuilder.addInput(input.asOutput());
        operationBuilder.addInput(ksize.asOutput());
        operationBuilder.addInput(strides.asOutput());
        operationBuilder.setAttr("padding", padding);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.dataFormat == null) continue;
                operationBuilder.setAttr("data_format", options2.dataFormat);
            }
        }
        return new MaxPoolV2<T>(operationBuilder.build());
    }

    public static Options dataFormat(String dataFormat) {
        return new Options().dataFormat(dataFormat);
    }

    public final Output<T> output() {
        return this.output;
    }

    @Override
    public final Output<T> asOutput() {
        return this.output;
    }

    private MaxPoolV2(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private String dataFormat;

        public Options dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        private Options() {
        }
    }
}

