/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class MaxPoolWithArgmax<T extends Number, U extends Number>
extends PrimitiveOp {
    private Output<T> output;
    private Output<U> argmax;

    public static <T extends Number, U extends Number> MaxPoolWithArgmax<T, U> create(Scope scope, Operand<T> input, List<Long> ksize, List<Long> strides, Class<U> Targmax, String padding) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("MaxPoolWithArgmax", scope.makeOpName("MaxPoolWithArgmax"));
        operationBuilder.addInput(input.asOutput());
        long[] lArray = new long[ksize.size()];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            lArray[i2] = ksize.get(i2);
        }
        operationBuilder.setAttr("ksize", lArray);
        long[] lArray2 = new long[strides.size()];
        for (int i3 = 0; i3 < lArray2.length; ++i3) {
            lArray2[i3] = strides.get(i3);
        }
        operationBuilder.setAttr("strides", lArray2);
        operationBuilder.setAttr("Targmax", DataType.fromClass(Targmax));
        operationBuilder.setAttr("padding", padding);
        return new MaxPoolWithArgmax<T, U>(operationBuilder.build());
    }

    public static <T extends Number> MaxPoolWithArgmax<T, Long> create(Scope scope, Operand<T> input, List<Long> ksize, List<Long> strides, String padding) {
        return MaxPoolWithArgmax.create(scope, input, ksize, strides, Long.class, padding);
    }

    public final Output<T> output() {
        return this.output;
    }

    public final Output<U> argmax() {
        return this.argmax;
    }

    private MaxPoolWithArgmax(Operation operation) {
        super(operation);
        this.output = operation.output(0);
        this.argmax = operation.output(1);
    }
}

