/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Min<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T, U extends Number> Min<T> create(Scope scope, Operand<T> input, Operand<U> axis, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("Min", scope.makeOpName("Min"));
        operationBuilder.addInput(input.asOutput());
        operationBuilder.addInput(axis.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.keepDims == null) continue;
                operationBuilder.setAttr("keep_dims", options2.keepDims);
            }
        }
        return new Min<T>(operationBuilder.build());
    }

    public static Options keepDims(Boolean keepDims) {
        return new Options().keepDims(keepDims);
    }

    public final Output<T> output() {
        return this.output;
    }

    @Override
    public final Output<T> asOutput() {
        return this.output;
    }

    private Min(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private Boolean keepDims;

        public Options keepDims(Boolean keepDims) {
            this.keepDims = keepDims;
            return this;
        }

        private Options() {
        }
    }
}

