/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class MutableDenseHashTable
extends PrimitiveOp
implements Operand<Object> {
    private Output<?> tableHandle;

    public static <T, U> MutableDenseHashTable create(Scope scope, Operand<T> emptyKey, Operand<T> deletedKey, Class<U> valueDtype, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("MutableDenseHashTableV2", scope.makeOpName("MutableDenseHashTable"));
        operationBuilder.addInput(emptyKey.asOutput());
        operationBuilder.addInput(deletedKey.asOutput());
        operationBuilder.setAttr("value_dtype", DataType.fromClass(valueDtype));
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.container != null) {
                    operationBuilder.setAttr("container", options2.container);
                }
                if (options2.sharedName != null) {
                    operationBuilder.setAttr("shared_name", options2.sharedName);
                }
                if (options2.useNodeNameSharing != null) {
                    operationBuilder.setAttr("use_node_name_sharing", options2.useNodeNameSharing);
                }
                if (options2.valueShape != null) {
                    operationBuilder.setAttr("value_shape", options2.valueShape);
                }
                if (options2.initialNumBuckets != null) {
                    operationBuilder.setAttr("initial_num_buckets", options2.initialNumBuckets);
                }
                if (options2.maxLoadFactor == null) continue;
                operationBuilder.setAttr("max_load_factor", options2.maxLoadFactor.floatValue());
            }
        }
        return new MutableDenseHashTable(operationBuilder.build());
    }

    public static Options container(String container) {
        return new Options().container(container);
    }

    public static Options sharedName(String sharedName) {
        return new Options().sharedName(sharedName);
    }

    public static Options useNodeNameSharing(Boolean useNodeNameSharing) {
        return new Options().useNodeNameSharing(useNodeNameSharing);
    }

    public static Options valueShape(Shape valueShape) {
        return new Options().valueShape(valueShape);
    }

    public static Options initialNumBuckets(Long initialNumBuckets) {
        return new Options().initialNumBuckets(initialNumBuckets);
    }

    public static Options maxLoadFactor(Float maxLoadFactor) {
        return new Options().maxLoadFactor(maxLoadFactor);
    }

    public final Output<?> tableHandle() {
        return this.tableHandle;
    }

    @Override
    public final Output<Object> asOutput() {
        return this.tableHandle;
    }

    private MutableDenseHashTable(Operation operation) {
        super(operation);
        this.tableHandle = operation.output(0);
    }

    public static class Options {
        private String container;
        private String sharedName;
        private Boolean useNodeNameSharing;
        private Shape valueShape;
        private Long initialNumBuckets;
        private Float maxLoadFactor;

        public Options container(String container) {
            this.container = container;
            return this;
        }

        public Options sharedName(String sharedName) {
            this.sharedName = sharedName;
            return this;
        }

        public Options useNodeNameSharing(Boolean useNodeNameSharing) {
            this.useNodeNameSharing = useNodeNameSharing;
            return this;
        }

        public Options valueShape(Shape valueShape) {
            this.valueShape = valueShape;
            return this;
        }

        public Options initialNumBuckets(Long initialNumBuckets) {
            this.initialNumBuckets = initialNumBuckets;
            return this;
        }

        public Options maxLoadFactor(Float maxLoadFactor) {
            this.maxLoadFactor = maxLoadFactor;
            return this;
        }

        private Options() {
        }
    }
}

