/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ParseExample
extends PrimitiveOp {
    private List<Output<Long>> sparseIndices;
    private List<Output<?>> sparseValues;
    private List<Output<Long>> sparseShapes;
    private List<Output<?>> denseValues;

    public static ParseExample create(Scope scope, Operand<String> serialized, Operand<String> names, Iterable<Operand<String>> sparseKeys, Iterable<Operand<String>> denseKeys, Iterable<Operand<?>> denseDefaults, List<Class<?>> sparseTypes, List<Shape> denseShapes) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("ParseExample", scope.makeOpName("ParseExample"));
        operationBuilder.addInput(serialized.asOutput());
        operationBuilder.addInput(names.asOutput());
        operationBuilder.addInputList(Operands.asOutputs(sparseKeys));
        operationBuilder.addInputList(Operands.asOutputs(denseKeys));
        operationBuilder.addInputList(Operands.asOutputs(denseDefaults));
        DataType[] dataTypeArray = new DataType[sparseTypes.size()];
        for (int i2 = 0; i2 < dataTypeArray.length; ++i2) {
            dataTypeArray[i2] = DataType.fromClass(sparseTypes.get(i2));
        }
        operationBuilder.setAttr("sparse_types", dataTypeArray);
        Shape[] shapeArray = new Shape[denseShapes.size()];
        for (int i3 = 0; i3 < shapeArray.length; ++i3) {
            shapeArray[i3] = denseShapes.get(i3);
        }
        operationBuilder.setAttr("dense_shapes", shapeArray);
        return new ParseExample(operationBuilder.build());
    }

    public final List<Output<Long>> sparseIndices() {
        return this.sparseIndices;
    }

    public final List<Output<?>> sparseValues() {
        return this.sparseValues;
    }

    public final List<Output<Long>> sparseShapes() {
        return this.sparseShapes;
    }

    public final List<Output<?>> denseValues() {
        return this.denseValues;
    }

    private ParseExample(Operation operation) {
        super(operation);
        int n2 = operation.outputListLength("sparse_indices");
        this.sparseIndices = Arrays.asList(operation.outputList(0, n2));
        int n3 = n2 + 0;
        int n4 = operation.outputListLength("sparse_values");
        this.sparseValues = Arrays.asList(operation.outputList(n3, n4));
        int n5 = operation.outputListLength("sparse_shapes");
        this.sparseShapes = Arrays.asList(operation.outputList(n3 += n4, n5));
        int n6 = operation.outputListLength("dense_values");
        this.denseValues = Arrays.asList(operation.outputList(n3 += n5, n6));
    }
}

