/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.Shape;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ParseSingleSequenceExample
extends PrimitiveOp {
    private List<Output<Long>> contextSparseIndices;
    private List<Output<?>> contextSparseValues;
    private List<Output<Long>> contextSparseShapes;
    private List<Output<?>> contextDenseValues;
    private List<Output<Long>> featureListSparseIndices;
    private List<Output<?>> featureListSparseValues;
    private List<Output<Long>> featureListSparseShapes;
    private List<Output<?>> featureListDenseValues;

    public static ParseSingleSequenceExample create(Scope scope, Operand<String> serialized, Operand<String> featureListDenseMissingAssumedEmpty, Iterable<Operand<String>> contextSparseKeys, Iterable<Operand<String>> contextDenseKeys, Iterable<Operand<String>> featureListSparseKeys, Iterable<Operand<String>> featureListDenseKeys, Iterable<Operand<?>> contextDenseDefaults, Operand<String> debugName, List<Class<?>> contextSparseTypes, List<Class<?>> featureListDenseTypes, List<Class<?>> featureListSparseTypes, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("ParseSingleSequenceExample", scope.makeOpName("ParseSingleSequenceExample"));
        operationBuilder.addInput(serialized.asOutput());
        operationBuilder.addInput(featureListDenseMissingAssumedEmpty.asOutput());
        operationBuilder.addInputList(Operands.asOutputs(contextSparseKeys));
        operationBuilder.addInputList(Operands.asOutputs(contextDenseKeys));
        operationBuilder.addInputList(Operands.asOutputs(featureListSparseKeys));
        operationBuilder.addInputList(Operands.asOutputs(featureListDenseKeys));
        operationBuilder.addInputList(Operands.asOutputs(contextDenseDefaults));
        operationBuilder.addInput(debugName.asOutput());
        DataType[] dataTypeArray = new DataType[contextSparseTypes.size()];
        for (int i2 = 0; i2 < dataTypeArray.length; ++i2) {
            dataTypeArray[i2] = DataType.fromClass(contextSparseTypes.get(i2));
        }
        operationBuilder.setAttr("context_sparse_types", dataTypeArray);
        DataType[] dataTypeArray2 = new DataType[featureListDenseTypes.size()];
        for (int i3 = 0; i3 < dataTypeArray2.length; ++i3) {
            dataTypeArray2[i3] = DataType.fromClass(featureListDenseTypes.get(i3));
        }
        operationBuilder.setAttr("feature_list_dense_types", dataTypeArray2);
        DataType[] dataTypeArray3 = new DataType[featureListSparseTypes.size()];
        for (int i4 = 0; i4 < dataTypeArray3.length; ++i4) {
            dataTypeArray3[i4] = DataType.fromClass(featureListSparseTypes.get(i4));
        }
        operationBuilder.setAttr("feature_list_sparse_types", dataTypeArray3);
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i5 = 0; i5 < n2; ++i5) {
                int n3;
                Shape[] shapeArray;
                Options options2 = optionsArray[i5];
                if (options2.contextDenseShapes != null) {
                    shapeArray = new Shape[options2.contextDenseShapes.size()];
                    for (n3 = 0; n3 < shapeArray.length; ++n3) {
                        shapeArray[n3] = (Shape)options2.contextDenseShapes.get(n3);
                    }
                    operationBuilder.setAttr("context_dense_shapes", shapeArray);
                }
                if (options2.featureListDenseShapes == null) continue;
                shapeArray = new Shape[options2.featureListDenseShapes.size()];
                for (n3 = 0; n3 < shapeArray.length; ++n3) {
                    shapeArray[n3] = (Shape)options2.featureListDenseShapes.get(n3);
                }
                operationBuilder.setAttr("feature_list_dense_shapes", shapeArray);
            }
        }
        return new ParseSingleSequenceExample(operationBuilder.build());
    }

    public static Options contextDenseShapes(List<Shape> contextDenseShapes) {
        return new Options().contextDenseShapes(contextDenseShapes);
    }

    public static Options featureListDenseShapes(List<Shape> featureListDenseShapes) {
        return new Options().featureListDenseShapes(featureListDenseShapes);
    }

    public final List<Output<Long>> contextSparseIndices() {
        return this.contextSparseIndices;
    }

    public final List<Output<?>> contextSparseValues() {
        return this.contextSparseValues;
    }

    public final List<Output<Long>> contextSparseShapes() {
        return this.contextSparseShapes;
    }

    public final List<Output<?>> contextDenseValues() {
        return this.contextDenseValues;
    }

    public final List<Output<Long>> featureListSparseIndices() {
        return this.featureListSparseIndices;
    }

    public final List<Output<?>> featureListSparseValues() {
        return this.featureListSparseValues;
    }

    public final List<Output<Long>> featureListSparseShapes() {
        return this.featureListSparseShapes;
    }

    public final List<Output<?>> featureListDenseValues() {
        return this.featureListDenseValues;
    }

    private ParseSingleSequenceExample(Operation operation) {
        super(operation);
        int n2 = operation.outputListLength("context_sparse_indices");
        this.contextSparseIndices = Arrays.asList(operation.outputList(0, n2));
        int n3 = n2 + 0;
        int n4 = operation.outputListLength("context_sparse_values");
        this.contextSparseValues = Arrays.asList(operation.outputList(n3, n4));
        int n5 = operation.outputListLength("context_sparse_shapes");
        this.contextSparseShapes = Arrays.asList(operation.outputList(n3 += n4, n5));
        int n6 = operation.outputListLength("context_dense_values");
        this.contextDenseValues = Arrays.asList(operation.outputList(n3 += n5, n6));
        int n7 = operation.outputListLength("feature_list_sparse_indices");
        this.featureListSparseIndices = Arrays.asList(operation.outputList(n3 += n6, n7));
        int n8 = operation.outputListLength("feature_list_sparse_values");
        this.featureListSparseValues = Arrays.asList(operation.outputList(n3 += n7, n8));
        int n9 = operation.outputListLength("feature_list_sparse_shapes");
        this.featureListSparseShapes = Arrays.asList(operation.outputList(n3 += n8, n9));
        int n10 = operation.outputListLength("feature_list_dense_values");
        this.featureListDenseValues = Arrays.asList(operation.outputList(n3 += n9, n10));
    }

    public static class Options {
        private List<Shape> contextDenseShapes;
        private List<Shape> featureListDenseShapes;

        public Options contextDenseShapes(List<Shape> contextDenseShapes) {
            this.contextDenseShapes = contextDenseShapes;
            return this;
        }

        public Options featureListDenseShapes(List<Shape> featureListDenseShapes) {
            this.featureListDenseShapes = featureListDenseShapes;
            return this;
        }

        private Options() {
        }
    }
}

