/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Qr<T>
extends PrimitiveOp {
    private Output<T> q;
    private Output<T> r;

    public static <T> Qr<T> create(Scope scope, Operand<T> input, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("Qr", scope.makeOpName("Qr"));
        operationBuilder.addInput(input.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.fullMatrices == null) continue;
                operationBuilder.setAttr("full_matrices", options2.fullMatrices);
            }
        }
        return new Qr<T>(operationBuilder.build());
    }

    public static Options fullMatrices(Boolean fullMatrices) {
        return new Options().fullMatrices(fullMatrices);
    }

    public final Output<T> q() {
        return this.q;
    }

    public final Output<T> r() {
        return this.r;
    }

    private Qr(Operation operation) {
        super(operation);
        this.q = operation.output(0);
        this.r = operation.output(1);
    }

    public static class Options {
        private Boolean fullMatrices;

        public Options fullMatrices(Boolean fullMatrices) {
            this.fullMatrices = fullMatrices;
            return this;
        }

        private Options() {
        }
    }
}

