/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QuantizeAndDequantize<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends Number> QuantizeAndDequantize<T> create(Scope scope, Operand<T> input, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("QuantizeAndDequantize", scope.makeOpName("QuantizeAndDequantize"));
        operationBuilder.addInput(input.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.signedInput != null) {
                    operationBuilder.setAttr("signed_input", options2.signedInput);
                }
                if (options2.numBits != null) {
                    operationBuilder.setAttr("num_bits", options2.numBits);
                }
                if (options2.rangeGiven != null) {
                    operationBuilder.setAttr("range_given", options2.rangeGiven);
                }
                if (options2.inputMin != null) {
                    operationBuilder.setAttr("input_min", options2.inputMin.floatValue());
                }
                if (options2.inputMax == null) continue;
                operationBuilder.setAttr("input_max", options2.inputMax.floatValue());
            }
        }
        return new QuantizeAndDequantize<T>(operationBuilder.build());
    }

    public static Options signedInput(Boolean signedInput) {
        return new Options().signedInput(signedInput);
    }

    public static Options numBits(Long numBits) {
        return new Options().numBits(numBits);
    }

    public static Options rangeGiven(Boolean rangeGiven) {
        return new Options().rangeGiven(rangeGiven);
    }

    public static Options inputMin(Float inputMin) {
        return new Options().inputMin(inputMin);
    }

    public static Options inputMax(Float inputMax) {
        return new Options().inputMax(inputMax);
    }

    public final Output<T> output() {
        return this.output;
    }

    @Override
    public final Output<T> asOutput() {
        return this.output;
    }

    private QuantizeAndDequantize(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private Boolean signedInput;
        private Long numBits;
        private Boolean rangeGiven;
        private Float inputMin;
        private Float inputMax;

        public Options signedInput(Boolean signedInput) {
            this.signedInput = signedInput;
            return this;
        }

        public Options numBits(Long numBits) {
            this.numBits = numBits;
            return this;
        }

        public Options rangeGiven(Boolean rangeGiven) {
            this.rangeGiven = rangeGiven;
            return this;
        }

        public Options inputMin(Float inputMin) {
            this.inputMin = inputMin;
            return this;
        }

        public Options inputMax(Float inputMax) {
            this.inputMax = inputMax;
            return this;
        }

        private Options() {
        }
    }
}

