/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QuantizedBatchNormWithGlobalNormalization<U>
extends PrimitiveOp {
    private Output<U> result;
    private Output<Float> resultMin;
    private Output<Float> resultMax;

    public static <U, T> QuantizedBatchNormWithGlobalNormalization<U> create(Scope scope, Operand<T> t2, Operand<Float> tMin, Operand<Float> tMax, Operand<T> m2, Operand<Float> mMin, Operand<Float> mMax, Operand<T> v2, Operand<Float> vMin, Operand<Float> vMax, Operand<T> beta, Operand<Float> betaMin, Operand<Float> betaMax, Operand<T> gamma, Operand<Float> gammaMin, Operand<Float> gammaMax, Class<U> outType, Float varianceEpsilon, Boolean scaleAfterNormalization) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("QuantizedBatchNormWithGlobalNormalization", scope.makeOpName("QuantizedBatchNormWithGlobalNormalization"));
        operationBuilder.addInput(t2.asOutput());
        operationBuilder.addInput(tMin.asOutput());
        operationBuilder.addInput(tMax.asOutput());
        operationBuilder.addInput(m2.asOutput());
        operationBuilder.addInput(mMin.asOutput());
        operationBuilder.addInput(mMax.asOutput());
        operationBuilder.addInput(v2.asOutput());
        operationBuilder.addInput(vMin.asOutput());
        operationBuilder.addInput(vMax.asOutput());
        operationBuilder.addInput(beta.asOutput());
        operationBuilder.addInput(betaMin.asOutput());
        operationBuilder.addInput(betaMax.asOutput());
        operationBuilder.addInput(gamma.asOutput());
        operationBuilder.addInput(gammaMin.asOutput());
        operationBuilder.addInput(gammaMax.asOutput());
        operationBuilder.setAttr("out_type", DataType.fromClass(outType));
        operationBuilder.setAttr("variance_epsilon", varianceEpsilon.floatValue());
        operationBuilder.setAttr("scale_after_normalization", scaleAfterNormalization);
        return new QuantizedBatchNormWithGlobalNormalization<U>(operationBuilder.build());
    }

    public final Output<U> result() {
        return this.result;
    }

    public final Output<Float> resultMin() {
        return this.resultMin;
    }

    public final Output<Float> resultMax() {
        return this.resultMax;
    }

    private QuantizedBatchNormWithGlobalNormalization(Operation operation) {
        super(operation);
        this.result = operation.output(0);
        this.resultMin = operation.output(1);
        this.resultMax = operation.output(2);
    }
}

