/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class QuantizedReshape<T>
extends PrimitiveOp {
    private Output<T> output;
    private Output<Float> outputMin;
    private Output<Float> outputMax;

    public static <T, U extends Number> QuantizedReshape<T> create(Scope scope, Operand<T> tensor, Operand<U> shape, Operand<Float> inputMin, Operand<Float> inputMax) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("QuantizedReshape", scope.makeOpName("QuantizedReshape"));
        operationBuilder.addInput(tensor.asOutput());
        operationBuilder.addInput(shape.asOutput());
        operationBuilder.addInput(inputMin.asOutput());
        operationBuilder.addInput(inputMax.asOutput());
        return new QuantizedReshape<T>(operationBuilder.build());
    }

    public final Output<T> output() {
        return this.output;
    }

    public final Output<Float> outputMin() {
        return this.outputMin;
    }

    public final Output<Float> outputMax() {
        return this.outputMax;
    }

    private QuantizedReshape(Operation operation) {
        super(operation);
        this.output = operation.output(0);
        this.outputMin = operation.output(1);
        this.outputMax = operation.output(2);
    }
}

