/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class ReduceAll
extends PrimitiveOp
implements Operand<Boolean> {
    private Output<Boolean> output;

    public static <T extends Number> ReduceAll create(Scope scope, Operand<Boolean> input, Operand<T> axis, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("All", scope.makeOpName("ReduceAll"));
        operationBuilder.addInput(input.asOutput());
        operationBuilder.addInput(axis.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.keepDims == null) continue;
                operationBuilder.setAttr("keep_dims", options2.keepDims);
            }
        }
        return new ReduceAll(operationBuilder.build());
    }

    public static Options keepDims(Boolean keepDims) {
        return new Options().keepDims(keepDims);
    }

    public final Output<Boolean> output() {
        return this.output;
    }

    @Override
    public final Output<Boolean> asOutput() {
        return this.output;
    }

    private ReduceAll(Operation operation) {
        super(operation);
        this.output = operation.output(0);
    }

    public static class Options {
        private Boolean keepDims;

        public Options keepDims(Boolean keepDims) {
            this.keepDims = keepDims;
            return this;
        }

        private Options() {
        }
    }
}

