/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Requantize<U>
extends PrimitiveOp {
    private Output<U> output;
    private Output<Float> outputMin;
    private Output<Float> outputMax;

    public static <U, T> Requantize<U> create(Scope scope, Operand<T> input, Operand<Float> inputMin, Operand<Float> inputMax, Operand<Float> requestedOutputMin, Operand<Float> requestedOutputMax, Class<U> outType) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("Requantize", scope.makeOpName("Requantize"));
        operationBuilder.addInput(input.asOutput());
        operationBuilder.addInput(inputMin.asOutput());
        operationBuilder.addInput(inputMax.asOutput());
        operationBuilder.addInput(requestedOutputMin.asOutput());
        operationBuilder.addInput(requestedOutputMax.asOutput());
        operationBuilder.setAttr("out_type", DataType.fromClass(outType));
        return new Requantize<U>(operationBuilder.build());
    }

    public final Output<U> output() {
        return this.output;
    }

    public final Output<Float> outputMin() {
        return this.outputMin;
    }

    public final Output<Float> outputMax() {
        return this.outputMax;
    }

    private Requantize(Operation operation) {
        super(operation);
        this.output = operation.output(0);
        this.outputMin = operation.output(1);
        this.outputMax = operation.output(2);
    }
}

