/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class RestoreSlice<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> tensor;

    public static <T> RestoreSlice<T> create(Scope scope, Operand<String> filePattern, Operand<String> tensorName, Operand<String> shapeAndSlice, Class<T> dt, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("RestoreSlice", scope.makeOpName("RestoreSlice"));
        operationBuilder.addInput(filePattern.asOutput());
        operationBuilder.addInput(tensorName.asOutput());
        operationBuilder.addInput(shapeAndSlice.asOutput());
        operationBuilder.setAttr("dt", DataType.fromClass(dt));
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.preferredShard == null) continue;
                operationBuilder.setAttr("preferred_shard", options2.preferredShard);
            }
        }
        return new RestoreSlice<T>(operationBuilder.build());
    }

    public static Options preferredShard(Long preferredShard) {
        return new Options().preferredShard(preferredShard);
    }

    public final Output<T> tensor() {
        return this.tensor;
    }

    @Override
    public final Output<T> asOutput() {
        return this.tensor;
    }

    private RestoreSlice(Operation operation) {
        super(operation);
        this.tensor = operation.output(0);
    }

    public static class Options {
        private Long preferredShard;

        public Options preferredShard(Long preferredShard) {
            this.preferredShard = preferredShard;
            return this;
        }

        private Options() {
        }
    }
}

