/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class SparseSplit<T>
extends PrimitiveOp {
    private List<Output<Long>> outputIndices;
    private List<Output<T>> outputValues;
    private List<Output<Long>> outputShape;

    public static <T> SparseSplit<T> create(Scope scope, Operand<Long> splitDim, Operand<Long> indices, Operand<T> values, Operand<Long> shape, Long numSplit) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("SparseSplit", scope.makeOpName("SparseSplit"));
        operationBuilder.addInput(splitDim.asOutput());
        operationBuilder.addInput(indices.asOutput());
        operationBuilder.addInput(values.asOutput());
        operationBuilder.addInput(shape.asOutput());
        operationBuilder.setAttr("num_split", numSplit);
        return new SparseSplit<T>(operationBuilder.build());
    }

    public final List<Output<Long>> outputIndices() {
        return this.outputIndices;
    }

    public final List<Output<T>> outputValues() {
        return this.outputValues;
    }

    public final List<Output<Long>> outputShape() {
        return this.outputShape;
    }

    private SparseSplit(Operation operation) {
        super(operation);
        int n2 = operation.outputListLength("output_indices");
        this.outputIndices = Arrays.asList(operation.outputList(0, n2));
        int n3 = n2 + 0;
        int n4 = operation.outputListLength("output_values");
        this.outputValues = Arrays.asList(operation.outputList(n3, n4));
        int n5 = operation.outputListLength("output_shape");
        this.outputShape = Arrays.asList(operation.outputList(n3 += n4, n5));
    }
}

