/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class SparseTensorDenseMatMul<U>
extends PrimitiveOp
implements Operand<U> {
    private Output<U> product;

    public static <U, T extends Number> SparseTensorDenseMatMul<U> create(Scope scope, Operand<T> aIndices, Operand<U> aValues, Operand<Long> aShape, Operand<U> b2, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("SparseTensorDenseMatMul", scope.makeOpName("SparseTensorDenseMatMul"));
        operationBuilder.addInput(aIndices.asOutput());
        operationBuilder.addInput(aValues.asOutput());
        operationBuilder.addInput(aShape.asOutput());
        operationBuilder.addInput(b2.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.adjointA != null) {
                    operationBuilder.setAttr("adjoint_a", options2.adjointA);
                }
                if (options2.adjointB == null) continue;
                operationBuilder.setAttr("adjoint_b", options2.adjointB);
            }
        }
        return new SparseTensorDenseMatMul<U>(operationBuilder.build());
    }

    public static Options adjointA(Boolean adjointA) {
        return new Options().adjointA(adjointA);
    }

    public static Options adjointB(Boolean adjointB) {
        return new Options().adjointB(adjointB);
    }

    public final Output<U> product() {
        return this.product;
    }

    @Override
    public final Output<U> asOutput() {
        return this.product;
    }

    private SparseTensorDenseMatMul(Operation operation) {
        super(operation);
        this.product = operation.output(0);
    }

    public static class Options {
        private Boolean adjointA;
        private Boolean adjointB;

        public Options adjointA(Boolean adjointA) {
            this.adjointA = adjointA;
            return this;
        }

        public Options adjointB(Boolean adjointB) {
            this.adjointB = adjointB;
            return this;
        }

        private Options() {
        }
    }
}

