/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class TryRpc
extends PrimitiveOp {
    private Output<String> response;
    private Output<Integer> statusCode;
    private Output<String> statusMessage;

    public static TryRpc create(Scope scope, Operand<String> address, Operand<String> method, Operand<String> request, Options ... options) {
        OperationBuilder operationBuilder = scope.graph().opBuilder("TryRpc", scope.makeOpName("TryRpc"));
        operationBuilder.addInput(address.asOutput());
        operationBuilder.addInput(method.asOutput());
        operationBuilder.addInput(request.asOutput());
        if (options != null) {
            Options[] optionsArray = options;
            int n2 = options.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Options options2 = optionsArray[i2];
                if (options2.protocol != null) {
                    operationBuilder.setAttr("protocol", options2.protocol);
                }
                if (options2.failFast != null) {
                    operationBuilder.setAttr("fail_fast", options2.failFast);
                }
                if (options2.timeoutInMs == null) continue;
                operationBuilder.setAttr("timeout_in_ms", options2.timeoutInMs);
            }
        }
        return new TryRpc(operationBuilder.build());
    }

    public static Options protocol(String protocol) {
        return new Options().protocol(protocol);
    }

    public static Options failFast(Boolean failFast) {
        return new Options().failFast(failFast);
    }

    public static Options timeoutInMs(Long timeoutInMs) {
        return new Options().timeoutInMs(timeoutInMs);
    }

    public final Output<String> response() {
        return this.response;
    }

    public final Output<Integer> statusCode() {
        return this.statusCode;
    }

    public final Output<String> statusMessage() {
        return this.statusMessage;
    }

    private TryRpc(Operation operation) {
        super(operation);
        this.response = operation.output(0);
        this.statusCode = operation.output(1);
        this.statusMessage = operation.output(2);
    }

    public static class Options {
        private String protocol;
        private Boolean failFast;
        private Long timeoutInMs;

        public Options protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Options failFast(Boolean failFast) {
            this.failFast = failFast;
            return this;
        }

        public Options timeoutInMs(Long timeoutInMs) {
            this.timeoutInMs = timeoutInMs;
            return this;
        }

        private Options() {
        }
    }
}

