/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import com.b.a.c.a;
import com.b.a.e;
import com.b.a.q;
import hex.genmodel.GenModel;
import hex.genmodel.MojoModel;
import hex.genmodel.easy.EasyPredictModelWrapper;
import hex.genmodel.easy.RowData;
import hex.genmodel.easy.exception.PredictException;
import hex.genmodel.easy.prediction.AbstractPrediction;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class H2OPredictor {
    private static final boolean DEBUG = false;
    private static boolean useLabels = false;
    private String[] labels = null;
    private EasyPredictModelWrapper model = null;
    private static final e gson = new e();
    private final Type MapType = new a<Map<String, Object>>(){}.getType();

    public H2OPredictor(String ojoFileName, String modelName) {
        try {
            if (ojoFileName == null) {
                throw new Exception("file name can't be null");
            }
            if (ojoFileName.endsWith(".jar")) {
                this.loadPojo(ojoFileName, modelName);
            } else if (ojoFileName.endsWith(".zip")) {
                this.loadMojo(ojoFileName);
            } else {
                throw new Exception("unknown model archive type");
            }
            if (useLabels) {
                this.labels = this.model.getResponseDomainValues();
            }
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            System.exit(1);
            return;
        }
    }

    private GenModel loadClassFromJar(String jarFileName, String modelName) throws Exception {
        if (!new File(jarFileName).isFile()) {
            throw new FileNotFoundException("Can't read " + jarFileName);
        }
        try {
            URL uRL = new File(jarFileName).toURI().toURL();
            URLClassLoader uRLClassLoader = URLClassLoader.newInstance(new URL[]{uRL}, this.getClass().getClassLoader());
            String string = "";
            String string2 = string + modelName;
            Class<?> clazz = uRLClassLoader.loadClass(string2);
            Class<GenModel> clazz2 = clazz.asSubclass(GenModel.class);
            return clazz2.newInstance();
        }
        catch (MalformedURLException malformedURLException) {
            throw new Exception("Can't use Jar file" + jarFileName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Exception("Can't find model " + modelName + " in jar file " + jarFileName);
        }
        catch (InstantiationException instantiationException) {
            throw new Exception("Can't find model " + modelName + " in jar file " + jarFileName);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Exception("Can't find model " + modelName + " in jar file " + jarFileName);
        }
    }

    private void loadPojo(String jarFileName, String modelName) throws Exception {
        GenModel genModel = this.loadClassFromJar(jarFileName, modelName);
        this.model = new EasyPredictModelWrapper(genModel);
    }

    private void loadMojo(String zipFileName) throws Exception {
        MojoModel mojoModel = MojoModel.load(zipFileName);
        this.model = new EasyPredictModelWrapper(mojoModel);
    }

    private RowData jsonToRowData(String json) {
        try {
            return gson.a(json, RowData.class);
        }
        catch (q q2) {
            throw new q("Malformed JSON");
        }
    }

    private RowData[] jsonToRowDataArray(String json) {
        try {
            return gson.a(json, RowData[].class);
        }
        catch (q q2) {
            throw new q("Malformed JSON Array");
        }
    }

    private String predictRow(RowData row) throws PredictException {
        if (this.model == null) {
            throw new PredictException("No model loaded");
        }
        if (gson == null) {
            throw new PredictException("Gson not available");
        }
        if (row == null) {
            throw new PredictException("No row data");
        }
        AbstractPrediction abstractPrediction = this.model.predict(row);
        String string = gson.a(abstractPrediction);
        if (useLabels) {
            Map map = (Map)gson.a(string, this.MapType);
            map.put("responseDomainValues", this.labels);
            string = gson.a(map);
        }
        return string;
    }

    public static String predict3(String ojoFileName, String modelName, String jsonArgs) {
        try {
            Object object;
            H2OPredictor h2OPredictor = new H2OPredictor(ojoFileName, modelName);
            if (ojoFileName == null) {
                throw new Exception("file name can't be null");
            }
            if (ojoFileName.endsWith(".jar")) {
                h2OPredictor.loadPojo(ojoFileName, modelName);
            } else if (ojoFileName.endsWith(".zip")) {
                h2OPredictor.loadMojo(ojoFileName);
            } else {
                throw new Exception("unknown model archive type");
            }
            if (jsonArgs == null || jsonArgs.length() == 0) {
                throw new Exception("empty json argument");
            }
            char c2 = jsonArgs.trim().charAt(0);
            boolean bl = c2 == '{' || c2 == '[';
            if (!bl) {
                object = H2OPredictor.readFile(jsonArgs);
                jsonArgs = new String((byte[])object);
                c2 = jsonArgs.trim().charAt(0);
            }
            object = "";
            if (c2 == '[') {
                RowData[] rowDataArray = h2OPredictor.jsonToRowDataArray(jsonArgs);
                object = (String)object + "[ ";
                RowData[] rowDataArray2 = rowDataArray;
                int n2 = rowDataArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    RowData rowData = rowDataArray2[i2];
                    if (!((String)object).trim().endsWith("[")) {
                        object = (String)object + ", ";
                    }
                    object = (String)object + h2OPredictor.predictRow(rowData);
                }
                object = (String)object + " ]";
            } else {
                RowData rowData = h2OPredictor.jsonToRowData(jsonArgs);
                object = h2OPredictor.predictRow(rowData);
            }
            return object;
        }
        catch (Exception exception) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("error", H2OPredictor.stackTraceToString(exception));
            String string = gson.a(hashMap);
            return string;
        }
    }

    public String pred(String jsonArgs) {
        try {
            H2OPredictor h2OPredictor = this;
            return h2OPredictor.predictRow(h2OPredictor.jsonToRowData(jsonArgs));
        }
        catch (Exception exception) {
            return "{ \"error\": \"" + H2OPredictor.stackTraceToString(exception) + "\" }";
        }
    }

    public static String predict2(String ojoFileName, String jsonArgs) {
        String string = ojoFileName.replace(".zip", "").replace(".jar", "");
        int n2 = string.lastIndexOf(File.separatorChar);
        if (n2 != -1) {
            string = string.substring(n2 + 1);
        }
        return H2OPredictor.predict3(ojoFileName, string, jsonArgs);
    }

    private static byte[] readFile(String filePath) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = null;
        try {
            int n2;
            bufferedReader = new BufferedReader(new FileReader(filePath));
            char[] cArray = new char[1024];
            while ((n2 = bufferedReader.read(cArray)) != -1) {
                String string = String.valueOf(cArray, 0, n2);
                stringBuffer.append(string);
            }
        }
        catch (Throwable throwable) {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            throw throwable;
        }
        bufferedReader.close();
        return stringBuffer.toString().getBytes();
    }

    private static String stackTraceToString(Throwable e2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        e2.printStackTrace(printStream);
        String string = byteArrayOutputStream.toString();
        try {
            printStream.close();
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            return "Can't get stack trace from throwable " + e2.getMessage();
        }
        return string;
    }

    public static void main(String[] args) {
        if (args.length > 0 && args[0].equals("-l")) {
            useLabels = true;
            args = Arrays.copyOfRange(args, 1, args.length);
        }
        String string = args.length == 2 ? H2OPredictor.predict2(args[0], args[1].replaceAll("\\\\", "")) : (args.length == 3 ? H2OPredictor.predict3(args[0], args[1], args[2].replaceAll("\\\\", "")) : "{ \"error\": \"Neeed 2 or 3 args have " + args.length + ", \"usage\": \"mojoFile jsonString  or: jarFile modelName jsonString\" } ");
        System.out.println(string);
    }
}

