/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.BooleanArrayList;
import ai.h2o.com.google.protobuf.ByteString;
import ai.h2o.com.google.protobuf.CheckReturnValue;
import ai.h2o.com.google.protobuf.CodedInputStream;
import ai.h2o.com.google.protobuf.DoubleArrayList;
import ai.h2o.com.google.protobuf.ExtensionRegistryLite;
import ai.h2o.com.google.protobuf.FloatArrayList;
import ai.h2o.com.google.protobuf.IntArrayList;
import ai.h2o.com.google.protobuf.Internal;
import ai.h2o.com.google.protobuf.InvalidProtocolBufferException;
import ai.h2o.com.google.protobuf.LazyStringList;
import ai.h2o.com.google.protobuf.LongArrayList;
import ai.h2o.com.google.protobuf.MapEntryLite;
import ai.h2o.com.google.protobuf.Protobuf;
import ai.h2o.com.google.protobuf.Reader;
import ai.h2o.com.google.protobuf.Schema;
import ai.h2o.com.google.protobuf.Utf8;
import ai.h2o.com.google.protobuf.WireFormat;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

@CheckReturnValue
abstract class BinaryReader
implements Reader {
    private static final int FIXED32_MULTIPLE_MASK = 3;
    private static final int FIXED64_MULTIPLE_MASK = 7;

    public static BinaryReader newInstance(ByteBuffer buffer, boolean bufferIsImmutable) {
        if (buffer.hasArray()) {
            return new SafeHeapReader(buffer, bufferIsImmutable);
        }
        throw new IllegalArgumentException("Direct buffers not yet supported");
    }

    private BinaryReader() {
    }

    public abstract int getTotalBytesRead();

    @Override
    public boolean shouldDiscardUnknownFields() {
        return false;
    }

    private static final class SafeHeapReader
    extends BinaryReader {
        private final boolean bufferIsImmutable;
        private final byte[] buffer;
        private int pos;
        private final int initialPos;
        private int limit;
        private int tag;
        private int endGroupTag;

        public SafeHeapReader(ByteBuffer bytebuf, boolean bufferIsImmutable) {
            this.bufferIsImmutable = bufferIsImmutable;
            this.buffer = bytebuf.array();
            SafeHeapReader safeHeapReader = this;
            safeHeapReader.initialPos = safeHeapReader.pos = bytebuf.arrayOffset() + bytebuf.position();
            this.limit = bytebuf.arrayOffset() + bytebuf.limit();
        }

        private boolean isAtEnd() {
            return this.pos == this.limit;
        }

        @Override
        public final int getTotalBytesRead() {
            return this.pos - this.initialPos;
        }

        @Override
        public final int getFieldNumber() throws IOException {
            if (this.isAtEnd()) {
                return Integer.MAX_VALUE;
            }
            this.tag = this.readVarint32();
            if (this.tag == this.endGroupTag) {
                return Integer.MAX_VALUE;
            }
            return WireFormat.getTagFieldNumber(this.tag);
        }

        @Override
        public final int getTag() {
            return this.tag;
        }

        @Override
        public final boolean skipField() throws IOException {
            if (this.isAtEnd() || this.tag == this.endGroupTag) {
                return false;
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 0: {
                    this.skipVarint();
                    return true;
                }
                case 1: {
                    this.skipBytes(8);
                    return true;
                }
                case 2: {
                    SafeHeapReader safeHeapReader = this;
                    safeHeapReader.skipBytes(safeHeapReader.readVarint32());
                    return true;
                }
                case 5: {
                    this.skipBytes(4);
                    return true;
                }
                case 3: {
                    this.skipGroup();
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        @Override
        public final double readDouble() throws IOException {
            this.requireWireType(1);
            return Double.longBitsToDouble(this.readLittleEndian64());
        }

        @Override
        public final float readFloat() throws IOException {
            this.requireWireType(5);
            return Float.intBitsToFloat(this.readLittleEndian32());
        }

        @Override
        public final long readUInt64() throws IOException {
            this.requireWireType(0);
            return this.readVarint64();
        }

        @Override
        public final long readInt64() throws IOException {
            this.requireWireType(0);
            return this.readVarint64();
        }

        @Override
        public final int readInt32() throws IOException {
            this.requireWireType(0);
            return this.readVarint32();
        }

        @Override
        public final long readFixed64() throws IOException {
            this.requireWireType(1);
            return this.readLittleEndian64();
        }

        @Override
        public final int readFixed32() throws IOException {
            this.requireWireType(5);
            return this.readLittleEndian32();
        }

        @Override
        public final boolean readBool() throws IOException {
            this.requireWireType(0);
            return this.readVarint32() != 0;
        }

        @Override
        public final String readString() throws IOException {
            return this.readStringInternal(false);
        }

        @Override
        public final String readStringRequireUtf8() throws IOException {
            return this.readStringInternal(true);
        }

        public final String readStringInternal(boolean requireUtf8) throws IOException {
            this.requireWireType(2);
            int n2 = this.readVarint32();
            if (n2 == 0) {
                return "";
            }
            this.requireBytes(n2);
            if (requireUtf8 && !Utf8.isValidUtf8(this.buffer, this.pos, this.pos + n2)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            String string = new String(this.buffer, this.pos, n2, Internal.UTF_8);
            this.pos += n2;
            return string;
        }

        @Override
        public final <T> T readMessage(Class<T> clazz, ExtensionRegistryLite extensionRegistry) throws IOException {
            this.requireWireType(2);
            return (T)this.readMessage(Protobuf.getInstance().schemaFor(clazz), extensionRegistry);
        }

        @Override
        public final <T> T readMessageBySchemaWithCheck(Schema<T> schema, ExtensionRegistryLite extensionRegistry) throws IOException {
            this.requireWireType(2);
            return this.readMessage(schema, extensionRegistry);
        }

        private <T> T readMessage(Schema<T> schema, ExtensionRegistryLite extensionRegistry) throws IOException {
            int n2;
            int n3 = this.readVarint32();
            this.requireBytes(n3);
            int n4 = this.limit;
            this.limit = n2 = this.pos + n3;
            try {
                T t2 = schema.newInstance();
                schema.mergeFrom(t2, this, extensionRegistry);
                schema.makeImmutable(t2);
                if (this.pos != n2) {
                    throw InvalidProtocolBufferException.parseFailure();
                }
                T t3 = t2;
                return t3;
            }
            finally {
                this.limit = n4;
            }
        }

        @Override
        @Deprecated
        public final <T> T readGroup(Class<T> clazz, ExtensionRegistryLite extensionRegistry) throws IOException {
            this.requireWireType(3);
            return (T)this.readGroup(Protobuf.getInstance().schemaFor(clazz), extensionRegistry);
        }

        @Override
        @Deprecated
        public final <T> T readGroupBySchemaWithCheck(Schema<T> schema, ExtensionRegistryLite extensionRegistry) throws IOException {
            this.requireWireType(3);
            return this.readGroup(schema, extensionRegistry);
        }

        private <T> T readGroup(Schema<T> schema, ExtensionRegistryLite extensionRegistry) throws IOException {
            int n2 = this.endGroupTag;
            this.endGroupTag = WireFormat.makeTag(WireFormat.getTagFieldNumber(this.tag), 4);
            try {
                T t2 = schema.newInstance();
                schema.mergeFrom(t2, this, extensionRegistry);
                schema.makeImmutable(t2);
                if (this.tag != this.endGroupTag) {
                    throw InvalidProtocolBufferException.parseFailure();
                }
                T t3 = t2;
                return t3;
            }
            finally {
                this.endGroupTag = n2;
            }
        }

        @Override
        public final ByteString readBytes() throws IOException {
            this.requireWireType(2);
            int n2 = this.readVarint32();
            if (n2 == 0) {
                return ByteString.EMPTY;
            }
            this.requireBytes(n2);
            ByteString byteString = this.bufferIsImmutable ? ByteString.wrap(this.buffer, this.pos, n2) : ByteString.copyFrom(this.buffer, this.pos, n2);
            this.pos += n2;
            return byteString;
        }

        @Override
        public final int readUInt32() throws IOException {
            this.requireWireType(0);
            return this.readVarint32();
        }

        @Override
        public final int readEnum() throws IOException {
            this.requireWireType(0);
            return this.readVarint32();
        }

        @Override
        public final int readSFixed32() throws IOException {
            this.requireWireType(5);
            return this.readLittleEndian32();
        }

        @Override
        public final long readSFixed64() throws IOException {
            this.requireWireType(1);
            return this.readLittleEndian64();
        }

        @Override
        public final int readSInt32() throws IOException {
            this.requireWireType(0);
            return CodedInputStream.decodeZigZag32(this.readVarint32());
        }

        @Override
        public final long readSInt64() throws IOException {
            this.requireWireType(0);
            return CodedInputStream.decodeZigZag64(this.readVarint64());
        }

        @Override
        public final void readDoubleList(List<Double> target) throws IOException {
            if (target instanceof DoubleArrayList) {
                DoubleArrayList doubleArrayList = (DoubleArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n2 = this.readVarint32();
                        this.verifyPackedFixed64Length(n2);
                        int n3 = this.pos + n2;
                        while (this.pos < n3) {
                            doubleArrayList.addDouble(Double.longBitsToDouble(this.readLittleEndian64_NoCheck()));
                        }
                        break;
                    }
                    case 1: {
                        int n4;
                        int n5;
                        do {
                            doubleArrayList.addDouble(this.readDouble());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n4 = this.pos;
                        } while ((n5 = this.readVarint32()) == this.tag);
                        this.pos = n4;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
                return;
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    int n6 = this.readVarint32();
                    this.verifyPackedFixed64Length(n6);
                    int n7 = this.pos + n6;
                    while (this.pos < n7) {
                        target.add(Double.longBitsToDouble(this.readLittleEndian64_NoCheck()));
                    }
                    break;
                }
                case 1: {
                    int n8;
                    int n9;
                    do {
                        target.add(this.readDouble());
                        if (this.isAtEnd()) {
                            return;
                        }
                        n8 = this.pos;
                    } while ((n9 = this.readVarint32()) == this.tag);
                    this.pos = n8;
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }

        @Override
        public final void readFloatList(List<Float> target) throws IOException {
            if (target instanceof FloatArrayList) {
                FloatArrayList floatArrayList = (FloatArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n2 = this.readVarint32();
                        this.verifyPackedFixed32Length(n2);
                        int n3 = this.pos + n2;
                        while (this.pos < n3) {
                            floatArrayList.addFloat(Float.intBitsToFloat(this.readLittleEndian32_NoCheck()));
                        }
                        break;
                    }
                    case 5: {
                        int n4;
                        int n5;
                        do {
                            floatArrayList.addFloat(this.readFloat());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n4 = this.pos;
                        } while ((n5 = this.readVarint32()) == this.tag);
                        this.pos = n4;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
                return;
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    int n6 = this.readVarint32();
                    this.verifyPackedFixed32Length(n6);
                    int n7 = this.pos + n6;
                    while (this.pos < n7) {
                        target.add(Float.valueOf(Float.intBitsToFloat(this.readLittleEndian32_NoCheck())));
                    }
                    break;
                }
                case 5: {
                    int n8;
                    int n9;
                    do {
                        target.add(Float.valueOf(this.readFloat()));
                        if (this.isAtEnd()) {
                            return;
                        }
                        n8 = this.pos;
                    } while ((n9 = this.readVarint32()) == this.tag);
                    this.pos = n8;
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }

        @Override
        public final void readUInt64List(List<Long> target) throws IOException {
            block15: {
                block14: {
                    if (!(target instanceof LongArrayList)) break block14;
                    LongArrayList longArrayList = (LongArrayList)target;
                    switch (WireFormat.getTagWireType(this.tag)) {
                        case 2: {
                            int n2 = this.readVarint32();
                            int n3 = this.pos + n2;
                            while (this.pos < n3) {
                                longArrayList.addLong(this.readVarint64());
                            }
                            this.requirePosition(n3);
                            break block15;
                        }
                        case 0: {
                            int n4;
                            int n5;
                            do {
                                longArrayList.addLong(this.readUInt64());
                                if (this.isAtEnd()) {
                                    return;
                                }
                                n4 = this.pos;
                            } while ((n5 = this.readVarint32()) == this.tag);
                            this.pos = n4;
                            return;
                        }
                        default: {
                            throw InvalidProtocolBufferException.invalidWireType();
                        }
                    }
                }
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n6 = this.readVarint32();
                        int n7 = this.pos + n6;
                        while (this.pos < n7) {
                            target.add(this.readVarint64());
                        }
                        this.requirePosition(n7);
                        return;
                    }
                    case 0: {
                        int n8;
                        int n9;
                        do {
                            target.add(this.readUInt64());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n8 = this.pos;
                        } while ((n9 = this.readVarint32()) == this.tag);
                        this.pos = n8;
                        return;
                    }
                }
                throw InvalidProtocolBufferException.invalidWireType();
            }
        }

        @Override
        public final void readInt64List(List<Long> target) throws IOException {
            block15: {
                block14: {
                    if (!(target instanceof LongArrayList)) break block14;
                    LongArrayList longArrayList = (LongArrayList)target;
                    switch (WireFormat.getTagWireType(this.tag)) {
                        case 2: {
                            int n2 = this.readVarint32();
                            int n3 = this.pos + n2;
                            while (this.pos < n3) {
                                longArrayList.addLong(this.readVarint64());
                            }
                            this.requirePosition(n3);
                            break block15;
                        }
                        case 0: {
                            int n4;
                            int n5;
                            do {
                                longArrayList.addLong(this.readInt64());
                                if (this.isAtEnd()) {
                                    return;
                                }
                                n4 = this.pos;
                            } while ((n5 = this.readVarint32()) == this.tag);
                            this.pos = n4;
                            return;
                        }
                        default: {
                            throw InvalidProtocolBufferException.invalidWireType();
                        }
                    }
                }
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n6 = this.readVarint32();
                        int n7 = this.pos + n6;
                        while (this.pos < n7) {
                            target.add(this.readVarint64());
                        }
                        this.requirePosition(n7);
                        return;
                    }
                    case 0: {
                        int n8;
                        int n9;
                        do {
                            target.add(this.readInt64());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n8 = this.pos;
                        } while ((n9 = this.readVarint32()) == this.tag);
                        this.pos = n8;
                        return;
                    }
                }
                throw InvalidProtocolBufferException.invalidWireType();
            }
        }

        @Override
        public final void readInt32List(List<Integer> target) throws IOException {
            block15: {
                block14: {
                    if (!(target instanceof IntArrayList)) break block14;
                    IntArrayList intArrayList = (IntArrayList)target;
                    switch (WireFormat.getTagWireType(this.tag)) {
                        case 2: {
                            int n2 = this.readVarint32();
                            int n3 = this.pos + n2;
                            while (this.pos < n3) {
                                intArrayList.addInt(this.readVarint32());
                            }
                            this.requirePosition(n3);
                            break block15;
                        }
                        case 0: {
                            int n4;
                            int n5;
                            do {
                                intArrayList.addInt(this.readInt32());
                                if (this.isAtEnd()) {
                                    return;
                                }
                                n4 = this.pos;
                            } while ((n5 = this.readVarint32()) == this.tag);
                            this.pos = n4;
                            return;
                        }
                        default: {
                            throw InvalidProtocolBufferException.invalidWireType();
                        }
                    }
                }
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n6 = this.readVarint32();
                        int n7 = this.pos + n6;
                        while (this.pos < n7) {
                            target.add(this.readVarint32());
                        }
                        this.requirePosition(n7);
                        return;
                    }
                    case 0: {
                        int n8;
                        int n9;
                        do {
                            target.add(this.readInt32());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n8 = this.pos;
                        } while ((n9 = this.readVarint32()) == this.tag);
                        this.pos = n8;
                        return;
                    }
                }
                throw InvalidProtocolBufferException.invalidWireType();
            }
        }

        @Override
        public final void readFixed64List(List<Long> target) throws IOException {
            if (target instanceof LongArrayList) {
                LongArrayList longArrayList = (LongArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n2 = this.readVarint32();
                        this.verifyPackedFixed64Length(n2);
                        int n3 = this.pos + n2;
                        while (this.pos < n3) {
                            longArrayList.addLong(this.readLittleEndian64_NoCheck());
                        }
                        break;
                    }
                    case 1: {
                        int n4;
                        int n5;
                        do {
                            longArrayList.addLong(this.readFixed64());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n4 = this.pos;
                        } while ((n5 = this.readVarint32()) == this.tag);
                        this.pos = n4;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
                return;
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    int n6 = this.readVarint32();
                    this.verifyPackedFixed64Length(n6);
                    int n7 = this.pos + n6;
                    while (this.pos < n7) {
                        target.add(this.readLittleEndian64_NoCheck());
                    }
                    break;
                }
                case 1: {
                    int n8;
                    int n9;
                    do {
                        target.add(this.readFixed64());
                        if (this.isAtEnd()) {
                            return;
                        }
                        n8 = this.pos;
                    } while ((n9 = this.readVarint32()) == this.tag);
                    this.pos = n8;
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }

        @Override
        public final void readFixed32List(List<Integer> target) throws IOException {
            if (target instanceof IntArrayList) {
                IntArrayList intArrayList = (IntArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n2 = this.readVarint32();
                        this.verifyPackedFixed32Length(n2);
                        int n3 = this.pos + n2;
                        while (this.pos < n3) {
                            intArrayList.addInt(this.readLittleEndian32_NoCheck());
                        }
                        break;
                    }
                    case 5: {
                        int n4;
                        int n5;
                        do {
                            intArrayList.addInt(this.readFixed32());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n4 = this.pos;
                        } while ((n5 = this.readVarint32()) == this.tag);
                        this.pos = n4;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
                return;
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    int n6 = this.readVarint32();
                    this.verifyPackedFixed32Length(n6);
                    int n7 = this.pos + n6;
                    while (this.pos < n7) {
                        target.add(this.readLittleEndian32_NoCheck());
                    }
                    break;
                }
                case 5: {
                    int n8;
                    int n9;
                    do {
                        target.add(this.readFixed32());
                        if (this.isAtEnd()) {
                            return;
                        }
                        n8 = this.pos;
                    } while ((n9 = this.readVarint32()) == this.tag);
                    this.pos = n8;
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }

        @Override
        public final void readBoolList(List<Boolean> target) throws IOException {
            block15: {
                block14: {
                    if (!(target instanceof BooleanArrayList)) break block14;
                    BooleanArrayList booleanArrayList = (BooleanArrayList)target;
                    switch (WireFormat.getTagWireType(this.tag)) {
                        case 2: {
                            int n2 = this.readVarint32();
                            int n3 = this.pos + n2;
                            while (this.pos < n3) {
                                booleanArrayList.addBoolean(this.readVarint32() != 0);
                            }
                            this.requirePosition(n3);
                            break block15;
                        }
                        case 0: {
                            int n4;
                            int n5;
                            do {
                                booleanArrayList.addBoolean(this.readBool());
                                if (this.isAtEnd()) {
                                    return;
                                }
                                n4 = this.pos;
                            } while ((n5 = this.readVarint32()) == this.tag);
                            this.pos = n4;
                            return;
                        }
                        default: {
                            throw InvalidProtocolBufferException.invalidWireType();
                        }
                    }
                }
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n6 = this.readVarint32();
                        int n7 = this.pos + n6;
                        while (this.pos < n7) {
                            target.add(this.readVarint32() != 0);
                        }
                        this.requirePosition(n7);
                        return;
                    }
                    case 0: {
                        int n8;
                        int n9;
                        do {
                            target.add(this.readBool());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n8 = this.pos;
                        } while ((n9 = this.readVarint32()) == this.tag);
                        this.pos = n8;
                        return;
                    }
                }
                throw InvalidProtocolBufferException.invalidWireType();
            }
        }

        @Override
        public final void readStringList(List<String> target) throws IOException {
            this.readStringListInternal(target, false);
        }

        @Override
        public final void readStringListRequireUtf8(List<String> target) throws IOException {
            this.readStringListInternal(target, true);
        }

        public final void readStringListInternal(List<String> target, boolean requireUtf8) throws IOException {
            int n2;
            int n3;
            if (WireFormat.getTagWireType(this.tag) != 2) {
                throw InvalidProtocolBufferException.invalidWireType();
            }
            if (target instanceof LazyStringList && !requireUtf8) {
                int n4;
                int n5;
                LazyStringList lazyStringList = (LazyStringList)target;
                do {
                    lazyStringList.add(this.readBytes());
                    if (this.isAtEnd()) {
                        return;
                    }
                    n4 = this.pos;
                } while ((n5 = this.readVarint32()) == this.tag);
                this.pos = n4;
                return;
            }
            do {
                target.add(this.readStringInternal(requireUtf8));
                if (this.isAtEnd()) {
                    return;
                }
                n2 = this.pos;
            } while ((n3 = this.readVarint32()) == this.tag);
            this.pos = n2;
        }

        @Override
        public final <T> void readMessageList(List<T> target, Class<T> targetType, ExtensionRegistryLite extensionRegistry) throws IOException {
            Schema<Class<T>> schema = Protobuf.getInstance().schemaFor(targetType);
            this.readMessageList(target, schema, extensionRegistry);
        }

        @Override
        public final <T> void readMessageList(List<T> target, Schema<T> schema, ExtensionRegistryLite extensionRegistry) throws IOException {
            int n2;
            int n3;
            if (WireFormat.getTagWireType(this.tag) != 2) {
                throw InvalidProtocolBufferException.invalidWireType();
            }
            int n4 = this.tag;
            do {
                target.add(this.readMessage(schema, extensionRegistry));
                if (this.isAtEnd()) {
                    return;
                }
                n2 = this.pos;
            } while ((n3 = this.readVarint32()) == n4);
            this.pos = n2;
        }

        @Override
        @Deprecated
        public final <T> void readGroupList(List<T> target, Class<T> targetType, ExtensionRegistryLite extensionRegistry) throws IOException {
            Schema<Class<T>> schema = Protobuf.getInstance().schemaFor(targetType);
            this.readGroupList(target, schema, extensionRegistry);
        }

        @Override
        @Deprecated
        public final <T> void readGroupList(List<T> target, Schema<T> schema, ExtensionRegistryLite extensionRegistry) throws IOException {
            int n2;
            int n3;
            if (WireFormat.getTagWireType(this.tag) != 3) {
                throw InvalidProtocolBufferException.invalidWireType();
            }
            int n4 = this.tag;
            do {
                target.add(this.readGroup(schema, extensionRegistry));
                if (this.isAtEnd()) {
                    return;
                }
                n2 = this.pos;
            } while ((n3 = this.readVarint32()) == n4);
            this.pos = n2;
        }

        @Override
        public final void readBytesList(List<ByteString> target) throws IOException {
            int n2;
            int n3;
            if (WireFormat.getTagWireType(this.tag) != 2) {
                throw InvalidProtocolBufferException.invalidWireType();
            }
            do {
                target.add(this.readBytes());
                if (this.isAtEnd()) {
                    return;
                }
                n2 = this.pos;
            } while ((n3 = this.readVarint32()) == this.tag);
            this.pos = n2;
        }

        @Override
        public final void readUInt32List(List<Integer> target) throws IOException {
            if (target instanceof IntArrayList) {
                IntArrayList intArrayList = (IntArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n2 = this.readVarint32();
                        int n3 = this.pos + n2;
                        while (this.pos < n3) {
                            intArrayList.addInt(this.readVarint32());
                        }
                        break;
                    }
                    case 0: {
                        int n4;
                        int n5;
                        do {
                            intArrayList.addInt(this.readUInt32());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n4 = this.pos;
                        } while ((n5 = this.readVarint32()) == this.tag);
                        this.pos = n4;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
                return;
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    int n6 = this.readVarint32();
                    int n7 = this.pos + n6;
                    while (this.pos < n7) {
                        target.add(this.readVarint32());
                    }
                    break;
                }
                case 0: {
                    int n8;
                    int n9;
                    do {
                        target.add(this.readUInt32());
                        if (this.isAtEnd()) {
                            return;
                        }
                        n8 = this.pos;
                    } while ((n9 = this.readVarint32()) == this.tag);
                    this.pos = n8;
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }

        @Override
        public final void readEnumList(List<Integer> target) throws IOException {
            if (target instanceof IntArrayList) {
                IntArrayList intArrayList = (IntArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n2 = this.readVarint32();
                        int n3 = this.pos + n2;
                        while (this.pos < n3) {
                            intArrayList.addInt(this.readVarint32());
                        }
                        break;
                    }
                    case 0: {
                        int n4;
                        int n5;
                        do {
                            intArrayList.addInt(this.readEnum());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n4 = this.pos;
                        } while ((n5 = this.readVarint32()) == this.tag);
                        this.pos = n4;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
                return;
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    int n6 = this.readVarint32();
                    int n7 = this.pos + n6;
                    while (this.pos < n7) {
                        target.add(this.readVarint32());
                    }
                    break;
                }
                case 0: {
                    int n8;
                    int n9;
                    do {
                        target.add(this.readEnum());
                        if (this.isAtEnd()) {
                            return;
                        }
                        n8 = this.pos;
                    } while ((n9 = this.readVarint32()) == this.tag);
                    this.pos = n8;
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }

        @Override
        public final void readSFixed32List(List<Integer> target) throws IOException {
            if (target instanceof IntArrayList) {
                IntArrayList intArrayList = (IntArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n2 = this.readVarint32();
                        this.verifyPackedFixed32Length(n2);
                        int n3 = this.pos + n2;
                        while (this.pos < n3) {
                            intArrayList.addInt(this.readLittleEndian32_NoCheck());
                        }
                        break;
                    }
                    case 5: {
                        int n4;
                        int n5;
                        do {
                            intArrayList.addInt(this.readSFixed32());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n4 = this.pos;
                        } while ((n5 = this.readVarint32()) == this.tag);
                        this.pos = n4;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
                return;
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    int n6 = this.readVarint32();
                    this.verifyPackedFixed32Length(n6);
                    int n7 = this.pos + n6;
                    while (this.pos < n7) {
                        target.add(this.readLittleEndian32_NoCheck());
                    }
                    break;
                }
                case 5: {
                    int n8;
                    int n9;
                    do {
                        target.add(this.readSFixed32());
                        if (this.isAtEnd()) {
                            return;
                        }
                        n8 = this.pos;
                    } while ((n9 = this.readVarint32()) == this.tag);
                    this.pos = n8;
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }

        @Override
        public final void readSFixed64List(List<Long> target) throws IOException {
            if (target instanceof LongArrayList) {
                LongArrayList longArrayList = (LongArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n2 = this.readVarint32();
                        this.verifyPackedFixed64Length(n2);
                        int n3 = this.pos + n2;
                        while (this.pos < n3) {
                            longArrayList.addLong(this.readLittleEndian64_NoCheck());
                        }
                        break;
                    }
                    case 1: {
                        int n4;
                        int n5;
                        do {
                            longArrayList.addLong(this.readSFixed64());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n4 = this.pos;
                        } while ((n5 = this.readVarint32()) == this.tag);
                        this.pos = n4;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
                return;
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    int n6 = this.readVarint32();
                    this.verifyPackedFixed64Length(n6);
                    int n7 = this.pos + n6;
                    while (this.pos < n7) {
                        target.add(this.readLittleEndian64_NoCheck());
                    }
                    break;
                }
                case 1: {
                    int n8;
                    int n9;
                    do {
                        target.add(this.readSFixed64());
                        if (this.isAtEnd()) {
                            return;
                        }
                        n8 = this.pos;
                    } while ((n9 = this.readVarint32()) == this.tag);
                    this.pos = n8;
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }

        @Override
        public final void readSInt32List(List<Integer> target) throws IOException {
            if (target instanceof IntArrayList) {
                IntArrayList intArrayList = (IntArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n2 = this.readVarint32();
                        int n3 = this.pos + n2;
                        while (this.pos < n3) {
                            intArrayList.addInt(CodedInputStream.decodeZigZag32(this.readVarint32()));
                        }
                        break;
                    }
                    case 0: {
                        int n4;
                        int n5;
                        do {
                            intArrayList.addInt(this.readSInt32());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n4 = this.pos;
                        } while ((n5 = this.readVarint32()) == this.tag);
                        this.pos = n4;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
                return;
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    int n6 = this.readVarint32();
                    int n7 = this.pos + n6;
                    while (this.pos < n7) {
                        target.add(CodedInputStream.decodeZigZag32(this.readVarint32()));
                    }
                    break;
                }
                case 0: {
                    int n8;
                    int n9;
                    do {
                        target.add(this.readSInt32());
                        if (this.isAtEnd()) {
                            return;
                        }
                        n8 = this.pos;
                    } while ((n9 = this.readVarint32()) == this.tag);
                    this.pos = n8;
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }

        @Override
        public final void readSInt64List(List<Long> target) throws IOException {
            if (target instanceof LongArrayList) {
                LongArrayList longArrayList = (LongArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n2 = this.readVarint32();
                        int n3 = this.pos + n2;
                        while (this.pos < n3) {
                            longArrayList.addLong(CodedInputStream.decodeZigZag64(this.readVarint64()));
                        }
                        break;
                    }
                    case 0: {
                        int n4;
                        int n5;
                        do {
                            longArrayList.addLong(this.readSInt64());
                            if (this.isAtEnd()) {
                                return;
                            }
                            n4 = this.pos;
                        } while ((n5 = this.readVarint32()) == this.tag);
                        this.pos = n4;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
                return;
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    int n6 = this.readVarint32();
                    int n7 = this.pos + n6;
                    while (this.pos < n7) {
                        target.add(CodedInputStream.decodeZigZag64(this.readVarint64()));
                    }
                    break;
                }
                case 0: {
                    int n8;
                    int n9;
                    do {
                        target.add(this.readSInt64());
                        if (this.isAtEnd()) {
                            return;
                        }
                        n8 = this.pos;
                    } while ((n9 = this.readVarint32()) == this.tag);
                    this.pos = n8;
                    return;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }

        @Override
        public final <K, V> void readMap(Map<K, V> target, MapEntryLite.Metadata<K, V> metadata, ExtensionRegistryLite extensionRegistry) throws IOException {
            int n2;
            this.requireWireType(2);
            int n3 = this.readVarint32();
            this.requireBytes(n3);
            int n4 = this.limit;
            this.limit = n2 = this.pos + n3;
            try {
                int n5;
                Object object = metadata.defaultKey;
                Object object2 = metadata.defaultValue;
                block9: while ((n5 = this.getFieldNumber()) != Integer.MAX_VALUE) {
                    try {
                        switch (n5) {
                            case 1: {
                                object = this.readField(metadata.keyType, null, null);
                                continue block9;
                            }
                            case 2: {
                                object2 = this.readField(metadata.valueType, metadata.defaultValue.getClass(), extensionRegistry);
                                continue block9;
                            }
                        }
                        if (this.skipField()) continue;
                        throw new InvalidProtocolBufferException("Unable to parse map entry.");
                    }
                    catch (InvalidProtocolBufferException.InvalidWireTypeException invalidWireTypeException) {
                        if (this.skipField()) continue;
                        throw new InvalidProtocolBufferException("Unable to parse map entry.");
                    }
                }
                target.put(object, object2);
                return;
            }
            finally {
                this.limit = n4;
            }
        }

        private Object readField(WireFormat.FieldType fieldType, Class<?> messageType, ExtensionRegistryLite extensionRegistry) throws IOException {
            switch (fieldType) {
                case BOOL: {
                    return this.readBool();
                }
                case BYTES: {
                    return this.readBytes();
                }
                case DOUBLE: {
                    return this.readDouble();
                }
                case ENUM: {
                    return this.readEnum();
                }
                case FIXED32: {
                    return this.readFixed32();
                }
                case FIXED64: {
                    return this.readFixed64();
                }
                case FLOAT: {
                    return Float.valueOf(this.readFloat());
                }
                case INT32: {
                    return this.readInt32();
                }
                case INT64: {
                    return this.readInt64();
                }
                case MESSAGE: {
                    return this.readMessage(messageType, extensionRegistry);
                }
                case SFIXED32: {
                    return this.readSFixed32();
                }
                case SFIXED64: {
                    return this.readSFixed64();
                }
                case SINT32: {
                    return this.readSInt32();
                }
                case SINT64: {
                    return this.readSInt64();
                }
                case STRING: {
                    return this.readStringRequireUtf8();
                }
                case UINT32: {
                    return this.readUInt32();
                }
                case UINT64: {
                    return this.readUInt64();
                }
            }
            throw new RuntimeException("unsupported field type.");
        }

        private int readVarint32() throws IOException {
            int n2;
            int n3 = this.pos;
            if (this.limit == this.pos) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            if ((n2 = this.buffer[n3++]) >= 0) {
                this.pos = n3;
                return n2;
            }
            if (this.limit - n3 < 9) {
                return (int)this.readVarint64SlowPath();
            }
            if ((n2 ^= this.buffer[n3++] << 7) < 0) {
                n2 ^= 0xFFFFFF80;
            } else if ((n2 ^= this.buffer[n3++] << 14) >= 0) {
                n2 ^= 0x3F80;
            } else if ((n2 ^= this.buffer[n3++] << 21) < 0) {
                n2 ^= 0xFFE03F80;
            } else {
                byte by = this.buffer[n3++];
                n2 ^= by << 28;
                n2 ^= 0xFE03F80;
                if (by < 0 && this.buffer[n3++] < 0 && this.buffer[n3++] < 0 && this.buffer[n3++] < 0 && this.buffer[n3++] < 0 && this.buffer[n3++] < 0) {
                    throw InvalidProtocolBufferException.malformedVarint();
                }
            }
            this.pos = n3;
            return n2;
        }

        public final long readVarint64() throws IOException {
            long l2;
            int n2;
            int n3 = this.pos;
            if (this.limit == n3) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            byte[] byArray = this.buffer;
            if ((n2 = this.buffer[n3++]) >= 0) {
                this.pos = n3;
                return n2;
            }
            if (this.limit - n3 < 9) {
                return this.readVarint64SlowPath();
            }
            if ((n2 ^= byArray[n3++] << 7) < 0) {
                l2 = n2 ^ 0xFFFFFF80;
            } else if ((n2 ^= byArray[n3++] << 14) >= 0) {
                l2 = n2 ^ 0x3F80;
            } else if ((n2 ^= byArray[n3++] << 21) < 0) {
                l2 = n2 ^ 0xFFE03F80;
            } else if ((l2 = (long)n2 ^ (long)byArray[n3++] << 28) >= 0L) {
                l2 ^= 0xFE03F80L;
            } else if ((l2 ^= (long)byArray[n3++] << 35) < 0L) {
                l2 ^= 0xFFFFFFF80FE03F80L;
            } else if ((l2 ^= (long)byArray[n3++] << 42) >= 0L) {
                l2 ^= 0x3F80FE03F80L;
            } else if ((l2 ^= (long)byArray[n3++] << 49) < 0L) {
                l2 ^= 0xFFFE03F80FE03F80L;
            } else {
                l2 ^= (long)byArray[n3++] << 56;
                if ((l2 ^= 0xFE03F80FE03F80L) < 0L && (long)byArray[n3++] < 0L) {
                    throw InvalidProtocolBufferException.malformedVarint();
                }
            }
            this.pos = n3;
            return l2;
        }

        private long readVarint64SlowPath() throws IOException {
            long l2 = 0L;
            for (int i2 = 0; i2 < 64; i2 += 7) {
                byte by = this.readByte();
                l2 |= (long)(by & 0x7F) << i2;
                if ((by & 0x80) != 0) continue;
                return l2;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        private byte readByte() throws IOException {
            if (this.pos == this.limit) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            return this.buffer[this.pos++];
        }

        private int readLittleEndian32() throws IOException {
            this.requireBytes(4);
            return this.readLittleEndian32_NoCheck();
        }

        private long readLittleEndian64() throws IOException {
            this.requireBytes(8);
            return this.readLittleEndian64_NoCheck();
        }

        private int readLittleEndian32_NoCheck() {
            int n2 = this.pos;
            byte[] byArray = this.buffer;
            this.pos = n2 + 4;
            return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 3] & 0xFF) << 24;
        }

        private long readLittleEndian64_NoCheck() {
            int n2 = this.pos;
            byte[] byArray = this.buffer;
            this.pos = n2 + 8;
            return (long)byArray[n2] & 0xFFL | ((long)byArray[n2 + 1] & 0xFFL) << 8 | ((long)byArray[n2 + 2] & 0xFFL) << 16 | ((long)byArray[n2 + 3] & 0xFFL) << 24 | ((long)byArray[n2 + 4] & 0xFFL) << 32 | ((long)byArray[n2 + 5] & 0xFFL) << 40 | ((long)byArray[n2 + 6] & 0xFFL) << 48 | ((long)byArray[n2 + 7] & 0xFFL) << 56;
        }

        private void skipVarint() throws IOException {
            if (this.limit - this.pos >= 10) {
                byte[] byArray = this.buffer;
                int n2 = this.pos;
                for (int i2 = 0; i2 < 10; ++i2) {
                    if (byArray[n2++] < 0) continue;
                    this.pos = n2;
                    return;
                }
            }
            this.skipVarintSlowPath();
        }

        private void skipVarintSlowPath() throws IOException {
            for (int i2 = 0; i2 < 10; ++i2) {
                if (this.readByte() < 0) continue;
                return;
            }
            throw InvalidProtocolBufferException.malformedVarint();
        }

        private void skipBytes(int size) throws IOException {
            this.requireBytes(size);
            this.pos += size;
        }

        private void skipGroup() throws IOException {
            int n2 = this.endGroupTag;
            this.endGroupTag = WireFormat.makeTag(WireFormat.getTagFieldNumber(this.tag), 4);
            while (this.getFieldNumber() != Integer.MAX_VALUE && this.skipField()) {
            }
            if (this.tag != this.endGroupTag) {
                throw InvalidProtocolBufferException.parseFailure();
            }
            this.endGroupTag = n2;
        }

        private void requireBytes(int size) throws IOException {
            if (size < 0 || size > this.limit - this.pos) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
        }

        private void requireWireType(int requiredWireType) throws IOException {
            if (WireFormat.getTagWireType(this.tag) != requiredWireType) {
                throw InvalidProtocolBufferException.invalidWireType();
            }
        }

        private void verifyPackedFixed64Length(int bytes) throws IOException {
            this.requireBytes(bytes);
            if ((bytes & 7) != 0) {
                throw InvalidProtocolBufferException.parseFailure();
            }
        }

        private void verifyPackedFixed32Length(int bytes) throws IOException {
            this.requireBytes(bytes);
            if ((bytes & 3) != 0) {
                throw InvalidProtocolBufferException.parseFailure();
            }
        }

        private void requirePosition(int expectedPosition) throws IOException {
            if (this.pos != expectedPosition) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
        }
    }
}

