/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.BooleanArrayList;
import ai.h2o.com.google.protobuf.ByteString;
import ai.h2o.com.google.protobuf.CheckReturnValue;
import ai.h2o.com.google.protobuf.CodedInputStream;
import ai.h2o.com.google.protobuf.DoubleArrayList;
import ai.h2o.com.google.protobuf.ExtensionRegistryLite;
import ai.h2o.com.google.protobuf.FloatArrayList;
import ai.h2o.com.google.protobuf.IntArrayList;
import ai.h2o.com.google.protobuf.Internal;
import ai.h2o.com.google.protobuf.InvalidProtocolBufferException;
import ai.h2o.com.google.protobuf.LazyStringList;
import ai.h2o.com.google.protobuf.LongArrayList;
import ai.h2o.com.google.protobuf.MapEntryLite;
import ai.h2o.com.google.protobuf.Protobuf;
import ai.h2o.com.google.protobuf.Reader;
import ai.h2o.com.google.protobuf.Schema;
import ai.h2o.com.google.protobuf.WireFormat;
import java.io.IOException;
import java.util.List;
import java.util.Map;

@CheckReturnValue
final class CodedInputStreamReader
implements Reader {
    private static final int FIXED32_MULTIPLE_MASK = 3;
    private static final int FIXED64_MULTIPLE_MASK = 7;
    private static final int NEXT_TAG_UNSET = 0;
    private final CodedInputStream input;
    private int tag;
    private int endGroupTag;
    private int nextTag = 0;

    public static CodedInputStreamReader forCodedInput(CodedInputStream input) {
        if (input.wrapper != null) {
            return input.wrapper;
        }
        return new CodedInputStreamReader(input);
    }

    private CodedInputStreamReader(CodedInputStream input) {
        this.input = Internal.checkNotNull(input, "input");
        this.input.wrapper = this;
    }

    @Override
    public final boolean shouldDiscardUnknownFields() {
        return this.input.shouldDiscardUnknownFields();
    }

    @Override
    public final int getFieldNumber() throws IOException {
        if (this.nextTag != 0) {
            this.tag = this.nextTag;
            this.nextTag = 0;
        } else {
            this.tag = this.input.readTag();
        }
        if (this.tag == 0 || this.tag == this.endGroupTag) {
            return Integer.MAX_VALUE;
        }
        return WireFormat.getTagFieldNumber(this.tag);
    }

    @Override
    public final int getTag() {
        return this.tag;
    }

    @Override
    public final boolean skipField() throws IOException {
        if (this.input.isAtEnd() || this.tag == this.endGroupTag) {
            return false;
        }
        return this.input.skipField(this.tag);
    }

    private void requireWireType(int requiredWireType) throws IOException {
        if (WireFormat.getTagWireType(this.tag) != requiredWireType) {
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    @Override
    public final double readDouble() throws IOException {
        this.requireWireType(1);
        return this.input.readDouble();
    }

    @Override
    public final float readFloat() throws IOException {
        this.requireWireType(5);
        return this.input.readFloat();
    }

    @Override
    public final long readUInt64() throws IOException {
        this.requireWireType(0);
        return this.input.readUInt64();
    }

    @Override
    public final long readInt64() throws IOException {
        this.requireWireType(0);
        return this.input.readInt64();
    }

    @Override
    public final int readInt32() throws IOException {
        this.requireWireType(0);
        return this.input.readInt32();
    }

    @Override
    public final long readFixed64() throws IOException {
        this.requireWireType(1);
        return this.input.readFixed64();
    }

    @Override
    public final int readFixed32() throws IOException {
        this.requireWireType(5);
        return this.input.readFixed32();
    }

    @Override
    public final boolean readBool() throws IOException {
        this.requireWireType(0);
        return this.input.readBool();
    }

    @Override
    public final String readString() throws IOException {
        this.requireWireType(2);
        return this.input.readString();
    }

    @Override
    public final String readStringRequireUtf8() throws IOException {
        this.requireWireType(2);
        return this.input.readStringRequireUtf8();
    }

    @Override
    public final <T> T readMessage(Class<T> clazz, ExtensionRegistryLite extensionRegistry) throws IOException {
        this.requireWireType(2);
        return (T)this.readMessage(Protobuf.getInstance().schemaFor(clazz), extensionRegistry);
    }

    @Override
    public final <T> T readMessageBySchemaWithCheck(Schema<T> schema, ExtensionRegistryLite extensionRegistry) throws IOException {
        this.requireWireType(2);
        return this.readMessage(schema, extensionRegistry);
    }

    @Override
    @Deprecated
    public final <T> T readGroup(Class<T> clazz, ExtensionRegistryLite extensionRegistry) throws IOException {
        this.requireWireType(3);
        return (T)this.readGroup(Protobuf.getInstance().schemaFor(clazz), extensionRegistry);
    }

    @Override
    @Deprecated
    public final <T> T readGroupBySchemaWithCheck(Schema<T> schema, ExtensionRegistryLite extensionRegistry) throws IOException {
        this.requireWireType(3);
        return this.readGroup(schema, extensionRegistry);
    }

    private <T> T readMessage(Schema<T> schema, ExtensionRegistryLite extensionRegistry) throws IOException {
        int n2 = this.input.readUInt32();
        if (this.input.recursionDepth >= this.input.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        int n3 = this.input.pushLimit(n2);
        T t2 = schema.newInstance();
        ++this.input.recursionDepth;
        schema.mergeFrom(t2, this, extensionRegistry);
        schema.makeImmutable(t2);
        this.input.checkLastTagWas(0);
        --this.input.recursionDepth;
        this.input.popLimit(n3);
        return t2;
    }

    private <T> T readGroup(Schema<T> schema, ExtensionRegistryLite extensionRegistry) throws IOException {
        int n2 = this.endGroupTag;
        this.endGroupTag = WireFormat.makeTag(WireFormat.getTagFieldNumber(this.tag), 4);
        try {
            T t2 = schema.newInstance();
            schema.mergeFrom(t2, this, extensionRegistry);
            schema.makeImmutable(t2);
            if (this.tag != this.endGroupTag) {
                throw InvalidProtocolBufferException.parseFailure();
            }
            T t3 = t2;
            return t3;
        }
        finally {
            this.endGroupTag = n2;
        }
    }

    @Override
    public final ByteString readBytes() throws IOException {
        this.requireWireType(2);
        return this.input.readBytes();
    }

    @Override
    public final int readUInt32() throws IOException {
        this.requireWireType(0);
        return this.input.readUInt32();
    }

    @Override
    public final int readEnum() throws IOException {
        this.requireWireType(0);
        return this.input.readEnum();
    }

    @Override
    public final int readSFixed32() throws IOException {
        this.requireWireType(5);
        return this.input.readSFixed32();
    }

    @Override
    public final long readSFixed64() throws IOException {
        this.requireWireType(1);
        return this.input.readSFixed64();
    }

    @Override
    public final int readSInt32() throws IOException {
        this.requireWireType(0);
        return this.input.readSInt32();
    }

    @Override
    public final long readSInt64() throws IOException {
        this.requireWireType(0);
        return this.input.readSInt64();
    }

    @Override
    public final void readDoubleList(List<Double> target) throws IOException {
        block13: {
            block12: {
                if (!(target instanceof DoubleArrayList)) break block12;
                DoubleArrayList doubleArrayList = (DoubleArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n2 = this.input.readUInt32();
                        this.verifyPackedFixed64Length(n2);
                        int n3 = this.input.getTotalBytesRead() + n2;
                        do {
                            doubleArrayList.addDouble(this.input.readDouble());
                        } while (this.input.getTotalBytesRead() < n3);
                        break block13;
                    }
                    case 1: {
                        int n4;
                        do {
                            doubleArrayList.addDouble(this.input.readDouble());
                            if (!this.input.isAtEnd()) continue;
                            return;
                        } while ((n4 = this.input.readTag()) == this.tag);
                        this.nextTag = n4;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    int n5 = this.input.readUInt32();
                    this.verifyPackedFixed64Length(n5);
                    int n6 = this.input.getTotalBytesRead() + n5;
                    do {
                        target.add(this.input.readDouble());
                    } while (this.input.getTotalBytesRead() < n6);
                    return;
                }
                case 1: {
                    int n7;
                    do {
                        target.add(this.input.readDouble());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((n7 = this.input.readTag()) == this.tag);
                    this.nextTag = n7;
                    return;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    @Override
    public final void readFloatList(List<Float> target) throws IOException {
        block13: {
            block12: {
                if (!(target instanceof FloatArrayList)) break block12;
                FloatArrayList floatArrayList = (FloatArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n2 = this.input.readUInt32();
                        this.verifyPackedFixed32Length(n2);
                        int n3 = this.input.getTotalBytesRead() + n2;
                        do {
                            floatArrayList.addFloat(this.input.readFloat());
                        } while (this.input.getTotalBytesRead() < n3);
                        break block13;
                    }
                    case 5: {
                        int n4;
                        do {
                            floatArrayList.addFloat(this.input.readFloat());
                            if (!this.input.isAtEnd()) continue;
                            return;
                        } while ((n4 = this.input.readTag()) == this.tag);
                        this.nextTag = n4;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    int n5 = this.input.readUInt32();
                    this.verifyPackedFixed32Length(n5);
                    int n6 = this.input.getTotalBytesRead() + n5;
                    do {
                        target.add(Float.valueOf(this.input.readFloat()));
                    } while (this.input.getTotalBytesRead() < n6);
                    return;
                }
                case 5: {
                    int n7;
                    do {
                        target.add(Float.valueOf(this.input.readFloat()));
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((n7 = this.input.readTag()) == this.tag);
                    this.nextTag = n7;
                    return;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    @Override
    public final void readUInt64List(List<Long> target) throws IOException {
        block13: {
            block12: {
                if (!(target instanceof LongArrayList)) break block12;
                LongArrayList longArrayList = (LongArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n2 = this.input.readUInt32();
                        int n3 = this.input.getTotalBytesRead() + n2;
                        do {
                            longArrayList.addLong(this.input.readUInt64());
                        } while (this.input.getTotalBytesRead() < n3);
                        this.requirePosition(n3);
                        break block13;
                    }
                    case 0: {
                        int n4;
                        do {
                            longArrayList.addLong(this.input.readUInt64());
                            if (!this.input.isAtEnd()) continue;
                            return;
                        } while ((n4 = this.input.readTag()) == this.tag);
                        this.nextTag = n4;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    int n5 = this.input.readUInt32();
                    int n6 = this.input.getTotalBytesRead() + n5;
                    do {
                        target.add(this.input.readUInt64());
                    } while (this.input.getTotalBytesRead() < n6);
                    this.requirePosition(n6);
                    return;
                }
                case 0: {
                    int n7;
                    do {
                        target.add(this.input.readUInt64());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((n7 = this.input.readTag()) == this.tag);
                    this.nextTag = n7;
                    return;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    @Override
    public final void readInt64List(List<Long> target) throws IOException {
        block13: {
            block12: {
                if (!(target instanceof LongArrayList)) break block12;
                LongArrayList longArrayList = (LongArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n2 = this.input.readUInt32();
                        int n3 = this.input.getTotalBytesRead() + n2;
                        do {
                            longArrayList.addLong(this.input.readInt64());
                        } while (this.input.getTotalBytesRead() < n3);
                        this.requirePosition(n3);
                        break block13;
                    }
                    case 0: {
                        int n4;
                        do {
                            longArrayList.addLong(this.input.readInt64());
                            if (!this.input.isAtEnd()) continue;
                            return;
                        } while ((n4 = this.input.readTag()) == this.tag);
                        this.nextTag = n4;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    int n5 = this.input.readUInt32();
                    int n6 = this.input.getTotalBytesRead() + n5;
                    do {
                        target.add(this.input.readInt64());
                    } while (this.input.getTotalBytesRead() < n6);
                    this.requirePosition(n6);
                    return;
                }
                case 0: {
                    int n7;
                    do {
                        target.add(this.input.readInt64());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((n7 = this.input.readTag()) == this.tag);
                    this.nextTag = n7;
                    return;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    @Override
    public final void readInt32List(List<Integer> target) throws IOException {
        block13: {
            block12: {
                if (!(target instanceof IntArrayList)) break block12;
                IntArrayList intArrayList = (IntArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n2 = this.input.readUInt32();
                        int n3 = this.input.getTotalBytesRead() + n2;
                        do {
                            intArrayList.addInt(this.input.readInt32());
                        } while (this.input.getTotalBytesRead() < n3);
                        this.requirePosition(n3);
                        break block13;
                    }
                    case 0: {
                        int n4;
                        do {
                            intArrayList.addInt(this.input.readInt32());
                            if (!this.input.isAtEnd()) continue;
                            return;
                        } while ((n4 = this.input.readTag()) == this.tag);
                        this.nextTag = n4;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    int n5 = this.input.readUInt32();
                    int n6 = this.input.getTotalBytesRead() + n5;
                    do {
                        target.add(this.input.readInt32());
                    } while (this.input.getTotalBytesRead() < n6);
                    this.requirePosition(n6);
                    return;
                }
                case 0: {
                    int n7;
                    do {
                        target.add(this.input.readInt32());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((n7 = this.input.readTag()) == this.tag);
                    this.nextTag = n7;
                    return;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    @Override
    public final void readFixed64List(List<Long> target) throws IOException {
        block13: {
            block12: {
                if (!(target instanceof LongArrayList)) break block12;
                LongArrayList longArrayList = (LongArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n2 = this.input.readUInt32();
                        this.verifyPackedFixed64Length(n2);
                        int n3 = this.input.getTotalBytesRead() + n2;
                        do {
                            longArrayList.addLong(this.input.readFixed64());
                        } while (this.input.getTotalBytesRead() < n3);
                        break block13;
                    }
                    case 1: {
                        int n4;
                        do {
                            longArrayList.addLong(this.input.readFixed64());
                            if (!this.input.isAtEnd()) continue;
                            return;
                        } while ((n4 = this.input.readTag()) == this.tag);
                        this.nextTag = n4;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    int n5 = this.input.readUInt32();
                    this.verifyPackedFixed64Length(n5);
                    int n6 = this.input.getTotalBytesRead() + n5;
                    do {
                        target.add(this.input.readFixed64());
                    } while (this.input.getTotalBytesRead() < n6);
                    return;
                }
                case 1: {
                    int n7;
                    do {
                        target.add(this.input.readFixed64());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((n7 = this.input.readTag()) == this.tag);
                    this.nextTag = n7;
                    return;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    @Override
    public final void readFixed32List(List<Integer> target) throws IOException {
        block13: {
            block12: {
                if (!(target instanceof IntArrayList)) break block12;
                IntArrayList intArrayList = (IntArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n2 = this.input.readUInt32();
                        this.verifyPackedFixed32Length(n2);
                        int n3 = this.input.getTotalBytesRead() + n2;
                        do {
                            intArrayList.addInt(this.input.readFixed32());
                        } while (this.input.getTotalBytesRead() < n3);
                        break block13;
                    }
                    case 5: {
                        int n4;
                        do {
                            intArrayList.addInt(this.input.readFixed32());
                            if (!this.input.isAtEnd()) continue;
                            return;
                        } while ((n4 = this.input.readTag()) == this.tag);
                        this.nextTag = n4;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    int n5 = this.input.readUInt32();
                    this.verifyPackedFixed32Length(n5);
                    int n6 = this.input.getTotalBytesRead() + n5;
                    do {
                        target.add(this.input.readFixed32());
                    } while (this.input.getTotalBytesRead() < n6);
                    return;
                }
                case 5: {
                    int n7;
                    do {
                        target.add(this.input.readFixed32());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((n7 = this.input.readTag()) == this.tag);
                    this.nextTag = n7;
                    return;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    @Override
    public final void readBoolList(List<Boolean> target) throws IOException {
        block13: {
            block12: {
                if (!(target instanceof BooleanArrayList)) break block12;
                BooleanArrayList booleanArrayList = (BooleanArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n2 = this.input.readUInt32();
                        int n3 = this.input.getTotalBytesRead() + n2;
                        do {
                            booleanArrayList.addBoolean(this.input.readBool());
                        } while (this.input.getTotalBytesRead() < n3);
                        this.requirePosition(n3);
                        break block13;
                    }
                    case 0: {
                        int n4;
                        do {
                            booleanArrayList.addBoolean(this.input.readBool());
                            if (!this.input.isAtEnd()) continue;
                            return;
                        } while ((n4 = this.input.readTag()) == this.tag);
                        this.nextTag = n4;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    int n5 = this.input.readUInt32();
                    int n6 = this.input.getTotalBytesRead() + n5;
                    do {
                        target.add(this.input.readBool());
                    } while (this.input.getTotalBytesRead() < n6);
                    this.requirePosition(n6);
                    return;
                }
                case 0: {
                    int n7;
                    do {
                        target.add(this.input.readBool());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((n7 = this.input.readTag()) == this.tag);
                    this.nextTag = n7;
                    return;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    @Override
    public final void readStringList(List<String> target) throws IOException {
        this.readStringListInternal(target, false);
    }

    @Override
    public final void readStringListRequireUtf8(List<String> target) throws IOException {
        this.readStringListInternal(target, true);
    }

    public final void readStringListInternal(List<String> target, boolean requireUtf8) throws IOException {
        int n2;
        if (WireFormat.getTagWireType(this.tag) != 2) {
            throw InvalidProtocolBufferException.invalidWireType();
        }
        if (target instanceof LazyStringList && !requireUtf8) {
            int n3;
            LazyStringList lazyStringList = (LazyStringList)target;
            do {
                lazyStringList.add(this.readBytes());
                if (!this.input.isAtEnd()) continue;
                return;
            } while ((n3 = this.input.readTag()) == this.tag);
            this.nextTag = n3;
            return;
        }
        do {
            target.add(requireUtf8 ? this.readStringRequireUtf8() : this.readString());
            if (!this.input.isAtEnd()) continue;
            return;
        } while ((n2 = this.input.readTag()) == this.tag);
        this.nextTag = n2;
    }

    @Override
    public final <T> void readMessageList(List<T> target, Class<T> targetType, ExtensionRegistryLite extensionRegistry) throws IOException {
        Schema<Class<T>> schema = Protobuf.getInstance().schemaFor(targetType);
        this.readMessageList(target, schema, extensionRegistry);
    }

    @Override
    public final <T> void readMessageList(List<T> target, Schema<T> schema, ExtensionRegistryLite extensionRegistry) throws IOException {
        int n2;
        if (WireFormat.getTagWireType(this.tag) != 2) {
            throw InvalidProtocolBufferException.invalidWireType();
        }
        int n3 = this.tag;
        do {
            target.add(this.readMessage(schema, extensionRegistry));
            if (!this.input.isAtEnd() && this.nextTag == 0) continue;
            return;
        } while ((n2 = this.input.readTag()) == n3);
        this.nextTag = n2;
    }

    @Override
    @Deprecated
    public final <T> void readGroupList(List<T> target, Class<T> targetType, ExtensionRegistryLite extensionRegistry) throws IOException {
        Schema<Class<T>> schema = Protobuf.getInstance().schemaFor(targetType);
        this.readGroupList(target, schema, extensionRegistry);
    }

    @Override
    @Deprecated
    public final <T> void readGroupList(List<T> target, Schema<T> schema, ExtensionRegistryLite extensionRegistry) throws IOException {
        int n2;
        if (WireFormat.getTagWireType(this.tag) != 3) {
            throw InvalidProtocolBufferException.invalidWireType();
        }
        int n3 = this.tag;
        do {
            target.add(this.readGroup(schema, extensionRegistry));
            if (!this.input.isAtEnd() && this.nextTag == 0) continue;
            return;
        } while ((n2 = this.input.readTag()) == n3);
        this.nextTag = n2;
    }

    @Override
    public final void readBytesList(List<ByteString> target) throws IOException {
        int n2;
        if (WireFormat.getTagWireType(this.tag) != 2) {
            throw InvalidProtocolBufferException.invalidWireType();
        }
        do {
            target.add(this.readBytes());
            if (!this.input.isAtEnd()) continue;
            return;
        } while ((n2 = this.input.readTag()) == this.tag);
        this.nextTag = n2;
    }

    @Override
    public final void readUInt32List(List<Integer> target) throws IOException {
        block13: {
            block12: {
                if (!(target instanceof IntArrayList)) break block12;
                IntArrayList intArrayList = (IntArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n2 = this.input.readUInt32();
                        int n3 = this.input.getTotalBytesRead() + n2;
                        do {
                            intArrayList.addInt(this.input.readUInt32());
                        } while (this.input.getTotalBytesRead() < n3);
                        this.requirePosition(n3);
                        break block13;
                    }
                    case 0: {
                        int n4;
                        do {
                            intArrayList.addInt(this.input.readUInt32());
                            if (!this.input.isAtEnd()) continue;
                            return;
                        } while ((n4 = this.input.readTag()) == this.tag);
                        this.nextTag = n4;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    int n5 = this.input.readUInt32();
                    int n6 = this.input.getTotalBytesRead() + n5;
                    do {
                        target.add(this.input.readUInt32());
                    } while (this.input.getTotalBytesRead() < n6);
                    this.requirePosition(n6);
                    return;
                }
                case 0: {
                    int n7;
                    do {
                        target.add(this.input.readUInt32());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((n7 = this.input.readTag()) == this.tag);
                    this.nextTag = n7;
                    return;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    @Override
    public final void readEnumList(List<Integer> target) throws IOException {
        block13: {
            block12: {
                if (!(target instanceof IntArrayList)) break block12;
                IntArrayList intArrayList = (IntArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n2 = this.input.readUInt32();
                        int n3 = this.input.getTotalBytesRead() + n2;
                        do {
                            intArrayList.addInt(this.input.readEnum());
                        } while (this.input.getTotalBytesRead() < n3);
                        this.requirePosition(n3);
                        break block13;
                    }
                    case 0: {
                        int n4;
                        do {
                            intArrayList.addInt(this.input.readEnum());
                            if (!this.input.isAtEnd()) continue;
                            return;
                        } while ((n4 = this.input.readTag()) == this.tag);
                        this.nextTag = n4;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    int n5 = this.input.readUInt32();
                    int n6 = this.input.getTotalBytesRead() + n5;
                    do {
                        target.add(this.input.readEnum());
                    } while (this.input.getTotalBytesRead() < n6);
                    this.requirePosition(n6);
                    return;
                }
                case 0: {
                    int n7;
                    do {
                        target.add(this.input.readEnum());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((n7 = this.input.readTag()) == this.tag);
                    this.nextTag = n7;
                    return;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    @Override
    public final void readSFixed32List(List<Integer> target) throws IOException {
        block13: {
            block12: {
                if (!(target instanceof IntArrayList)) break block12;
                IntArrayList intArrayList = (IntArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n2 = this.input.readUInt32();
                        this.verifyPackedFixed32Length(n2);
                        int n3 = this.input.getTotalBytesRead() + n2;
                        do {
                            intArrayList.addInt(this.input.readSFixed32());
                        } while (this.input.getTotalBytesRead() < n3);
                        break block13;
                    }
                    case 5: {
                        int n4;
                        do {
                            intArrayList.addInt(this.input.readSFixed32());
                            if (!this.input.isAtEnd()) continue;
                            return;
                        } while ((n4 = this.input.readTag()) == this.tag);
                        this.nextTag = n4;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    int n5 = this.input.readUInt32();
                    this.verifyPackedFixed32Length(n5);
                    int n6 = this.input.getTotalBytesRead() + n5;
                    do {
                        target.add(this.input.readSFixed32());
                    } while (this.input.getTotalBytesRead() < n6);
                    return;
                }
                case 5: {
                    int n7;
                    do {
                        target.add(this.input.readSFixed32());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((n7 = this.input.readTag()) == this.tag);
                    this.nextTag = n7;
                    return;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    @Override
    public final void readSFixed64List(List<Long> target) throws IOException {
        block13: {
            block12: {
                if (!(target instanceof LongArrayList)) break block12;
                LongArrayList longArrayList = (LongArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n2 = this.input.readUInt32();
                        this.verifyPackedFixed64Length(n2);
                        int n3 = this.input.getTotalBytesRead() + n2;
                        do {
                            longArrayList.addLong(this.input.readSFixed64());
                        } while (this.input.getTotalBytesRead() < n3);
                        break block13;
                    }
                    case 1: {
                        int n4;
                        do {
                            longArrayList.addLong(this.input.readSFixed64());
                            if (!this.input.isAtEnd()) continue;
                            return;
                        } while ((n4 = this.input.readTag()) == this.tag);
                        this.nextTag = n4;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    int n5 = this.input.readUInt32();
                    this.verifyPackedFixed64Length(n5);
                    int n6 = this.input.getTotalBytesRead() + n5;
                    do {
                        target.add(this.input.readSFixed64());
                    } while (this.input.getTotalBytesRead() < n6);
                    return;
                }
                case 1: {
                    int n7;
                    do {
                        target.add(this.input.readSFixed64());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((n7 = this.input.readTag()) == this.tag);
                    this.nextTag = n7;
                    return;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    @Override
    public final void readSInt32List(List<Integer> target) throws IOException {
        block13: {
            block12: {
                if (!(target instanceof IntArrayList)) break block12;
                IntArrayList intArrayList = (IntArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n2 = this.input.readUInt32();
                        int n3 = this.input.getTotalBytesRead() + n2;
                        do {
                            intArrayList.addInt(this.input.readSInt32());
                        } while (this.input.getTotalBytesRead() < n3);
                        this.requirePosition(n3);
                        break block13;
                    }
                    case 0: {
                        int n4;
                        do {
                            intArrayList.addInt(this.input.readSInt32());
                            if (!this.input.isAtEnd()) continue;
                            return;
                        } while ((n4 = this.input.readTag()) == this.tag);
                        this.nextTag = n4;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    int n5 = this.input.readUInt32();
                    int n6 = this.input.getTotalBytesRead() + n5;
                    do {
                        target.add(this.input.readSInt32());
                    } while (this.input.getTotalBytesRead() < n6);
                    this.requirePosition(n6);
                    return;
                }
                case 0: {
                    int n7;
                    do {
                        target.add(this.input.readSInt32());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((n7 = this.input.readTag()) == this.tag);
                    this.nextTag = n7;
                    return;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    @Override
    public final void readSInt64List(List<Long> target) throws IOException {
        block13: {
            block12: {
                if (!(target instanceof LongArrayList)) break block12;
                LongArrayList longArrayList = (LongArrayList)target;
                switch (WireFormat.getTagWireType(this.tag)) {
                    case 2: {
                        int n2 = this.input.readUInt32();
                        int n3 = this.input.getTotalBytesRead() + n2;
                        do {
                            longArrayList.addLong(this.input.readSInt64());
                        } while (this.input.getTotalBytesRead() < n3);
                        this.requirePosition(n3);
                        break block13;
                    }
                    case 0: {
                        int n4;
                        do {
                            longArrayList.addLong(this.input.readSInt64());
                            if (!this.input.isAtEnd()) continue;
                            return;
                        } while ((n4 = this.input.readTag()) == this.tag);
                        this.nextTag = n4;
                        return;
                    }
                    default: {
                        throw InvalidProtocolBufferException.invalidWireType();
                    }
                }
            }
            switch (WireFormat.getTagWireType(this.tag)) {
                case 2: {
                    int n5 = this.input.readUInt32();
                    int n6 = this.input.getTotalBytesRead() + n5;
                    do {
                        target.add(this.input.readSInt64());
                    } while (this.input.getTotalBytesRead() < n6);
                    this.requirePosition(n6);
                    return;
                }
                case 0: {
                    int n7;
                    do {
                        target.add(this.input.readSInt64());
                        if (!this.input.isAtEnd()) continue;
                        return;
                    } while ((n7 = this.input.readTag()) == this.tag);
                    this.nextTag = n7;
                    return;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }
    }

    private void verifyPackedFixed64Length(int bytes) throws IOException {
        if ((bytes & 7) != 0) {
            throw InvalidProtocolBufferException.parseFailure();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final <K, V> void readMap(Map<K, V> target, MapEntryLite.Metadata<K, V> metadata, ExtensionRegistryLite extensionRegistry) throws IOException {
        this.requireWireType(2);
        int n2 = this.input.readUInt32();
        int n3 = this.input.pushLimit(n2);
        Object object = metadata.defaultKey;
        Object object2 = metadata.defaultValue;
        try {
            int n4;
            block9: while ((n4 = this.getFieldNumber()) != Integer.MAX_VALUE && !this.input.isAtEnd()) {
                try {
                    switch (n4) {
                        case 1: {
                            object = this.readField(metadata.keyType, null, null);
                            continue block9;
                        }
                        case 2: {
                            object2 = this.readField(metadata.valueType, metadata.defaultValue.getClass(), extensionRegistry);
                            continue block9;
                        }
                    }
                    if (this.skipField()) continue;
                    throw new InvalidProtocolBufferException("Unable to parse map entry.");
                }
                catch (InvalidProtocolBufferException.InvalidWireTypeException invalidWireTypeException) {
                    if (this.skipField()) continue;
                    throw new InvalidProtocolBufferException("Unable to parse map entry.");
                }
            }
            target.put(object, object2);
            return;
        }
        finally {
            this.input.popLimit(n3);
        }
    }

    private Object readField(WireFormat.FieldType fieldType, Class<?> messageType, ExtensionRegistryLite extensionRegistry) throws IOException {
        switch (fieldType) {
            case BOOL: {
                return this.readBool();
            }
            case BYTES: {
                return this.readBytes();
            }
            case DOUBLE: {
                return this.readDouble();
            }
            case ENUM: {
                return this.readEnum();
            }
            case FIXED32: {
                return this.readFixed32();
            }
            case FIXED64: {
                return this.readFixed64();
            }
            case FLOAT: {
                return Float.valueOf(this.readFloat());
            }
            case INT32: {
                return this.readInt32();
            }
            case INT64: {
                return this.readInt64();
            }
            case MESSAGE: {
                return this.readMessage(messageType, extensionRegistry);
            }
            case SFIXED32: {
                return this.readSFixed32();
            }
            case SFIXED64: {
                return this.readSFixed64();
            }
            case SINT32: {
                return this.readSInt32();
            }
            case SINT64: {
                return this.readSInt64();
            }
            case STRING: {
                return this.readStringRequireUtf8();
            }
            case UINT32: {
                return this.readUInt32();
            }
            case UINT64: {
                return this.readUInt64();
            }
        }
        throw new IllegalArgumentException("unsupported field type.");
    }

    private void verifyPackedFixed32Length(int bytes) throws IOException {
        if ((bytes & 3) != 0) {
            throw InvalidProtocolBufferException.parseFailure();
        }
    }

    private void requirePosition(int expectedPosition) throws IOException {
        if (this.input.getTotalBytesRead() != expectedPosition) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
    }
}

